/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import jp.sourceforge.chaplet.Configuration;
import jp.sourceforge.chaplet.Plugin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigLoader {
    private static ConfigLoader instance = new ConfigLoader();
    private Configuration conf;
    private ArrayList pluginList = new ArrayList();
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.chaplet.ConfigLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private ConfigLoader() {
    }

    public static ConfigLoader getInstance() {
        if (ConfigLoader.instance.conf == null) {
            try {
                ConfigLoader.instance.conf = instance.loadInternal();
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
            }
        }
        return instance;
    }

    private Configuration loadInternal() throws IOException {
        FileInputStream inStream = null;
        File workDir = this.getWorkDir();
        try {
            inStream = new FileInputStream(String.valueOf(workDir.getAbsolutePath()) + File.separator + "chaplet.properties");
            Properties prop = new Properties();
            prop.load(inStream);
            this.conf = new Configuration();
            this.conf.setSessionId(prop.getProperty("user.sessionId"));
            this.conf.setName(prop.getProperty("user.name"));
            if (this.conf.getName() == null) {
                this.conf.setName("");
            }
            this.conf.setUrl(prop.getProperty("server.url"));
            if (this.conf.getUrl() == null) {
                this.conf.setUrl("");
            }
            try {
                this.conf.setPort(Integer.parseInt(prop.getProperty("server.port")));
            }
            catch (NumberFormatException e1) {
                this.conf.setPort(10001);
            }
            this.conf.setProperties(prop);
        }
        catch (FileNotFoundException e) {
            this.conf = new Configuration();
            Properties prop = new Properties();
            this.conf.setProperties(prop);
        }
        this.conf.pluginList = this.loadPlugins();
        return this.conf;
    }

    public Configuration load() {
        return this.conf;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store(Configuration conf) throws IOException {
        File workDir = this.getWorkDir();
        String fileName = String.valueOf(workDir.getAbsolutePath()) + File.separator + "chaplet.properties";
        Properties prop = conf.getProperties();
        if (conf.getSessionId() != null) {
            prop.setProperty("user.sessionId", conf.getSessionId());
        }
        if (conf.getName() != null) {
            prop.setProperty("user.name", conf.getName());
        }
        if (conf.getUrl() != null) {
            prop.setProperty("server.url", conf.getUrl());
        }
        prop.setProperty("server.port", String.valueOf(conf.getPort()));
        Properties properties = prop;
        FileOutputStream outStream = new FileOutputStream(fileName);
        try {
            prop.store(outStream, null);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            outStream.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        outStream.close();
    }

    public File getWorkDir() {
        File file;
        String workdir = System.getProperty("jp.sf.chaplet.workdir");
        if (workdir == null) {
            workdir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".chaplet";
        }
        if (!(file = new File(workdir)).exists() && !file.mkdir()) {
            log.error((Object)("cannot create workdir : " + workdir));
            return null;
        }
        return file;
    }

    public InputStream openConfigFileForRead(String fileName) throws IOException {
        File file = new File(this.getWorkDir(), fileName);
        if (!file.exists() && file.createNewFile()) {
            throw new IOException(String.valueOf(fileName) + " is not found and not failed to creat.");
        }
        return new FileInputStream(file);
    }

    public InputStream openSystemFileForRead(String fileName) throws IOException {
        File file = new File("." + File.separator + fileName);
        if (!file.exists() && file.createNewFile()) {
            throw new IOException(String.valueOf(fileName) + " is not found and not failed to creat.");
        }
        return new FileInputStream(file);
    }

    ArrayList loadPlugins() {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        File systemDir = new File(System.getProperty("user.dir"));
        File[] files = systemDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int i = 0;
        while (i < files.length) {
            try {
                JarFile file = new JarFile(files[i]);
                Attributes attributes = file.getManifest().getAttributes("plugin");
                if (attributes != null) {
                    String pluginId = attributes.getValue("plugin-id");
                    String name = attributes.getValue("plugin-name");
                    String version = attributes.getValue("plugin-version");
                    String clientName = attributes.getValue("client");
                    String serverName = attributes.getValue("server");
                    String primary = attributes.getValue("primary");
                    if (pluginId != null && name != null && version != null && clientName != null && serverName != null) {
                        Plugin plugin = new Plugin(pluginId, name, version, serverName, clientName, primary != null && primary.equals("yes"));
                        list.add(plugin);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"pluginLoader", (Throwable)e);
            }
            ++i;
        }
        return list;
    }

    void instansiatePlugins() {
        Iterator iter = this.conf.pluginIterator();
        while (iter.hasNext()) {
            Plugin plugin = (Plugin)iter.next();
            try {
                plugin.instansiate();
            }
            catch (Exception e) {
                log.error((Object)"ConfigLoader", (Throwable)e);
            }
        }
    }
}

