/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.client;

import jp.sourceforge.chaplet.ActionResult;
import jp.sourceforge.chaplet.UserStatus;
import jp.sourceforge.chaplet.core.client.ChatClient;
import jp.sourceforge.chaplet.core.client.ClientPlugin;
import jp.sourceforge.chaplet.core.ui.IMainView;

public abstract class ClientAction {
    private ChatClient client;
    private ClientPlugin plugin;
    public static final Time PARENT_FIRST = new Time(){

        public ActionResult responseRecieved(ClientAction parent, ClientAction child, String[] response) {
            if (parent != null) {
                ActionResult result = parent.responseRecieved(response);
                if (result == ActionResult.OK_NEXT && child != null) {
                    return child.responseRecieved(response);
                }
                return result;
            }
            if (child != null) {
                return child.responseRecieved(response);
            }
            return ActionResult.NULL;
        }

        public ActionResult messageRecieved(ClientAction parent, ClientAction child, String[] message) {
            if (parent != null) {
                ActionResult result = parent.messageRecieved(message);
                if (result == ActionResult.OK_NEXT && child != null) {
                    return child.messageRecieved(message);
                }
                return result;
            }
            if (child != null) {
                return child.messageRecieved(message);
            }
            return ActionResult.NULL;
        }
    };
    public static final Time CHILD_FIRST = new Time(){

        public ActionResult responseRecieved(ClientAction parent, ClientAction child, String[] response) {
            if (child != null) {
                ActionResult result = child.responseRecieved(response);
                if (result == ActionResult.OK_NEXT && parent != null) {
                    return parent.responseRecieved(response);
                }
                return result;
            }
            if (parent != null) {
                return parent.responseRecieved(response);
            }
            return ActionResult.NULL;
        }

        public ActionResult messageRecieved(ClientAction parent, ClientAction child, String[] message) {
            if (child != null) {
                ActionResult result = child.messageRecieved(message);
                if (result == ActionResult.OK_NEXT && parent != null) {
                    return parent.messageRecieved(message);
                }
                return result;
            }
            if (parent != null) {
                return parent.messageRecieved(message);
            }
            return ActionResult.NULL;
        }
    };
    public static final Time CHILD_ONLY = new Time(){

        public ActionResult responseRecieved(ClientAction parent, ClientAction child, String[] response) {
            return child.responseRecieved(response);
        }

        public ActionResult messageRecieved(ClientAction parent, ClientAction child, String[] message) {
            return child.messageRecieved(message);
        }
    };
    public static final Time WAIT_FOR_PARENT_CALL = new Time(){

        public ActionResult responseRecieved(ClientAction parent, ClientAction child, String[] response) {
            return parent.responseRecieved(response);
        }

        public ActionResult messageRecieved(ClientAction parent, ClientAction child, String[] message) {
            return parent.messageRecieved(message);
        }
    };

    public Time getExecutionTime() {
        return PARENT_FIRST;
    }

    public void init(ChatClient client, ClientPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
    }

    public ClientPlugin getPlugin() {
        return this.plugin;
    }

    public ActionResult responseRecieved(String[] response) {
        return ActionResult.OK_NEXT;
    }

    public ActionResult messageRecieved(String[] message) {
        return ActionResult.OK_NEXT;
    }

    public IMainView getMainView() {
        return this.client.getView();
    }

    public void showStatus(UserStatus[] status) {
        this.client.showStatus(status);
    }

    public void appendLog(String[] log) {
        this.client.getView().appendLog(log);
    }

    public void appendSystemLog(String log) {
        this.client.getView().appendSystemLog(log);
    }

    public void appendFunctionLog(String funcName, String name, String log) {
        this.client.getView().appendFunctionLog(funcName, name, log);
    }

    ChatClient getClient() {
        return this.client;
    }

    public static abstract class Time {
        public abstract ActionResult responseRecieved(ClientAction var1, ClientAction var2, String[] var3);

        public abstract ActionResult messageRecieved(ClientAction var1, ClientAction var2, String[] var3);
    }
}

