/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.server;

import java.util.HashMap;
import java.util.Properties;
import jp.sourceforge.chaplet.core.server.ChatServer;
import jp.sourceforge.chaplet.core.server.ClientProxy;
import jp.sourceforge.chaplet.core.server.ServerAction;
import jp.sourceforge.chaplet.core.server.User;

public abstract class ServerPlugin {
    protected ChatServer server;
    private HashMap actionMap = new HashMap();

    public final void init(ChatServer server) throws Exception {
        this.server = server;
        this.init();
    }

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public void save() throws Exception {
    }

    protected void addAction(String name, ServerAction action) {
        this.actionMap.put(name, action);
    }

    protected void removeAction(String name) {
        this.actionMap.remove(name);
    }

    protected ServerAction getAction(String name) {
        return (ServerAction)this.actionMap.get(name);
    }

    public String getUserStatus(User user) {
        return "";
    }

    public void setProperties(Properties properties) {
    }

    public void getProperties(Properties properties) {
    }

    public void sendPluginStatus(ClientProxy proxy) {
    }

    public void sendPluginStatus() {
    }

    public abstract String getPluginId();

    public void reload() throws Exception {
    }
}

