/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.nova.client;

import jp.sourceforge.chaplet.core.client.ClientAction;
import jp.sourceforge.chaplet.core.client.ClientPlugin;
import jp.sourceforge.chaplet.core.ui.IConfigDialog;
import jp.sourceforge.chaplet.core.ui.IPluginView;
import jp.sourceforge.chaplet.nova.client.AddCharacterAction;
import jp.sourceforge.chaplet.nova.client.ExchangePlotAction;
import jp.sourceforge.chaplet.nova.client.FeedAction;
import jp.sourceforge.chaplet.nova.client.GiveCardAction;
import jp.sourceforge.chaplet.nova.client.HandToPileAction;
import jp.sourceforge.chaplet.nova.client.PlotToPileAction;
import jp.sourceforge.chaplet.nova.client.ReactionAction;
import jp.sourceforge.chaplet.nova.client.RemoveCharacterAction;
import jp.sourceforge.chaplet.nova.client.SceneAction;
import jp.sourceforge.chaplet.nova.client.SetStatusAction;
import jp.sourceforge.chaplet.nova.client.ToPlotAction;
import jp.sourceforge.chaplet.nova.client.YamabikiAction;
import jp.sourceforge.chaplet.nova.ui.INovaView;
import jp.sourceforge.chaplet.nova.ui.NovaConfigDialog;
import jp.sourceforge.chaplet.nova.ui.NovaForm;
import org.eclipse.swt.widgets.Composite;

public class NovaClientPlugin
extends ClientPlugin {
    private NovaForm swtForm;

    public void init() {
        ClientAction[] actions = new ClientAction[]{new AddCharacterAction(), new FeedAction(), new HandToPileAction(), new PlotToPileAction(), new ReactionAction(), new RemoveCharacterAction(), new SceneAction(), new ToPlotAction(), new YamabikiAction(), new SetStatusAction(), new GiveCardAction(), new ExchangePlotAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this.getController(), (ClientPlugin)this);
            ++i;
        }
        this.addAction("nova:addchara", actions[0]);
        this.addAction("nova:feed", actions[1]);
        this.addAction("nova:handtopile", actions[2]);
        this.addAction("nova:plottopile", actions[3]);
        this.addAction("nova:reaction", actions[4]);
        this.addAction("nova:delchara", actions[5]);
        this.addAction("nova:scene", actions[6]);
        this.addAction("nova:toplot", actions[7]);
        this.addAction("nova:yamabiki", actions[8]);
        this.addAction("nova:status", actions[9]);
        this.addAction("nova:givecard", actions[10]);
        this.addAction("nova:exchange", actions[10]);
    }

    public void initSWT(Composite parent) {
        this.swtForm = new NovaForm(parent, 0);
        this.swtForm.setVisible(false);
        this.swtForm.setController(this);
    }

    public Composite getSWTComponent() {
        return this.swtForm;
    }

    public INovaView getNovaView() {
        return this.swtForm;
    }

    public void feedHand() {
        this.getConnection().sendMessage(new String[]{"nova:feed"});
    }

    public void handToPile(String card, boolean hidden) {
        String[] message = null;
        message = hidden ? new String[]{"nova:handtopile", card, "hidden"} : new String[]{"nova:handtopile", card};
        this.getConnection().sendMessage(message);
    }

    public void nextScene() {
        this.getConnection().sendMessage(new String[]{"nova:scene"});
    }

    public void addCharacter() {
        this.getConnection().sendMessage(new String[]{"nova:addchara"});
    }

    public void removeCharacter(int index) {
        this.getConnection().sendMessage(new String[]{"nova:delchara", String.valueOf(index)});
    }

    public void yamabiki() {
        this.getConnection().sendMessage(new String[]{"nova:yamabiki"});
    }

    public void handToProt(String card, int protno) {
        this.getConnection().sendMessage(new String[]{"nova:toplot", String.valueOf(protno), card});
    }

    public void protToPile(String card, int protno, boolean hidden) {
        String[] message = null;
        message = hidden ? new String[]{"nova:plottopile", String.valueOf(protno), card, "hidden"} : new String[]{"nova:plottopile", String.valueOf(protno), card};
        this.getConnection().sendMessage(message);
    }

    public void toReaction(String card, int protno, boolean isReaction) {
        this.getConnection().sendMessage(new String[]{"nova:reaction", String.valueOf(protno), card, isReaction ? "_" : "|"});
    }

    public void exchange(String handCard, String plotCard, int plotNo) {
        this.getConnection().sendMessage(new String[]{"nova:exchange", String.valueOf(plotNo), handCard, plotCard});
    }

    public void giveCard(String card, String user) {
        this.getConnection().sendMessage(new String[]{"nova:givecard", user, card});
    }

    public IPluginView getPluginView() {
        return this.swtForm;
    }

    public String getPluginId() {
        return "jp.sourceforge.chaplet.nova";
    }

    public IConfigDialog initConfigDialog(Composite parent) {
        NovaConfigDialog dialog = new NovaConfigDialog(parent, 0);
        return dialog;
    }
}

