/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.Rect;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    boolean disposed;
    boolean warnings;
    int colorspace;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData data) {
        if (data != null) {
            this.debug = data.debug;
            this.tracking = data.tracking;
        }
        this.create(data);
        this.init();
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memcpy((int[])ptr, (int)gdevice, (int)4);
        GDevice device = new GDevice();
        OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
        return new Rectangle(device.left, device.top, device.right - device.left, device.bottom - device.top);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds((int)gdevice, (Rect)rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDepth() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memcpy((int[])ptr, (int)gdevice, (int)4);
        GDevice device = new GDevice();
        OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
        return OS.GetPixDepth((int)device.gdPMap);
    }

    public Point getDPI() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memcpy((int[])ptr, (int)gdevice, (int)4);
        GDevice device = new GDevice();
        OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
        OS.memcpy((int[])ptr, (int)device.gdPMap, (int)4);
        PixMap pixmap = new PixMap();
        OS.memcpy((PixMap)pixmap, (int)ptr[0], (int)50);
        return new Point(OS.Fix2Long((int)pixmap.hRes), OS.Fix2Long((int)pixmap.vRes));
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        short[] style = new short[1];
        short[] family = new short[1];
        int[] fontCount = new int[1];
        int[] actualLength = new int[1];
        OS.ATSUGetFontIDs(null, (int)0, (int[])fontCount);
        int[] fontIDs = new int[fontCount[0]];
        OS.ATSUGetFontIDs((int[])fontIDs, (int)fontIDs.length, (int[])fontCount);
        FontData[] fds = new FontData[fontCount[0]];
        int i = 0;
        while (i < fds.length) {
            int fontID = fontIDs[i];
            OS.ATSUFindFontName((int)fontID, (int)1, (int)-1, (int)-1, (int)-1, (int)0, null, (int[])actualLength, null);
            byte[] buffer = new byte[actualLength[0]];
            OS.ATSUFindFontName((int)fontID, (int)1, (int)-1, (int)-1, (int)-1, (int)buffer.length, (byte[])buffer, (int[])actualLength, null);
            String name = new String(buffer);
            if (faceName == null || Compatibility.equalsIgnoreCase(faceName, name)) {
                FontData data;
                OS.FMGetFontFamilyInstanceFromFont((int)fontID, (short[])family, (short[])style);
                int s = 0;
                if ((style[0] & 2) != 0) {
                    s |= 2;
                }
                if ((style[0] & 1) != 0) {
                    s |= 1;
                }
                fds[i] = data = new FontData(name, 0, s);
            }
            ++i;
        }
        return fds;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (this.colorspace == 0) {
            SWT.error(2);
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        boolean smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        byte[] family = new byte[256];
        short[] size = new short[1];
        byte[] style = new byte[1];
        boolean themeFont = smallFonts;
        OS.GetThemeFont((short)((short)(themeFont ? 1 : 0)), (short)-1, (byte[])family, (short[])size, (byte[])style);
        short id = OS.FMGetFontFamilyFromName((byte[])family);
        int[] font = new int[1];
        OS.FMGetFontFromFontFamilyInstance((short)id, (short)style[0], (int[])font, null);
        this.systemFont = Font.carbon_new(this, font[0], id, style[0], size[0]);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    protected void release() {
        OS.CGColorSpaceRelease((int)this.colorspace);
        this.colorspace = 0;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
        this.warnings = warnings;
    }
}

