/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.nova.server;

import java.io.IOException;
import java.util.Properties;
import jp.sourceforge.chaplet.core.server.ClientProxy;
import jp.sourceforge.chaplet.core.server.ServerAction;
import jp.sourceforge.chaplet.core.server.ServerPlugin;
import jp.sourceforge.chaplet.core.server.User;
import jp.sourceforge.chaplet.nova.server.AddCharacterAction;
import jp.sourceforge.chaplet.nova.server.CardManager;
import jp.sourceforge.chaplet.nova.server.ExchangePlotAction;
import jp.sourceforge.chaplet.nova.server.FeedAction;
import jp.sourceforge.chaplet.nova.server.GiveCardAction;
import jp.sourceforge.chaplet.nova.server.Hand;
import jp.sourceforge.chaplet.nova.server.HandManager;
import jp.sourceforge.chaplet.nova.server.HandToPileAction;
import jp.sourceforge.chaplet.nova.server.LoginServerAction;
import jp.sourceforge.chaplet.nova.server.LogoutServerAction;
import jp.sourceforge.chaplet.nova.server.PlotToPileAction;
import jp.sourceforge.chaplet.nova.server.ReactionAction;
import jp.sourceforge.chaplet.nova.server.RemoveCharacterAction;
import jp.sourceforge.chaplet.nova.server.SceneAction;
import jp.sourceforge.chaplet.nova.server.TarotManager;
import jp.sourceforge.chaplet.nova.server.ToPlotAction;
import jp.sourceforge.chaplet.nova.server.YamabikiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NovaServerPlugin
extends ServerPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private HandManager handManager = new HandManager();
    private CardManager cardManager = new CardManager();
    private TarotManager tarotManager = new TarotManager();

    public String getUserStatus(User user) {
        Hand hand = this.handManager.getHandOf(user.getName());
        if (hand != null) {
            return hand.handString();
        }
        return "";
    }

    public void reload() throws Exception {
        this.tarotManager.init();
        this.cardManager.init();
    }

    public void init() throws Exception {
        this.tarotManager.init();
        this.cardManager.init();
        ServerAction[] actions = new ServerAction[]{new LoginServerAction(), new LogoutServerAction(), new FeedAction(), new HandToPileAction(), new AddCharacterAction(), new PlotToPileAction(), new ReactionAction(), new RemoveCharacterAction(), new SceneAction(), new ToPlotAction(), new YamabikiAction(), new GiveCardAction(), new ExchangePlotAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this.server, (ServerPlugin)this);
            ++i;
        }
        this.addAction("login", actions[0]);
        this.addAction("logout", actions[1]);
        this.addAction("nova:feed", actions[2]);
        this.addAction("nova:handtopile", actions[3]);
        this.addAction("nova:addchara", actions[4]);
        this.addAction("nova:plottopile", actions[5]);
        this.addAction("nova:reaction", actions[6]);
        this.addAction("nova:delchara", actions[7]);
        this.addAction("nova:scene", actions[8]);
        this.addAction("nova:toplot", actions[9]);
        this.addAction("nova:yamabiki", actions[10]);
        this.addAction("nova:givecard", actions[11]);
        this.addAction("nova:exchange", actions[12]);
    }

    public CardManager getCardManager() {
        return this.cardManager;
    }

    public HandManager getHandManager() {
        return this.handManager;
    }

    public TarotManager getTarotManager() {
        return this.tarotManager;
    }

    public void setProperties(Properties properties) {
        this.cardManager.setProperties(properties);
        this.handManager.setProperties(properties);
        this.tarotManager.setProperties(properties);
    }

    public void getProperties(Properties properties) {
        this.cardManager.getProperties(properties);
        this.handManager.getProperties(properties);
        this.tarotManager.getProperties(properties);
    }

    public void sendPluginStatus() {
        try {
            this.getAction("nova:scene").execute(new String[]{"nova:scene", "no"}, null);
        }
        catch (IOException e) {
            this.log.error((Object)"scene", (Throwable)e);
        }
    }

    public void sendPluginStatus(ClientProxy proxy) {
        Hand hand = this.getHandManager().getHandOf(proxy.getName());
        String[] cards = hand.getHand(0);
        String[] resp = new String[cards.length + 1];
        resp[0] = "ok/nova:feed";
        int i = 0;
        while (i < cards.length) {
            resp[i + 1] = cards[i];
            ++i;
        }
        proxy.sendMessage(resp);
    }

    public String getPluginId() {
        return "jp.sourceforge.chaplet.nova";
    }
}

