/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.nova.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import jp.sourceforge.chaplet.ConfigLoader;

public class TarotManager {
    private static final String DEFAULT_FILE = "tarot.txt";
    private String fileName = "tarot.txt";
    private ArrayList tarotList = new ArrayList();
    private Set unuseSet = new HashSet();

    public TarotManager() {
        String tarotFile = ConfigLoader.getInstance().load().getProperty("jp.sourceforge.chaplet.nova.tarotFile");
        if (tarotFile != null && tarotFile.length() > 0) {
            this.fileName = tarotFile;
        }
    }

    public void setProperties(Properties properties) {
        int i = 0;
        Iterator iter = this.tarotList.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            properties.setProperty("nova.tarot." + i, element);
            ++i;
        }
    }

    public void getProperties(Properties properties) {
        String element;
        this.tarotList.clear();
        int i = 0;
        while ((element = properties.getProperty("nova.tarot." + i)) != null) {
            this.tarotList.add(element);
            ++i;
        }
    }

    public void reset() {
        this.tarotList.set(0, "-");
        int i = 1;
        int n = this.tarotList.size();
        while (i < n) {
            String line = (String)this.tarotList.get(i);
            String[] tarot = line.split(",");
            String number = tarot[0];
            if (this.unuseSet.contains(number)) {
                this.tarotList.set(i, String.valueOf(tarot[0]) + "," + tarot[1] + ",1");
            } else {
                this.tarotList.set(i, String.valueOf(tarot[0]) + "," + tarot[1] + ",0");
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws IOException {
        Object var7_9;
        File file;
        block13: {
            Properties properties = ConfigLoader.getInstance().load().getProperties();
            String[] minusNumbers = new String[]{"-1", "-7", "-9", "-18"};
            this.unuseSet.clear();
            int i = 0;
            while (true) {
                if (i >= minusNumbers.length) {
                    file = new File(this.fileName);
                    if (!file.exists()) {
                        break;
                    }
                    break block13;
                }
                String usage = properties.getProperty("jp.sourceforge.chaplet.nova.tarot.unuse." + minusNumbers[i]);
                if (usage != null && usage.equals("y")) {
                    this.unuseSet.add(minusNumbers[i]);
                }
                ++i;
            }
            this.fileName = DEFAULT_FILE;
            file.createNewFile();
            InputStream in = this.getClass().getResourceAsStream("/tarot.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    writer.close();
                    reader.close();
                    break;
                }
                writer.write(line);
                writer.newLine();
            }
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.tarotList.clear();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                String number = line.split(",")[0];
                if (this.unuseSet.contains(number)) {
                    this.tarotList.add(String.valueOf(line) + ",1");
                    continue;
                }
                this.tarotList.add(String.valueOf(line) + ",0");
            }
        }
        catch (Throwable throwable) {
            var7_9 = null;
            reader.close();
            throw throwable;
        }
        {
            var7_9 = null;
        }
        reader.close();
        this.tarotList.add(0, "-");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
        try {
            int i = 0;
            int n = this.tarotList.size();
            while (i < n) {
                String line = (String)this.tarotList.get(i);
                writer.write(line);
                writer.newLine();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        writer.close();
    }

    public String next() throws IOException {
        HashMap map = this.getRestTarots();
        if (map.size() == 0) {
            this.reset();
            map = this.getRestTarots();
        }
        int nextIndex = (int)(Math.random() * (double)map.size());
        Iterator iterator = map.keySet().iterator();
        int i = 0;
        while (i < nextIndex - 1) {
            iterator.next();
            ++i;
        }
        Integer key = (Integer)iterator.next();
        String tarot = (String)map.get(key);
        this.tarotList.set(key, String.valueOf(tarot.substring(0, tarot.length() - 1)) + "1");
        this.tarotList.set(0, tarot.split(",")[0]);
        return tarot;
    }

    HashMap getRestTarots() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        int n = this.tarotList.size();
        while (i < n) {
            String tarot = (String)this.tarotList.get(i);
            if (tarot.indexOf(44) >= 0 && tarot.endsWith("0")) {
                map.put(new Integer(i), tarot);
            }
            ++i;
        }
        return map;
    }

    public void setFileName(String tarotFile) {
        this.fileName = tarotFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    int count() {
        return this.tarotList.size() - 1;
    }

    public String getSceneCard() {
        String cardNo = (String)this.tarotList.get(0);
        if (cardNo.equals("-")) {
            return "";
        }
        int i = 1;
        int n = this.tarotList.size();
        while (i < this.tarotList.size()) {
            String card = (String)this.tarotList.get(i);
            String[] s = card.split(",");
            if (s[0].equals(cardNo)) {
                return card;
            }
            ++i;
        }
        return "";
    }
}

