/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.dice.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import jp.sourceforge.chaplet.ConfigLoader;
import jp.sourceforge.chaplet.Configuration;
import jp.sourceforge.chaplet.core.client.ClientAction;
import jp.sourceforge.chaplet.core.client.ClientPlugin;
import jp.sourceforge.chaplet.core.ui.IPluginView;
import jp.sourceforge.chaplet.dice.client.RoleCountAction;
import jp.sourceforge.chaplet.dice.client.RoleSumAction;
import jp.sourceforge.chaplet.dice.ui.DiceForm;
import org.eclipse.swt.widgets.Composite;

public class DiceClientPlugin
extends ClientPlugin {
    private DiceForm form;

    public void init() {
        ClientAction action = new RoleSumAction();
        action.init(this.getController(), (ClientPlugin)this);
        this.addAction("dice:rolesum", action);
        action = new RoleCountAction();
        action.init(this.getController(), (ClientPlugin)this);
        this.addAction("dice:rolecount", action);
    }

    public void initSWT(Composite parent) {
        this.form = new DiceForm(parent, 0);
        this.form.setVisible(false);
        this.form.setController(this);
        ArrayList<String> ruleList = new ArrayList<String>();
        String ruleKey = String.valueOf(this.getPluginId()) + ".rule";
        Properties properties = ConfigLoader.getInstance().load().getProperties();
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(ruleKey)) continue;
            String rule = properties.getProperty(key);
            ruleList.add(rule);
        }
        this.form.setDiceRule(ruleList.toArray(new String[ruleList.size()]));
    }

    public void destroy() {
        String[] rules = this.form.getDiceRule();
        String ruleKey = String.valueOf(this.getPluginId()) + ".rule";
        Configuration conf = ConfigLoader.getInstance().load();
        Properties properties = conf.getProperties();
        int i = 0;
        while (i < rules.length) {
            properties.setProperty(String.valueOf(ruleKey) + "." + i, rules[i]);
            ++i;
        }
    }

    public Composite getSWTComponent() {
        return this.form;
    }

    public IPluginView getPluginView() {
        return this.form;
    }

    public String getPluginId() {
        return "jp.sourceforge.chaplet.dice";
    }

    public void roleSum(String rule, int bonus, int prevValue, int numRerole, boolean hidden) {
        this.getConnection().sendMessage(new String[]{"dice:rolesum", rule, String.valueOf(bonus), String.valueOf(prevValue), String.valueOf(numRerole), hidden ? "hidden" : "show"});
    }

    public void roleCount(String rule, int target, boolean upperRole, int prevValue, int numRerole, boolean hidden) {
        String[] message = new String[]{"dice:rolecount", rule, String.valueOf(target), upperRole ? "+" : "-", String.valueOf(prevValue), String.valueOf(numRerole), hidden ? "hidden" : "show"};
        this.getConnection().sendMessage(message);
    }
}

