/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Application;
import application.ApplicationContext;
import application.ResourceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private final Map<String, ResourceMap> resourceMaps = new HashMap<String, ResourceMap>();
    private List<String> applicationBundleNames = null;

    private String bundlePackageName(String bundleName) {
        int i = bundleName.lastIndexOf(".");
        return i == -1 ? "" : bundleName.substring(0, i);
    }

    private ResourceMap createAppResourceMap(ClassLoader cl, ListIterator<String> names) {
        if (!names.hasNext()) {
            return null;
        }
        String bundleName0 = names.next();
        String rmBundlePackage = this.bundlePackageName(bundleName0);
        ArrayList<String> rmNames = new ArrayList<String>();
        rmNames.add(bundleName0);
        ResourceMap parent = this.createAppResourceMap(cl, names);
        return this.createResourceMap(cl, parent, rmNames);
    }

    private ResourceMap getApplicationResourceMap() {
        List<String> appBundleNames = this.getApplicationBundleNames();
        String appResourceMapKey = appBundleNames.get(0);
        ResourceMap appResourceMap = this.resourceMaps.get(appResourceMapKey);
        if (appResourceMap == null) {
            Class<Application> appClass = ApplicationContext.getInstance().getApplicationClass();
            if (appClass == null) {
                logger.warning("getApplicationResourceMap(): no Application class");
                appClass = Application.class;
            }
            ClassLoader classLoader = appClass.getClassLoader();
            appResourceMap = this.createAppResourceMap(classLoader, appBundleNames.listIterator());
            this.resourceMaps.put(appResourceMapKey, appResourceMap);
        }
        return appResourceMap;
    }

    private ResourceMap getPackageResourceMap(Class cls) {
        List<String> pkgBundleNames = this.getPackageBundleNames(cls);
        String pkgResourceMapKey = pkgBundleNames.get(0);
        ResourceMap pkgResourceMap = this.resourceMaps.get(pkgResourceMapKey);
        if (pkgResourceMap == null) {
            ResourceMap appResourceMap = this.getApplicationResourceMap();
            pkgResourceMap = this.createResourceMap(cls.getClassLoader(), appResourceMap, pkgBundleNames);
            this.resourceMaps.put(pkgResourceMapKey, pkgResourceMap);
        }
        return pkgResourceMap;
    }

    private ResourceMap getClassResourceMap(Class cls) {
        List<String> classBundleNames = this.getClassBundleNames(cls);
        String classResourceMapKey = classBundleNames.get(0);
        ResourceMap classResourceMap = this.resourceMaps.get(classResourceMapKey);
        if (classResourceMap == null) {
            ResourceMap packageResourceMap = this.getPackageResourceMap(cls);
            classResourceMap = this.createResourceMap(cls.getClassLoader(), packageResourceMap, classBundleNames);
            this.resourceMaps.put(classResourceMapKey, classResourceMap);
        }
        return classResourceMap;
    }

    protected ResourceMap createResourceMap(ClassLoader classLoader, ResourceMap parent, List<String> bundleNames) {
        if (classLoader == null) {
            throw new IllegalArgumentException("null ClassLoader");
        }
        if (bundleNames == null) {
            throw new IllegalArgumentException("null bundleNames List");
        }
        String[] bns = new String[bundleNames.size()];
        return new ResourceMap(parent, classLoader, bundleNames.toArray(bns));
    }

    public ResourceMap getResourceMap(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.getClassResourceMap(cls);
    }

    public ResourceMap getResourceMap() {
        return this.getApplicationResourceMap();
    }

    private List<Class> getAppClasses(Class appClass) {
        ArrayList<Class> appClasses = new ArrayList<Class>();
        Class stopClass = Application.class.getSuperclass();
        Class c = appClass;
        while (!c.equals(stopClass)) {
            appClasses.add(c);
            c = c.getSuperclass();
        }
        return appClasses;
    }

    public List<String> getApplicationBundleNames() {
        if (this.applicationBundleNames == null) {
            Class appClass = ApplicationContext.getInstance().getApplicationClass();
            if (appClass == null) {
                return this.getClassBundleNames(Application.class);
            }
            List<Class> appClasses = this.getAppClasses(appClass);
            ArrayList<String> bundleNames = new ArrayList<String>(appClasses.size() * 2);
            for (Class cls : appClasses) {
                bundleNames.addAll(this.getClassBundleNames(cls));
            }
            this.applicationBundleNames = Collections.unmodifiableList(bundleNames);
        }
        return this.applicationBundleNames;
    }

    public void setApplicationBundleNames(List<String> bundleNames) {
        if (bundleNames != null) {
            for (String bundleName : bundleNames) {
                if (bundleName != null && bundleNames.size() != 0) continue;
                throw new IllegalArgumentException("invalid bundle name \"" + bundleName + "\"");
            }
        }
        List<String> oldValue = this.applicationBundleNames;
        this.applicationBundleNames = bundleNames != null ? Collections.unmodifiableList(new ArrayList<String>(bundleNames)) : null;
        this.resourceMaps.clear();
        this.firePropertyChange("applicationBundleNames", oldValue, this.applicationBundleNames);
    }

    private String classBundleBaseName(Class cls) {
        String className = cls.getName();
        StringBuffer sb = new StringBuffer();
        int i = className.lastIndexOf(46);
        if (i > 0) {
            sb.append(className.substring(0, i));
            sb.append(".resources.");
            sb.append(cls.getSimpleName());
        } else {
            sb.append("resources.");
            sb.append(cls.getSimpleName());
        }
        return sb.toString();
    }

    protected List<String> getClassBundleNames(Class cls) {
        String bundleName = this.classBundleBaseName(cls);
        return Collections.singletonList(bundleName);
    }

    private String classPackageName(Class cls) {
        Package pkg = cls.getPackage();
        if (pkg != null) {
            return pkg.getName();
        }
        String className = cls.getName();
        int i = className.lastIndexOf(46);
        return i > 0 ? className.substring(0, i) : "";
    }

    private String packageBundleBaseName(Class cls) {
        return this.classPackageName(cls) + ".resources.PackageResources";
    }

    protected List<String> getPackageBundleNames(Class cls) {
        String bundleName = this.packageBundleBaseName(cls);
        return Collections.singletonList(bundleName);
    }
}

