/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.client;

import application.Action;
import application.Application;
import application.ApplicationActionMap;
import application.ApplicationContext;
import application.ResourceMap;
import application.Task;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import jp.sf.chaplet.ActionResult;
import jp.sf.chaplet.ConfigLoader;
import jp.sf.chaplet.Configuration;
import jp.sf.chaplet.DiceManager;
import jp.sf.chaplet.Plugin;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.UserStatus;
import jp.sf.chaplet.core.client.ActivatePluginAction;
import jp.sf.chaplet.core.client.ChatClientAction;
import jp.sf.chaplet.core.client.ChatConnection;
import jp.sf.chaplet.core.client.ClientAction;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.client.DisconnectAction;
import jp.sf.chaplet.core.client.Handle;
import jp.sf.chaplet.core.client.IChatListener;
import jp.sf.chaplet.core.client.LoginAction;
import jp.sf.chaplet.core.client.LogoutAction;
import jp.sf.chaplet.core.client.RollAction;
import jp.sf.chaplet.core.client.ServerAddress;
import jp.sf.chaplet.core.client.SetGMAction;
import jp.sf.chaplet.core.client.StatusAction;
import jp.sf.chaplet.core.server.ChatServer;
import jp.sf.chaplet.core.server.IServerListener;
import jp.sf.chaplet.core.ui.ConnectDialog;
import jp.sf.chaplet.core.ui.IMainView;
import jp.sf.chaplet.core.ui.IPluginView;
import jp.sf.chaplet.core.ui.MainWindow;
import jp.sf.chaplet.swing.HteWriter;

public class ChatClient
extends ClientPlugin {
    private MainWindow view;
    private ChatConnection connection;
    private ChatServer server;
    private boolean isServer;
    private TreeMap<String, ClientPlugin> pluginMap = new TreeMap();
    private UserStatus[] status;
    private String currentDirectory = System.getProperty("user.home");

    protected void startup() {
        ApplicationContext context = ApplicationContext.getInstance();
        ApplicationActionMap actionMap = context.getActionMap();
        ClientAction[] actions = new ClientAction[]{new ChatClientAction(), new LoginAction(), new LogoutAction(), new StatusAction(), new ActivatePluginAction(), new DisconnectAction(), new SetGMAction(), new RollAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this, this);
            ++i;
        }
        this.addAction("chat", actions[0]);
        this.addAction("login", actions[1]);
        this.addAction("logout", actions[2]);
        this.addAction("status", actions[3]);
        this.addAction("activateplugin", actions[4]);
        this.addAction("disconnect", actions[5]);
        this.addAction("setgm", actions[6]);
        this.addAction("roll", actions[7]);
        this.view = new MainWindow();
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChatClient.this.exit();
            }
        });
        this.addExitListener(new Application.ExitListener(){

            public boolean canExit(EventObject event) {
                if (ChatClient.this.connection.isConnected()) {
                    int ret = JOptionPane.showConfirmDialog(ChatClient.this.view, "\u7d42\u4e86\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0);
                    return ret == 0;
                }
                return true;
            }

            public void willExit(EventObject event) {
            }
        });
        this.view.injectActions((ActionMap)actionMap);
        ResourceMap resourceMap = context.getResourceMap(MainWindow.class);
        resourceMap.injectComponents((Component)this.view);
        try {
            this.init();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "init", e);
        }
        this.view.setVisible(true);
        this.view.setLoginOK(false);
        Handle handle = (Handle)StorageUtils.load("handle.xml");
        if (handle != null) {
            this.view.getHandleText().setText(handle.getName());
            this.view.getAliasComboModel().addAll(handle.getAliasList());
        }
        for (Plugin plugin : ConfigLoader.getInstance().load().getPlugins()) {
            this.view.addPluginView(plugin.getClientPlugin());
        }
        this.view.setLoginOK(false);
    }

    protected void shutdown() {
        if (this.connection != null && this.connection.isConnected()) {
            this.disconnect();
        }
        Handle handle = new Handle();
        handle.setName(this.view.getHandleText().getText());
        handle.getAliasList().addAll(this.view.getAliasComboModel().getAll());
        StorageUtils.save(handle, "handle.xml");
        for (Plugin plugin : ConfigLoader.getInstance().load().getPlugins()) {
            ClientPlugin clientPlugin = plugin.getClientPlugin();
            clientPlugin.destroy();
        }
    }

    private void init() throws IOException {
        ApplicationContext context = ApplicationContext.getInstance();
        for (Plugin plugin : ConfigLoader.getInstance().load().getPlugins()) {
            try {
                ClientPlugin clientPlugin = plugin.getClientPlugin();
                clientPlugin.init(this);
                JPanel panel = clientPlugin.getPluginView().getSwingComponent();
                ResourceMap resourceMap = context.getResourceMap(panel.getClass());
                resourceMap.injectComponents((Component)panel);
                this.addPlugin(clientPlugin);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, plugin.getPluginId(), e);
            }
        }
        this.connection = new ChatConnection();
        this.connection.addChatListener(new IChatListener(){

            public void messageRecieved(String[] message) {
                ClientAction command = ChatClient.this.getAction(message[0]);
                ClientAction pluginCommand = ChatClient.this.getPluginAction(message[0]);
                ActionResult result = ActionResult.NULL;
                if (pluginCommand != null) {
                    result = pluginCommand.getExecutionTime().messageRecieved(command, pluginCommand, message);
                } else if (command != null) {
                    result = command.messageRecieved(message);
                }
                if (result == ActionResult.DISCONNECT) {
                    ChatClient.this.disconnect();
                }
            }

            public void responseRecieved(String[] response) {
                ClientAction command = ChatClient.this.getAction(response[0].substring(3));
                ClientAction pluginCommand = ChatClient.this.getPluginAction(response[0].substring(3));
                ActionResult result = ActionResult.NULL;
                if (pluginCommand != null) {
                    result = pluginCommand.getExecutionTime().responseRecieved(command, pluginCommand, response);
                } else if (command != null) {
                    result = command.responseRecieved(response);
                }
                if (result == ActionResult.DISCONNECT) {
                    ChatClient.this.disconnect();
                }
            }

            public void connectionEstablished(String serverName) {
                ChatClient.this.view.setStatus("\u63a5\u7d9a\u4e2d");
                ChatClient.this.view.setMessage(String.valueOf(serverName) + " \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002");
                ChatClient.this.view.setGM(ChatClient.this.server != null);
            }

            public void connectionClosed() {
                ChatClient.this.view.setStatus("");
                ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u3068\u306e\u63a5\u7d9a\u3092\u9589\u3058\u307e\u3057\u305f\u3002");
                ChatClient.this.view.setLoginOK(false);
            }

            public void connectionClosedByError() {
                ChatClient.this.view.setStatus("");
                ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u3068\u306e\u901a\u4fe1\u304c\u5207\u308c\u307e\u3057\u305f\u3002");
                ChatClient.this.view.setLoginOK(false);
            }

            public void errorOccured() {
                ChatClient.this.view.setStatus("\u30a8\u30e9\u30fc\uff01");
                ChatClient.this.view.setMessage("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u8a73\u7d30\u306f\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        });
    }

    @Action
    public void onExit() {
        this.exit();
    }

    public String getPluginId() {
        return "jp.sf.chaplet.core";
    }

    public IPluginView getPluginView() {
        return this.view;
    }

    public IMainView getView() {
        return this.view;
    }

    public JPanel getSwingComponent() {
        return (JPanel)this.view.getContentPane();
    }

    public void loadServerSetting(final String fileName) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ChatClient.this.server.load(fileName);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ChatClient.this.view, "\u30ed\u30fc\u30c9\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002", "Chaplet Platform", 0);
                    }
                });
            }
        });
        thread.start();
    }

    public void saveServerSetting(final String fileName) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ChatClient.this.server.save(fileName);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                JOptionPane.showMessageDialog(ChatClient.access$1(5.access$0(1.access$0(this.this$2))), "\u30bb\u30fc\u30d6\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002", "Chaplet Platform", 0);
                            }
                        });
                    }

                    static /* synthetic */ 5 access$0(1 var0) {
                        return var0.this;
                    }
                });
            }

            static /* synthetic */ ChatClient access$0(5 var0) {
                return var0.ChatClient.this;
            }
        });
        thread.start();
    }

    public ClientPlugin getPlugin(String pluginId) {
        return this.pluginMap.get(pluginId);
    }

    public void addPlugin(ClientPlugin clientPlugin) {
        this.pluginMap.put(clientPlugin.getPluginId(), clientPlugin);
    }

    private ClientAction getPluginAction(String actionName) {
        for (String key : this.pluginMap.keySet()) {
            ClientPlugin plugin = this.pluginMap.get(key);
            ClientAction action = plugin.getAction(actionName);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public void activatePlugin(String pluginId) {
        this.connection.sendMessage(new String[]{"activateplugin", pluginId});
    }

    @Action
    public void setPrimaryPlugin() {
        String pluginId = this.view.getSelectedPluginId();
        ConfigLoader.getInstance().load().setPrimaryPluginId(pluginId);
        if (this.server != null) {
            this.server.setPrimaryPlugin(pluginId);
            this.connection.sendMessage(new String[]{"status"});
        }
    }

    public Iterator pluginIterator() {
        return this.pluginMap.values().iterator();
    }

    @Action
    public Task reload() {
        return new Task(){

            protected Object doInBackground() throws Exception {
                this.setMessage("\u30ea\u30ed\u30fc\u30c9\u4e2d...");
                try {
                    ChatClient.this.server.reload();
                }
                catch (Exception e) {
                    this.setMessage("\u30b5\u30fc\u30d0\u306e\u8a2d\u5b9a\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    ChatClient.this.getLogger().log(Level.SEVERE, "\u30b5\u30fc\u30d0\u306e\u8a2d\u5b9a\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                return null;
            }

            protected void finished() {
                this.setMessage("\u5b8c\u4e86\u3002");
            }
        };
    }

    public void showStatus(UserStatus[] status) {
        this.status = status;
        this.view.showStatus(status);
    }

    public UserStatus[] getStatus() {
        return this.status;
    }

    public void destroy() {
        for (ClientPlugin plugin : this.pluginMap.values()) {
            plugin.destroy();
        }
    }

    public void setGM(boolean gm) {
        ConfigLoader.getInstance().load().setGM(gm);
        super.setGM(gm);
        for (ClientPlugin plugin : this.pluginMap.values()) {
            plugin.setGM(gm);
        }
    }

    public void callSetGM(String name) {
        this.getConnection().sendMessage(new String[]{"setgm", name});
    }

    @Action
    public void showConnectDialog() {
        ApplicationContext context = ApplicationContext.getInstance();
        ApplicationActionMap actionMap = context.getActionMap();
        ConnectDialog dialog = new ConnectDialog(this.view);
        dialog.injectActions((ActionMap)actionMap);
        dialog.setLocationRelativeTo(this.view);
        dialog.setVisible(true);
    }

    @Action
    public synchronized void login() {
        ArrayList serverList = null;
        serverList = (ArrayList)StorageUtils.load("server.xml");
        if (serverList.size() == 0) {
            this.view.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u30b5\u30fc\u30d0\u306e\u30a2\u30c9\u30ec\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        String name = this.view.getHandleText().getText();
        if (name == null || name.length() == 0) {
            this.view.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u3042\u306a\u305f\u306e\u540d\u524d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        ServerAddress address = (ServerAddress)serverList.get(0);
        try {
            this.connection.connect(address.getHost(), address.getPort(), address.getSessionId(), name);
            return;
        }
        catch (Exception e) {
            this.view.setMessage("\u30b5\u30fc\u30d0 [" + address + "] \u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.getLogger().log(Level.SEVERE, "login", e);
            return;
        }
    }

    private void disconnect() {
        this.connection.close();
        this.view.appendSystemLog(String.valueOf(this.view.getHandleText().getText()) + " \u3055\u3093\u304c\u30ed\u30b0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002");
        this.view.setLoginOK(false);
    }

    @Action
    public synchronized boolean logout() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (ChatClient.this.isServer) {
                        ChatClient.this.isServer = false;
                        ChatClient.this.server.stop();
                    } else {
                        ChatClient.this.connection.sendMessage(new String[]{"logout", ChatClient.this.view.getHandleText().getText()});
                    }
                }
                catch (Exception e) {
                    ChatClient.this.getLogger().log(Level.SEVERE, "logout", e);
                }
            }
        });
        thread.start();
        return false;
    }

    @Action
    public synchronized void chat() {
        try {
            String name = this.view.getHandleText().getText();
            String alias = null;
            Object selectedItem = this.view.getAliasCombo().getSelectedItem();
            if (selectedItem != null) {
                alias = selectedItem.toString();
            }
            if (alias != null && alias.length() > 0) {
                name = this.view.getSlashButton().isSelected() ? String.valueOf(name) + "/" + alias : alias;
            }
            String message = this.view.getChatText().getText();
            this.connection.sendMessage(new String[]{"chat", name, message});
            this.view.getChatText().setText("");
            this.writing();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "chat", e);
            return;
        }
    }

    public boolean isGM() {
        Configuration conf = ConfigLoader.getInstance().load();
        return conf.isGM();
    }

    @Action
    public boolean writing() {
        boolean w = this.view.getChatText().getText().length() > 0;
        String alias = null;
        Object selectedItem = this.view.getAliasCombo().getSelectedItem();
        if (selectedItem != null) {
            alias = selectedItem.toString();
        }
        if (alias == null || alias.length() == 0) {
            this.connection.sendMessage(new String[]{"writing", w ? "y" : "n"});
        } else {
            this.connection.sendMessage(new String[]{"writing", w ? "y" : "n", alias});
        }
        return true;
    }

    @Action
    public void startServer() {
        ArrayList<ServerAddress> serverList = null;
        ServerAddress address = null;
        serverList = (ArrayList<ServerAddress>)StorageUtils.load("server.xml");
        if (serverList == null) {
            return;
        }
        if (serverList == null || serverList.size() == 0) {
            serverList = new ArrayList<ServerAddress>();
            address = new ServerAddress();
            address.setHost("127.0.0.1");
            address.setPort(10001);
            address.setSessionId(UUID.randomUUID().toString());
            serverList.add(0, address);
        } else {
            address = (ServerAddress)serverList.get(0);
            if (!address.getHost().equals("127.0.0.1")) {
                address = new ServerAddress();
                address.setHost("127.0.0.1");
                address.setPort(10001);
                address.setSessionId(UUID.randomUUID().toString());
                serverList.add(0, address);
            }
        }
        StorageUtils.save(serverList, "server.xml");
        String name = this.view.getHandleText().getText();
        if (name == null || name.length() == 0) {
            this.view.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u3042\u306a\u305f\u306e\u540d\u524d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        final String sessionId = address.getSessionId();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    ChatClient.this.server = new ChatServer(sessionId);
                    ChatClient.this.server.addServerListener(new IServerListener(){

                        public void serverStarted() {
                            ChatClient.this.view.appendSystemLog("\u30b5\u30fc\u30d0\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
                            ChatClient.this.login();
                        }

                        public void connectionClosedByError() {
                            ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u304c\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u30b5\u30fc\u30d0\u306e\u518d\u8d77\u52d5\u304c\u3067\u304d\u307e\u3059\u3002");
                        }

                        public void errorOccured() {
                            ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                        }

                        public void serverStopped() {
                            ChatClient.this.view.appendSystemLog("\u30b5\u30fc\u30d0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                            ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                            ChatClient.this.view.setStatus("");
                            ChatClient.this.view.setLoginOK(false);
                        }

                        public void failedToStartServer() {
                            ChatClient.this.view.setMessage("\u30b5\u30fc\u30d0\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        }
                    });
                    ChatClient.this.server.init();
                    ChatClient.this.server.loop();
                    ChatClient.this.isServer = true;
                }
                catch (Exception e) {
                    ChatClient.this.getLogger().log(Level.SEVERE, "startServer", e);
                }
            }
        });
        thread.start();
    }

    @Action
    public void modifyHandle() {
        String handle = this.view.getHandleText().getText();
        Configuration conf = ConfigLoader.getInstance().load();
        conf.setName(handle);
    }

    protected ChatConnection getConnection() {
        return this.connection;
    }

    @Action
    public void rollSum() {
        String rule = this.view.getDiceCombo().getSelectedItem().toString();
        int bonus = (Integer)this.view.getDiceBonusSpinner().getValue();
        Handle handle = (Handle)StorageUtils.load("handle.xml");
        int[] result = null;
        try {
            result = DiceManager.getInstance().rollSum(rule, bonus, -1);
        }
        catch (ParseException e) {
            this.view.appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), String.valueOf(rule) + "=\u8a55\u4fa1\u3067\u304d\u307e\u305b\u3093");
            return;
        }
        StringBuilder sb = new StringBuilder(rule);
        if (bonus != 0) {
            if (bonus > 0) {
                sb.append('+');
            }
            sb.append(bonus);
        }
        sb.append('=');
        sb.append('(');
        int i = 1;
        while (i < result.length) {
            sb.append(result[i]);
            sb.append('+');
            ++i;
        }
        if (result.length > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        if (bonus != 0) {
            if (bonus > 0) {
                sb.append('+');
            }
            sb.append(bonus);
        }
        sb.append('=');
        sb.append(result[0]);
        String exp = sb.toString();
        this.view.appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), exp);
        if (this.view.getHideRollButton().isSelected()) {
            this.getConnection().sendMessage(new String[]{"roll", "-", handle.getName()});
        } else {
            this.getConnection().sendMessage(new String[]{"roll", exp, handle.getName()});
        }
    }

    @Action
    public void saveLog() {
        block14: {
            JFileChooser chooser = new JFileChooser(this.currentDirectory);
            chooser.setAcceptAllFileFilterUsed(false);
            FileFilter htmlFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    if (f.getName().length() < 5) {
                        return false;
                    }
                    return f.getName().substring(f.getName().length() - 5).equalsIgnoreCase(".html");
                }

                public String getDescription() {
                    return "HTML\u30d5\u30a1\u30a4\u30eb(*.html)";
                }
            };
            chooser.addChoosableFileFilter(htmlFilter);
            FileFilter txtFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    if (f.getName().length() < 4) {
                        return false;
                    }
                    return f.getName().substring(f.getName().length() - 4).equalsIgnoreCase(".txt");
                }

                public String getDescription() {
                    return "\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb(*.txt)";
                }
            };
            chooser.addChoosableFileFilter(txtFilter);
            chooser.setFileFilter(htmlFilter);
            chooser.setSelectedFile(new File(this.currentDirectory, String.valueOf(new SimpleDateFormat("yyyyMMdd").format(new Date())) + ".html"));
            int ret = chooser.showSaveDialog(this.view);
            if (ret == 0) {
                File file = chooser.getSelectedFile();
                this.currentDirectory = file.getParent();
                FileWriter out = null;
                try {
                    try {
                        out = new FileWriter(file);
                        if (chooser.getFileFilter() == txtFilter) {
                            System.out.println(this.view.getLogDoc().toString());
                            new DefaultEditorKit().write(out, (Document)this.view.getLogDoc(), 0, this.view.getLogDoc().getLength());
                            break block14;
                        }
                        HteWriter writer = new HteWriter((Writer)out, (Document)this.view.getLogDoc(), 0, this.view.getLogDoc().getLength());
                        writer.write();
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException e1) {
                            this.getLogger().log(Level.SEVERE, e1.getMessage(), e1);
                        }
                    }
                }
            }
        }
    }

    @Action
    public void removeUser() {
    }
}

