/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.client;

import application.Application;
import application.ApplicationContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import jp.sf.chaplet.DisplayMode;
import jp.sf.chaplet.core.client.ChatClient;
import jp.sf.chaplet.core.client.ChatConnection;
import jp.sf.chaplet.core.client.ClientAction;
import jp.sf.chaplet.core.ui.IPluginView;
import jp.sf.chaplet.core.ui.IPrefView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientPlugin
extends Application {
    public static final String NAME = "Application.name";
    private ChatClient ctl;
    private HashMap<String, ClientAction> actionMap = new HashMap();
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private DisplayMode displayMode = DisplayMode.NONE;

    public final void init(ChatClient ctl) throws Exception {
        this.ctl = ctl;
        this.startup();
    }

    public void destroy() {
        this.shutdown();
    }

    protected void addAction(String name, ClientAction action) {
        this.actionMap.put(name, action);
    }

    protected void removeAction(String name) {
        this.actionMap.remove(name);
    }

    protected ClientAction getAction(String name) {
        return this.actionMap.get(name);
    }

    public abstract JPanel getSwingComponent();

    public ChatClient getController() {
        return this.ctl;
    }

    protected ChatConnection getConnection() {
        return this.ctl.getConnection();
    }

    protected boolean isConnected() {
        return this.ctl.getConnection() != null && this.ctl.getConnection().isConnected();
    }

    public abstract IPluginView getPluginView();

    public abstract String getPluginId();

    public void setGM(boolean gm) {
        this.getPluginView().setGM(gm);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        DisplayMode oldValue = this.displayMode;
        this.displayMode = displayMode;
        this.firePropertyChange("displayMode", (Object)oldValue, (Object)displayMode);
    }

    public String getName() {
        return ApplicationContext.getInstance().getResourceMap(((Object)((Object)this)).getClass()).getString(NAME, new Object[0]);
    }

    public List<IPrefView> getPrefViewList() {
        return Collections.EMPTY_LIST;
    }
}

