/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.io.IOException;
import jp.sf.chaplet.ActionResult;
import jp.sf.chaplet.core.server.ChatServer;
import jp.sf.chaplet.core.server.ClientProxy;
import jp.sf.chaplet.core.server.ServerPlugin;
import jp.sf.chaplet.core.server.UserManager;

public abstract class ServerAction {
    private ChatServer server;
    private ServerPlugin plugin;
    public static final Time PARENT_FIRST = new Time(){

        public ActionResult execute(ServerAction parent, ServerAction child, String[] request, ClientProxy invoker) throws IOException {
            if (parent != null) {
                ActionResult result = parent.execute(request, invoker);
                if (result == ActionResult.OK_NEXT && child != null) {
                    return child.execute(request, invoker);
                }
                return result;
            }
            if (child != null) {
                return child.execute(request, invoker);
            }
            return ActionResult.NULL;
        }
    };
    public static final Time CHILD_FIRST = new Time(){

        public ActionResult execute(ServerAction parent, ServerAction child, String[] request, ClientProxy invoker) throws IOException {
            if (child != null) {
                ActionResult result = child.execute(request, invoker);
                if (result == ActionResult.OK_NEXT && parent != null) {
                    return parent.execute(request, invoker);
                }
                return result;
            }
            if (parent != null) {
                return child.execute(request, invoker);
            }
            return ActionResult.NULL;
        }
    };
    public static final Time CHILD_ONLY = new Time(){

        public ActionResult execute(ServerAction parent, ServerAction child, String[] request, ClientProxy invoker) throws IOException {
            return child.execute(request, invoker);
        }
    };
    public static final Time WAIT_FOR_PARENT_CALL = new Time(){

        public ActionResult execute(ServerAction parent, ServerAction child, String[] request, ClientProxy invoker) throws IOException {
            return parent.execute(request, invoker);
        }
    };

    public Time getExecutionTime() {
        return PARENT_FIRST;
    }

    public void init(ChatServer server, ServerPlugin plugin) {
        this.server = server;
        this.plugin = plugin;
    }

    public abstract ActionResult execute(String[] var1, ClientProxy var2) throws IOException;

    ActionResult executeChild(String[] request, ClientProxy proxy) throws IOException {
        ServerAction action = this.server.getPluginAction(request[0]);
        if (action != null) {
            return action.execute(request, proxy);
        }
        return ActionResult.NULL;
    }

    protected void sendLog(String[] logs) throws IOException {
        this.server.sendLog(logs);
    }

    protected void sendLog(String[] logs, ClientProxy ignoredProxy) throws IOException {
        this.server.sendLog(logs, ignoredProxy);
    }

    public ChatServer getServer() {
        return this.server;
    }

    protected void sendStatus() {
        this.getServer().sendStatus();
    }

    protected UserManager getUserManager() {
        return this.getServer().getUserManager();
    }

    public ServerPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isAdmin(String sessionId) {
        return sessionId.equals(this.getServer().getOwner()) || sessionId.equals(this.getUserManager().getMasterId());
    }

    public boolean isOwner(String sessionId) {
        return sessionId.equals(this.getServer().getOwner());
    }

    public static abstract class Time {
        public abstract ActionResult execute(ServerAction var1, ServerAction var2, String[] var3, ClientProxy var4) throws IOException;
    }
}

