/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jp.sf.chaplet.ConfigLoader;
import jp.sf.chaplet.Configuration;
import jp.sf.chaplet.Plugin;
import jp.sf.chaplet.core.ui.BasicPrefPanel;
import jp.sf.chaplet.core.ui.IPrefView;
import jp.sf.chaplet.core.ui.PrefTreeEntry;
import jp.sf.chaplet.swing.MutableTreeModel;

public class PreferenceDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JScrollPane menuPane = null;
    private JTree menuTree = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel prefPanel = null;
    private JLabel prefHeaderLabel = null;
    private JSplitPane jSplitPane = null;
    private MutableTreeModel treeModel = null;
    private JPanel editPanel = null;
    private JPanel emptyPanel = null;
    private DefaultTreeCellRenderer treeCellRenderer = null;
    private JLabel errorLabel = null;

    public PreferenceDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(585, 450);
        this.setTitle("\u8a2d\u5b9a");
        this.setContentPane(this.getJContentPane());
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        CardLayout layout = (CardLayout)this.getEditPanel().getLayout();
        DefaultMutableTreeNode basicNode = new DefaultMutableTreeNode();
        PrefTreeEntry basicEntry = new PrefTreeEntry("\u57fa\u672c\u8a2d\u5b9a", null);
        basicNode.setUserObject(basicEntry);
        this.getTreeModel().insertNodeInto(basicNode, root, root.getChildCount());
        DefaultMutableTreeNode fontNode = new DefaultMutableTreeNode();
        PrefTreeEntry fontEntry = new PrefTreeEntry("\u30d5\u30a9\u30f3\u30c8\u8a2d\u5b9a", new BasicPrefPanel());
        fontNode.setUserObject(fontEntry);
        this.getTreeModel().insertNodeInto(fontNode, basicNode, basicNode.getChildCount());
        this.getEditPanel().add((Component)fontEntry.getView(), fontEntry.toString());
        Configuration conf = ConfigLoader.getInstance().load();
        for (Plugin plugin : conf.getPlugins()) {
            List<IPrefView> list = plugin.getClientPlugin().getPrefViewList();
            if (list.size() <= 0) continue;
            DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode();
            PrefTreeEntry categoryEntry = new PrefTreeEntry(plugin.getClientPlugin().getName(), null);
            categoryNode.setUserObject(categoryEntry);
            this.getTreeModel().insertNodeInto(categoryNode, root, root.getChildCount());
            for (IPrefView view : list) {
                DefaultMutableTreeNode leaf = new DefaultMutableTreeNode();
                PrefTreeEntry entry = new PrefTreeEntry(view.getTitle(), (JPanel)((Object)view));
                leaf.setUserObject(entry);
                this.getTreeModel().insertNodeInto(leaf, categoryNode, categoryNode.getChildCount());
                this.getEditPanel().add((Component)entry.getView(), entry.toString());
            }
        }
        this.getTreeModel().reload();
        layout.show(this.editPanel, "emptyPanel");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 3, 5, 2);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(10, 5, 10, 2);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            this.errorLabel = new JLabel();
            this.errorLabel.setText("");
            this.errorLabel.setForeground(Color.red);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.errorLabel, gridBagConstraints);
            this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints1);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints2);
        }
        return this.buttonPanel;
    }

    private JScrollPane getMenuPane() {
        if (this.menuPane == null) {
            this.menuPane = new JScrollPane();
            this.menuPane.setHorizontalScrollBarPolicy(31);
            this.menuPane.setViewportView(this.getMenuTree());
        }
        return this.menuPane;
    }

    private JTree getMenuTree() {
        if (this.menuTree == null) {
            this.menuTree = new JTree();
            this.menuTree.setRootVisible(false);
            this.menuTree.setCellRenderer(this.getTreeCellRenderer());
            this.menuTree.setModel(this.getTreeModel());
            this.menuTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getPath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node != null) {
                        CardLayout layout = (CardLayout)PreferenceDialog.this.editPanel.getLayout();
                        PrefTreeEntry entry = (PrefTreeEntry)node.getUserObject();
                        if (entry.getView() != null) {
                            layout.show(PreferenceDialog.this.getEditPanel(), entry.toString());
                            PreferenceDialog.this.prefHeaderLabel.setText(entry.getName());
                        } else {
                            layout.show(PreferenceDialog.this.getEditPanel(), PreferenceDialog.this.getEmptyPanel().getName());
                            PreferenceDialog.this.prefHeaderLabel.setText(" ");
                        }
                    }
                }
            });
        }
        return this.menuTree;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ArrayList<IPrefView> viewList = new ArrayList<IPrefView>();
                    int i = 0;
                    while (i < PreferenceDialog.this.getEditPanel().getComponentCount()) {
                        Component comp = PreferenceDialog.this.getEditPanel().getComponent(i);
                        if (comp instanceof IPrefView) {
                            IPrefView view = (IPrefView)((Object)comp);
                            String error = view.checkError();
                            if (error != null) {
                                PreferenceDialog.this.errorLabel.setText(error);
                                return;
                            }
                            viewList.add(view);
                        }
                        ++i;
                    }
                    for (IPrefView view : viewList) {
                        view.save();
                    }
                    PreferenceDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getPrefPanel() {
        if (this.prefPanel == null) {
            this.prefHeaderLabel = new JLabel();
            this.prefHeaderLabel.setText(" ");
            this.prefHeaderLabel.setBackground(Color.white);
            this.prefHeaderLabel.setBorder(BorderFactory.createLineBorder(Color.gray, 5));
            this.prefPanel = new JPanel();
            this.prefPanel.setLayout(new BorderLayout());
            this.prefPanel.add((Component)this.prefHeaderLabel, "North");
            this.prefPanel.add((Component)this.getEditPanel(), "Center");
        }
        return this.prefPanel;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(120);
            this.jSplitPane.setLeftComponent(this.getMenuPane());
            this.jSplitPane.setRightComponent(this.getPrefPanel());
        }
        return this.jSplitPane;
    }

    private MutableTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new MutableTreeModel();
        }
        return this.treeModel;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            this.editPanel.setLayout(new CardLayout());
            this.editPanel.add((Component)this.getEmptyPanel(), "emptyPanel");
        }
        return this.editPanel;
    }

    private JPanel getEmptyPanel() {
        if (this.emptyPanel == null) {
            this.emptyPanel = new JPanel();
            this.emptyPanel.setLayout(new GridBagLayout());
            this.emptyPanel.setName("emptyPanel");
        }
        return this.emptyPanel;
    }

    private DefaultTreeCellRenderer getTreeCellRenderer() {
        if (this.treeCellRenderer == null) {
            this.treeCellRenderer = new DefaultTreeCellRenderer();
        }
        return this.treeCellRenderer;
    }
}

