/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.dx.server;

import java.util.HashMap;
import jp.sf.chaplet.core.server.ServerAction;
import jp.sf.chaplet.core.server.ServerPlugin;
import jp.sf.chaplet.core.server.User;
import jp.sf.chaplet.dx.DxCharacter;
import jp.sf.chaplet.dx.server.RollAction;
import jp.sf.chaplet.dx.server.SetDxStatusAction;

public class DxServerPlugin
extends ServerPlugin {
    private HashMap<String, DxCharacter> characterMap = new HashMap();

    public String getPluginId() {
        return "jp.sf.chaplet.dx";
    }

    public void init() throws Exception {
        ServerAction[] actions = new ServerAction[]{new SetDxStatusAction(), new RollAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this.server, (ServerPlugin)this);
            ++i;
        }
        this.addAction("dx:status", actions[0]);
        this.addAction("dx:roll", actions[1]);
    }

    public String getUserStatus(User user) {
        DxCharacter chara = this.characterMap.get(user.getSessionId());
        if (chara == null) {
            chara = new DxCharacter();
            this.characterMap.put(user.getSessionId(), chara);
        }
        return "hp:" + chara.getHp() + " / \u4fb5\u98df\u7387:" + chara.getInvasion() + " / \u30ed\u30a4\u30b9\u6570:" + chara.getNumLois();
    }

    public DxCharacter getCharacter(String key) {
        DxCharacter chara = this.characterMap.get(key);
        if (chara == null) {
            chara = new DxCharacter();
        }
        return chara;
    }

    public DxCharacter setCharacter(String key, DxCharacter value) {
        return this.characterMap.put(key, value);
    }
}

