/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsImageCollectionParser;

public abstract class ImageBuildJobAbstractAdaptor
implements AsyncImageBuilder.AsyncImageBuildJob {
    protected PartsImageCollectionParser partsImageCollectorParser;

    public ImageBuildJobAbstractAdaptor(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsImageCollectorParser = new PartsImageCollectionParser(partsSpecResolver);
    }

    public void loadParts(final ImageBuilder.ImageSourceCollector imageSourceCollector) throws Exception {
        if (imageSourceCollector == null) {
            throw new IllegalArgumentException("collector is null");
        }
        PartsSet partsSet = this.getPartsSet();
        if (partsSet == null) {
            throw new RuntimeException("PartsSet is null");
        }
        imageSourceCollector.setSize(this.partsImageCollectorParser.getPartsSpecResolver().getImageSize());
        imageSourceCollector.setImageBgColor(partsSet.getBgColor());
        imageSourceCollector.setAffineTramsform(partsSet.getAffineTransformParameter());
        this.partsImageCollectorParser.parse(partsSet, new PartsImageCollectionParser.PartsImageCollectionHandler(){

            public void detectImageSource(PartsIdentifier partsIdentifier, Layer layer, ImageResource imageResource, ColorConvertParameter colorConvertParameter) {
                if (colorConvertParameter == null) {
                    colorConvertParameter = new ColorConvertParameter();
                }
                imageSourceCollector.setImageSource(layer, imageResource, colorConvertParameter);
            }
        });
        imageSourceCollector.setComplite();
    }

    protected abstract PartsSet getPartsSet() throws Exception;

    public abstract void buildImage(ImageBuilder.ImageOutput var1) throws Exception;

    public abstract void handleException(Exception var1);

    public void onAbandoned() {
    }

    public void onQueueing(long l) {
    }
}

