/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public abstract class AbstractFilter
implements BufferedImageOp {
    protected abstract void filter(int[] var1);

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray;
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        boolean bl = false;
        if (bufferedImage == bufferedImage2 && (n3 == 2 || n3 == 1)) {
            nArray = null;
            bl = true;
        } else {
            int n4 = n * n2;
            nArray = new int[n4];
        }
        nArray = this.getPixcels(bufferedImage, 0, 0, n, n2, nArray);
        this.filter(nArray);
        if (!bl) {
            this.setPixcels(bufferedImage2, 0, 0, n, n2, nArray);
        }
        return bufferedImage2;
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        return new Rectangle(0, 0, n, n2);
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return (Point2D)point2D.clone();
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    protected int[] getPixcels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 <= 0 || n4 <= 0) {
            return new int[0];
        }
        int n5 = n3 * n4;
        if (nArray != null && nArray.length < n5) {
            throw new IllegalArgumentException("array too short.");
        }
        int n6 = bufferedImage.getType();
        if (n6 == 2 || n6 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (nArray == null) {
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                return dataBufferInt.getData();
            }
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        if (nArray == null) {
            throw new IllegalArgumentException("image type error.");
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    protected void setPixcels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = n3 * n4;
        if (nArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (nArray.length < n5) {
            throw new IllegalArgumentException("array too short.");
        }
        int n6 = bufferedImage.getType();
        if (n6 == 2 || n6 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n, n2, n3, n4, nArray);
            return;
        }
        bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
    }
}

