/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageCache;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class ImageCachedLoader
implements ImageLoader {
    private int cacheSize;
    private long sweepThreshold;
    private LinkedList<ImageCache> caches = new LinkedList();

    public ImageCachedLoader(int n, long l) {
        this.cacheSize = n;
        this.sweepThreshold = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage load(ImageResource imageResource) throws IOException {
        Object object;
        Object object2;
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis();
        long l2 = imageResource.lastModified();
        Object object3 = null;
        LinkedList<ImageCache> linkedList = this.caches;
        synchronized (linkedList) {
            object2 = this.caches.iterator();
            while (object2.hasNext()) {
                object = (ImageCache)object2.next();
                if (!((Object)imageResource).equals(((ImageCache)object).getImageResource()) || ((ImageCache)object).getLastModified() != l2) continue;
                ((ImageCache)object).setLastUsed(l);
                object2.remove();
                this.caches.addFirst((ImageCache)object);
                object3 = ((ImageCache)object).getImage();
                break;
            }
        }
        if (object3 == null) {
            object3 = ImageIO.read(imageResource.openStream());
            if (object3 == null) {
                throw new IOException("unsupported image");
            }
            int n = ((BufferedImage)object3).getType();
            if (n != 2) {
                object2 = new BufferedImage(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight(), 2);
                object = ((BufferedImage)object2).getGraphics();
                try {
                    ((Graphics)object).drawImage((Image)object3, 0, 0, null);
                }
                finally {
                    ((Graphics)object).dispose();
                }
                object3 = object2;
            }
            object2 = new ImageCache();
            ((ImageCache)object2).setImageResource(imageResource);
            ((ImageCache)object2).setLastModified(l2);
            ((ImageCache)object2).setLastUsed(l);
            ((ImageCache)object2).setImage((BufferedImage)object3);
            object = this.caches;
            synchronized (object) {
                this.caches.addFirst((ImageCache)object2);
            }
        }
        this.sweep();
        return object3;
    }

    public void sweep() {
        this.sweep(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep(File file) {
        long l = System.currentTimeMillis();
        LinkedList<ImageCache> linkedList = this.caches;
        synchronized (linkedList) {
            Iterator iterator = this.caches.iterator();
            while (iterator.hasNext()) {
                ImageCache imageCache = (ImageCache)iterator.next();
                if (l - imageCache.getLastUsed() > this.sweepThreshold) {
                    iterator.remove();
                    continue;
                }
                if (file == null || !file.equals(imageCache.getImageResource())) continue;
                iterator.remove();
                file = null;
            }
            while (this.caches.size() > this.cacheSize) {
                this.caches.removeLast();
            }
        }
    }
}

