/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.model.AppConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageSaveHelper {
    private static final FileFilter pngFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".png");
        }

        public String getDescription() {
            return "PNG(*.png)";
        }
    };
    private static final FileFilter jpegFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jpg") || file.getName().endsWith(".jpeg");
        }

        public String getDescription() {
            return "JPEG(*.jpg;*.jpeg)";
        }
    };
    protected File lastUseSaveDir;

    public void setLastUseSaveDir(File file) {
        this.lastUseSaveDir = file;
    }

    public File getLastUsedSaveDir() {
        return this.lastUseSaveDir;
    }

    public File showSaveFileDialog(Component component) {
        JFileChooser jFileChooser = new JFileChooser(this.lastUseSaveDir){
            private static final long serialVersionUID = -9091369410030011886L;

            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file == null) {
                    return;
                }
                String string = file.getName().toLowerCase();
                FileFilter fileFilter = this.getFileFilter();
                if (fileFilter == pngFilter) {
                    if (!string.endsWith(".png")) {
                        file = new File(file.getPath() + ".png");
                        this.setSelectedFile(file);
                    }
                } else if (fileFilter == jpegFilter && !string.endsWith(".jpeg") && !string.endsWith(".jpg")) {
                    file = new File(file.getPath() + ".jpeg");
                    this.setSelectedFile(file);
                }
                if (file.exists() && JOptionPane.showConfirmDialog(this, "\u4e0a\u66f8\u304d\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        jFileChooser.addChoosableFileFilter(pngFilter);
        jFileChooser.addChoosableFileFilter(jpegFilter);
        jFileChooser.setFileFilter(pngFilter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        this.lastUseSaveDir = file.getParentFile();
        return file;
    }

    public void savePicture(BufferedImage bufferedImage, Color color, File file, StringBuilder stringBuilder) throws IOException {
        if (bufferedImage == null || file == null) {
            throw new IllegalArgumentException();
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            throw new IOException("missing file extension.");
        }
        String string2 = string.substring(n + 1).toLowerCase();
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string2);
        if (!iterator.hasNext()) {
            throw new IOException("unsupported file extension: " + string2);
        }
        ImageWriter imageWriter = iterator.next();
        this.savePicture(bufferedImage, color, imageWriter, file, stringBuilder);
    }

    public void savePicture(BufferedImage bufferedImage, Color color, OutputStream outputStream, String string, StringBuilder stringBuilder) throws IOException {
        if (bufferedImage == null || outputStream == null || string == null) {
            throw new IllegalArgumentException();
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        if (!iterator.hasNext()) {
            throw new IOException("unsupported mime: " + string);
        }
        ImageWriter imageWriter = iterator.next();
        this.savePicture(bufferedImage, color, imageWriter, outputStream, stringBuilder);
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePicture(BufferedImage bufferedImage, Color color, ImageWriter imageWriter, Object object, final StringBuilder stringBuilder) throws IOException {
        try {
            if (stringBuilder != null) {
                imageWriter.addIIOWriteWarningListener(new IIOWriteWarningListener(){

                    public void warningOccurred(ImageWriter imageWriter, int n, String string) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(System.getProperty("line.separator"));
                        }
                        stringBuilder.append(string);
                    }
                });
            }
            boolean bl = false;
            boolean bl2 = false;
            for (String string : imageWriter.getOriginatingProvider().getMIMETypes()) {
                if (string.contains("image/jpeg")) {
                    bl = true;
                    break;
                }
                if (!string.contains("image/png") && !string.contains("image/x-png")) continue;
                bl2 = true;
                break;
            }
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            if (bl) {
                AppConfig appConfig = AppConfig.getInstance();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(appConfig.getCompressionQuality());
            }
            IIOImage iIOImage = !bl2 ? new IIOImage(this.createJpegFormatPicture(bufferedImage, color), null, null) : new IIOImage(bufferedImage, null, null);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(object);
            try {
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, iIOImage, imageWriteParam);
            }
            finally {
                imageOutputStream.close();
            }
        }
        finally {
            imageWriter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createJpegFormatPicture(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException();
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 4);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            if (color == null) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setColor(color);
            }
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, n, n2, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }
}

