/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.Main;
import charactermanaj.util.ErrorMessageHelper;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;

public final class AppConfig {
    private static final String CONFIG_NAME = "appConfig.xml";
    private static final String CHARACTER_BASE_DIR = "characters.dir";
    private static final String DEFAULT_PROFILE_NAME = "default.profile.name";
    public static final String BASENAME = ".charactermanaj";
    public static final String APP_VERSION = "1.0";
    private final File codeBase;
    private final File appDataDir;
    private Properties config = new Properties();
    private static final AppConfig singleton = new AppConfig();

    public static AppConfig getInstance() {
        return singleton;
    }

    private AppConfig() {
        this.codeBase = this.initBaseDir();
        this.appDataDir = this.initAppDateDir();
        this.renovateAndValidate();
    }

    private File initBaseDir() {
        try {
            URL uRL;
            ProtectionDomain protectionDomain = Main.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null && (uRL = codeSource.getLocation()).getProtocol().equals("file")) {
                File file = new File(uRL.getPath());
                return file;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ErrorMessageHelper.showErrorDialog(null, exception);
        }
        return new File(".").getAbsoluteFile();
    }

    private File initAppDateDir() {
        String string = null;
        try {
            string = System.getProperty("APPDATA");
            if (string == null) {
                // empty if block
            }
            string = System.getenv("APPDATA");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return new File(string, BASENAME);
    }

    private void renovateAndValidate() {
        if (!this.config.containsKey(CHARACTER_BASE_DIR)) {
            this.config.setProperty(CHARACTER_BASE_DIR, "../characters");
        }
        if (!this.config.containsKey(DEFAULT_PROFILE_NAME)) {
            this.config.setProperty(DEFAULT_PROFILE_NAME, "default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        Properties properties = new Properties();
        try {
            URL[] uRLArray;
            for (URL uRL : uRLArray = new URL[]{this.getClass().getResource("/appConfig.xml"), new File(this.codeBase, "../appConfig.xml").getCanonicalFile().toURL(), new File(this.getAppDataDir(), CONFIG_NAME).toURL()}) {
                try {
                    InputStream inputStream = uRL.openStream();
                    if (inputStream == null) continue;
                    try {
                        properties.loadFromXML(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("appConfig.xml load failed.", exception);
        }
        this.config = properties;
        this.renovateAndValidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        File file = new File(this.getAppDataDir(), CONFIG_NAME);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.config.storeToXML((OutputStream)bufferedOutputStream, CONFIG_NAME, "UTF-8");
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public File getSystemCharactersDir() {
        File file = new File(this.config.getProperty(CHARACTER_BASE_DIR));
        try {
            if (!file.isAbsolute()) {
                file = new File(this.codeBase, file.getPath());
            }
            return file.getAbsoluteFile().getCanonicalFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("invalid characterBaseDir: " + file, exception);
        }
    }

    public File getUserCharactersDir() {
        File file = new File(this.getAppDataDir(), "characters");
        file.mkdirs();
        return file;
    }

    public File getAppDataDir() {
        this.appDataDir.mkdirs();
        return this.appDataDir;
    }

    public String getDefaultProfileId() {
        return this.config.getProperty(DEFAULT_PROFILE_NAME);
    }

    public Color getSampleImageBgColor() {
        return Color.white;
    }

    public Color getDefaultImageBgColor() {
        return Color.white;
    }

    public Color getCheckedItemBgColor() {
        return Color.cyan.brighter();
    }

    public Color getSelectedItemBgColor() {
        return Color.orange;
    }

    public Color getInvalidBgColor() {
        return Color.red.brighter().brighter();
    }

    public float getCompressionQuality() {
        return 1.0f;
    }

    public Color getExportPresetWarningsForegroundColor() {
        return Color.red;
    }

    public int getJarTransferBufferSize() {
        return 4096;
    }

    public String getZipNameEncoding() {
        return "MS932";
    }

    public Color getDisabledCellForgroundColor() {
        return Color.gray;
    }

    public int getDirWatchInterval() {
        return 7000;
    }

    public boolean isEnableDirWatch() {
        return true;
    }

    public int getFileTransferBufferSize() {
        return 4096;
    }
}

