/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 5049488493598426918L;
    public static final OrderedMap<?, ?> EMPTY_MAP = new OrderedMap();
    private ArrayList<Map.Entry<K, V>> entries = new ArrayList();
    private transient HashMap<K, V> entryMap = new HashMap();

    public static final <K, V> OrderedMap<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.entryMap = new HashMap();
        for (Map.Entry<K, V> entry : this.entries) {
            this.entryMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    protected OrderedMap() {
    }

    public OrderedMap(Collection<V> collection, KeyDetector<K, V> keyDetector) {
        if (collection == null || keyDetector == null) {
            throw new IllegalArgumentException();
        }
        for (V v : collection) {
            K k = keyDetector.getKey(v);
            if (k == null) {
                throw new IllegalArgumentException("null key: " + v);
            }
            this.entries.add(new OrderedMapEntry<K, V>(k, v));
            this.entryMap.put(k, v);
        }
        if (this.entries.size() != this.entryMap.size()) {
            throw new IllegalArgumentException("duplicate-key");
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return OrderedMap.this.entries.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = OrderedMap.this.entries.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return (Map.Entry)iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<V> asList() {
        return new AbstractList<V>(){

            @Override
            public int size() {
                return OrderedMap.this.entries.size();
            }

            @Override
            public V get(int n) {
                return ((Map.Entry)OrderedMap.this.entries.get(n)).getValue();
            }
        };
    }

    @Override
    public V get(Object object) {
        return this.entryMap.get(object);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OrderedMapEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 5111249402034089224L;
        private final K key;
        private final V data;

        protected OrderedMapEntry(K k, V v) {
            this.key = k;
            this.data = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.data;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyDetector<K, V> {
        public K getKey(V var1);
    }
}

