/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataJarArchiveFile;
import charactermanaj.model.io.CharacterDataJarFileWriter;
import charactermanaj.model.io.CharacterDataWriter;
import charactermanaj.model.io.CharacterDataZipArchiveFile;
import charactermanaj.model.io.CharacterDataZipFileWriter;
import java.io.File;
import java.io.IOException;

public class CharacterDataFileReaderWriterFactory {
    private static final CharacterDataFileReaderWriterFactory singleton = new CharacterDataFileReaderWriterFactory();

    private CharacterDataFileReaderWriterFactory() {
    }

    public static CharacterDataFileReaderWriterFactory getInstance() {
        return singleton;
    }

    public CharacterDataWriter createWriter(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        String string = file.getName().toLowerCase();
        if (string.endsWith(".jar") || string.endsWith(".cmj")) {
            return new CharacterDataJarFileWriter(file);
        }
        if (string.endsWith(".zip")) {
            return new CharacterDataZipFileWriter(file);
        }
        throw new IOException("unsupported file type: " + string);
    }

    public CharacterDataArchiveFile openArchive(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        String string = file.getName().toLowerCase();
        if (string.endsWith(".jar") || string.endsWith(".cmj")) {
            return new CharacterDataJarArchiveFile(file);
        }
        if (string.endsWith(".zip")) {
            return new CharacterDataZipArchiveFile(file);
        }
        throw new IOException("unsupported file type: " + string);
    }
}

