/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsFiles;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import java.util.List;
import java.util.Map;

public class PartsImageCollectionParser {
    protected PartsSpecResolver partsSpecResolver;

    public PartsImageCollectionParser(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException("resolver is null");
        }
        this.partsSpecResolver = partsSpecResolver;
    }

    public PartsSpecResolver getPartsSpecResolver() {
        return this.partsSpecResolver;
    }

    public void parse(PartsSet partsSet, PartsImageCollectionHandler partsImageCollectionHandler) {
        if (partsImageCollectionHandler == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (partsSet == null) {
            throw new IllegalArgumentException("PartsSet is null");
        }
        for (List list : partsSet.values()) {
            for (PartsIdentifier partsIdentifier : list) {
                PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                PartsSpec partsSpec = this.partsSpecResolver.getPartsSpec(partsIdentifier);
                if (partsSpec == null) continue;
                PartsFiles partsFiles = partsSpec.getPartsFiles();
                for (Map.Entry<Layer, ImageResource> entry : partsFiles.entrySet()) {
                    ColorInfo colorInfo;
                    Layer layer = entry.getKey();
                    ImageResource imageResource = entry.getValue();
                    ColorConvertParameter colorConvertParameter = null;
                    if (partsColorInfo != null && (colorInfo = (ColorInfo)partsColorInfo.get(layer)) != null) {
                        colorConvertParameter = colorInfo.getColorParameter();
                    }
                    partsImageCollectionHandler.detectImageSource(partsIdentifier, layer, imageResource, colorConvertParameter);
                }
            }
        }
    }

    public static interface PartsImageCollectionHandler {
        public void detectImageSource(PartsIdentifier var1, Layer var2, ImageResource var3, ColorConvertParameter var4);
    }
}

