/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorDialogTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbColorReplace;
    private JSpinner txtGray;
    private JSpinner txtOffsetR;
    private JSpinner txtOffsetG;
    private JSpinner txtOffsetB;
    private JSpinner txtOffsetA;
    private JSpinner txtFactorR;
    private JSpinner txtFactorG;
    private JSpinner txtFactorB;
    private JSpinner txtFactorA;
    private JSpinner txtHue;
    private JSpinner txtSaturation;
    private JSpinner txtBrightness;
    private JSpinner txtGammaR;
    private JSpinner txtGammaG;
    private JSpinner txtGammaB;
    private JSpinner txtGammaA;
    private JComboBox cmbColorGroup;
    private JCheckBox chkColorGroupSync;
    private final ColorDialog parent;
    private AtomicInteger disableEvent = new AtomicInteger();
    private ColorConvertParameter chachedParam;
    private LinkedList<ColorChangeListener> listeners = new LinkedList();

    public void addColorChangeListener(ColorChangeListener colorChangeListener) {
        if (colorChangeListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(colorChangeListener);
    }

    public void removeColorChangeListener(ColorChangeListener colorChangeListener) {
        this.listeners.remove(colorChangeListener);
    }

    protected void fireColorChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        this.chachedParam = null;
        if (this.disableEvent.get() <= 0) {
            ColorChangeEvent colorChangeEvent = new ColorChangeEvent(this.parent, layer);
            for (ColorChangeListener colorChangeListener : this.listeners) {
                colorChangeListener.onColorChange(colorChangeEvent);
            }
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        this.chachedParam = null;
        if (this.disableEvent.get() <= 0) {
            ColorChangeEvent colorChangeEvent = new ColorChangeEvent(this.parent, layer);
            for (ColorChangeListener colorChangeListener : this.listeners) {
                colorChangeListener.onColorGroupChange(colorChangeEvent);
            }
        }
    }

    public ColorDialogTabPanel(ColorDialog colorDialog, final Layer layer, Collection<ColorGroup> collection) {
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent;
        if (colorDialog == null || layer == null || collection == null) {
            throw new IllegalArgumentException();
        }
        this.parent = colorDialog;
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/colordialog");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 3);
        jPanel.setLayout(boxLayout);
        this.add((Component)jPanel, "North");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColorDialogTabPanel.this.fireColorChangeEvent(layer);
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("group.replacergb.caption"))));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(properties.getProperty("replacergb"), 4);
        this.cmbColorReplace = new JComboBox<ColorConv>(ColorConv.values());
        JLabel jLabel2 = new JLabel(properties.getProperty("bright"), 4);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.0, 1.0, 0.05);
        spinnerNumberModel.addChangeListener(changeListener);
        this.cmbColorReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorDialogTabPanel.this.fireColorChangeEvent(layer);
            }
        });
        this.txtGray = new JSpinner(spinnerNumberModel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)this.cmbColorReplace, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.txtGray, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("group.rgb.caption"))));
        GridLayout gridLayout = new GridLayout(4, 5);
        gridLayout.setHgap(2);
        gridLayout.setVgap(2);
        jPanel3.setLayout(gridLayout);
        jPanel3.add(Box.createGlue());
        jPanel3.add(new JLabel(properties.getProperty("red"), 0));
        jPanel3.add(new JLabel(properties.getProperty("green"), 0));
        jPanel3.add(new JLabel(properties.getProperty("blue"), 0));
        jPanel3.add(new JLabel(properties.getProperty("alpha"), 0));
        jPanel3.add(new JLabel(properties.getProperty("offset"), 4));
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel spinnerNumberModel4 = new SpinnerNumberModel(0, -255, 255, 1);
        SpinnerNumberModel spinnerNumberModel5 = new SpinnerNumberModel(0, -255, 255, 1);
        spinnerNumberModel2.addChangeListener(changeListener);
        spinnerNumberModel3.addChangeListener(changeListener);
        spinnerNumberModel4.addChangeListener(changeListener);
        spinnerNumberModel5.addChangeListener(changeListener);
        this.txtOffsetR = new JSpinner(spinnerNumberModel2);
        this.txtOffsetG = new JSpinner(spinnerNumberModel3);
        this.txtOffsetB = new JSpinner(spinnerNumberModel4);
        this.txtOffsetA = new JSpinner(spinnerNumberModel5);
        jPanel3.add(this.txtOffsetR);
        jPanel3.add(this.txtOffsetG);
        jPanel3.add(this.txtOffsetB);
        jPanel3.add(this.txtOffsetA);
        jPanel3.add(new JLabel(properties.getProperty("factor"), 4));
        SpinnerNumberModel spinnerNumberModel6 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel7 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel8 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel9 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        spinnerNumberModel6.addChangeListener(changeListener);
        spinnerNumberModel7.addChangeListener(changeListener);
        spinnerNumberModel8.addChangeListener(changeListener);
        spinnerNumberModel9.addChangeListener(changeListener);
        this.txtFactorR = new JSpinner(spinnerNumberModel6);
        this.txtFactorG = new JSpinner(spinnerNumberModel7);
        this.txtFactorB = new JSpinner(spinnerNumberModel8);
        this.txtFactorA = new JSpinner(spinnerNumberModel9);
        jPanel3.add(this.txtFactorR);
        jPanel3.add(this.txtFactorG);
        jPanel3.add(this.txtFactorB);
        jPanel3.add(this.txtFactorA);
        jPanel3.add(new JLabel(properties.getProperty("gamma"), 4));
        SpinnerNumberModel spinnerNumberModel10 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel11 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel12 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        SpinnerNumberModel spinnerNumberModel13 = new SpinnerNumberModel(1.0, 0.01, 99.0, 0.01);
        spinnerNumberModel10.addChangeListener(changeListener);
        spinnerNumberModel11.addChangeListener(changeListener);
        spinnerNumberModel12.addChangeListener(changeListener);
        spinnerNumberModel13.addChangeListener(changeListener);
        this.txtGammaR = new JSpinner(spinnerNumberModel10);
        this.txtGammaG = new JSpinner(spinnerNumberModel11);
        this.txtGammaB = new JSpinner(spinnerNumberModel12);
        this.txtGammaA = new JSpinner(spinnerNumberModel13);
        jPanel3.add(this.txtGammaR);
        jPanel3.add(this.txtGammaG);
        jPanel3.add(this.txtGammaB);
        jPanel3.add(this.txtGammaA);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("group.hsb.caption"))));
        GridLayout gridLayout2 = new GridLayout(3, 3);
        gridLayout2.setHgap(3);
        gridLayout2.setVgap(3);
        jPanel4.setLayout(gridLayout2);
        jPanel4.add(new JLabel(properties.getProperty("hue"), 0));
        jPanel4.add(new JLabel(properties.getProperty("saturation"), 0));
        jPanel4.add(new JLabel(properties.getProperty("brightness"), 0));
        SpinnerNumberModel spinnerNumberModel14 = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        SpinnerNumberModel spinnerNumberModel15 = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        SpinnerNumberModel spinnerNumberModel16 = new SpinnerNumberModel(0.0, -1.0, 1.0, 0.01);
        spinnerNumberModel14.addChangeListener(changeListener);
        spinnerNumberModel15.addChangeListener(changeListener);
        spinnerNumberModel16.addChangeListener(changeListener);
        this.txtHue = new JSpinner(spinnerNumberModel14);
        this.txtSaturation = new JSpinner(spinnerNumberModel15);
        this.txtBrightness = new JSpinner(spinnerNumberModel16);
        jPanel4.add(this.txtHue);
        jPanel4.add(this.txtSaturation);
        jPanel4.add(this.txtBrightness);
        JSlider jSlider = new JSlider();
        JSlider jSlider2 = new JSlider();
        JSlider jSlider3 = new JSlider();
        jSlider.setPreferredSize(this.txtHue.getPreferredSize());
        jSlider2.setPreferredSize(this.txtSaturation.getPreferredSize());
        jSlider3.setPreferredSize(this.txtBrightness.getPreferredSize());
        jPanel4.add(jSlider);
        jPanel4.add(jSlider2);
        jPanel4.add(jSlider3);
        JSlider[] jSliderArray = new JSlider[]{jSlider, jSlider2, jSlider3};
        JSpinner[] jSpinnerArray = new JSpinner[]{this.txtHue, this.txtSaturation, this.txtBrightness};
        for (int i = 0; i < jSpinnerArray.length; ++i) {
            jComponent = jSliderArray[i];
            serializable2 = jSpinnerArray[i];
            ((JSlider)jComponent).setMinimum(-100);
            ((JSlider)jComponent).setMaximum(100);
            ((JSlider)jComponent).setValue((int)(((Number)((JSpinner)serializable2).getValue()).doubleValue() * 100.0));
            serializable = new Semaphore(1);
            ((JSlider)jComponent).addChangeListener(new ChangeListener((Semaphore)serializable, (JSlider)jComponent, (JSpinner)serializable2){
                final /* synthetic */ Semaphore val$loopBlocker;
                final /* synthetic */ JSlider val$sl;
                final /* synthetic */ JSpinner val$sp;
                {
                    this.val$loopBlocker = semaphore;
                    this.val$sl = jSlider;
                    this.val$sp = jSpinner;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$loopBlocker.tryAcquire()) {
                        try {
                            double d = (double)this.val$sl.getValue() / 100.0;
                            this.val$sp.setValue(d);
                        }
                        finally {
                            this.val$loopBlocker.release();
                        }
                    }
                }
            });
            ((JSpinner)serializable2).addChangeListener(new ChangeListener((Semaphore)serializable, (JSpinner)serializable2, (JSlider)jComponent){
                final /* synthetic */ Semaphore val$loopBlocker;
                final /* synthetic */ JSpinner val$sp;
                final /* synthetic */ JSlider val$sl;
                {
                    this.val$loopBlocker = semaphore;
                    this.val$sp = jSpinner;
                    this.val$sl = jSlider;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$loopBlocker.tryAcquire()) {
                        try {
                            int n = (int)(((Number)this.val$sp.getValue()).doubleValue() * 100.0);
                            this.val$sl.setValue(n);
                        }
                        finally {
                            this.val$loopBlocker.release();
                        }
                    }
                }
            });
        }
        ColorGroup colorGroup = layer.getColorGroup();
        jComponent = new JPanel();
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(properties.getProperty("colorgroup"))));
        serializable2 = new GridBagLayout();
        jComponent.setLayout((LayoutManager)((Object)serializable2));
        serializable = new GridBagConstraints();
        JLabel jLabel3 = new JLabel(properties.getProperty("group"), 4);
        this.cmbColorGroup = new JComboBox<ColorGroup>(collection.toArray(new ColorGroup[collection.size()]));
        this.cmbColorGroup.setSelectedItem(colorGroup);
        this.cmbColorGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorGroup colorGroup = (ColorGroup)ColorDialogTabPanel.this.cmbColorGroup.getSelectedItem();
                ColorDialogTabPanel.this.chkColorGroupSync.setSelected(colorGroup.isEnabled());
                ColorDialogTabPanel.this.fireColorGroupChangeEvent(layer);
            }
        });
        this.chkColorGroupSync = new JCheckBox(properties.getProperty("synchronized"));
        this.chkColorGroupSync.setSelected(layer.isInitSync());
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).ipadx = 0;
        ((GridBagConstraints)serializable).ipady = 0;
        ((GridBagConstraints)serializable).insets = new Insets(3, 3, 3, 3);
        jComponent.add((Component)jLabel3, serializable);
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        jComponent.add((Component)this.cmbColorGroup, serializable);
        ((GridBagConstraints)serializable).gridx = 2;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        jComponent.add((Component)this.chkColorGroupSync, serializable);
        if (jComponent != null) {
            jPanel.add(jComponent);
        }
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorConvertParameter(ColorConvertParameter colorConvertParameter) {
        if (colorConvertParameter == null) {
            throw new IllegalArgumentException();
        }
        ColorConv colorConv = colorConvertParameter.getColorReplace();
        if (colorConv == null) {
            colorConv = ColorConv.NONE;
        }
        this.disableEvent.incrementAndGet();
        try {
            this.cmbColorReplace.setSelectedItem(colorConv);
            this.txtGray.setValue(Float.valueOf(colorConvertParameter.getGrayLevel()));
            this.txtOffsetR.setValue(colorConvertParameter.getOffsetR());
            this.txtOffsetG.setValue(colorConvertParameter.getOffsetG());
            this.txtOffsetB.setValue(colorConvertParameter.getOffsetB());
            this.txtOffsetA.setValue(colorConvertParameter.getOffsetA());
            this.txtFactorR.setValue(colorConvertParameter.getFactorR());
            this.txtFactorG.setValue(colorConvertParameter.getFactorG());
            this.txtFactorB.setValue(colorConvertParameter.getFactorB());
            this.txtFactorA.setValue(colorConvertParameter.getFactorA());
            this.txtGammaR.setValue(colorConvertParameter.getGammaR());
            this.txtGammaG.setValue(colorConvertParameter.getGammaG());
            this.txtGammaB.setValue(colorConvertParameter.getGammaB());
            this.txtGammaA.setValue(colorConvertParameter.getGammaA());
            this.txtHue.setValue(colorConvertParameter.getHue());
            this.txtSaturation.setValue(colorConvertParameter.getSaturation());
            this.txtBrightness.setValue(colorConvertParameter.getBrightness());
        }
        finally {
            this.disableEvent.decrementAndGet();
        }
        this.chachedParam = colorConvertParameter;
    }

    public ColorConvertParameter getColorConvertParameter() {
        if (this.chachedParam != null) {
            return this.chachedParam;
        }
        ColorConvertParameter colorConvertParameter = new ColorConvertParameter();
        colorConvertParameter.setColorReplace((ColorConv)this.cmbColorReplace.getSelectedItem());
        colorConvertParameter.setGrayLevel(((Number)this.txtGray.getValue()).floatValue());
        colorConvertParameter.setOffsetR(((Number)this.txtOffsetR.getValue()).intValue());
        colorConvertParameter.setOffsetG(((Number)this.txtOffsetG.getValue()).intValue());
        colorConvertParameter.setOffsetB(((Number)this.txtOffsetB.getValue()).intValue());
        colorConvertParameter.setOffsetA(((Number)this.txtOffsetA.getValue()).intValue());
        colorConvertParameter.setFactorR(((Number)this.txtFactorR.getValue()).floatValue());
        colorConvertParameter.setFactorG(((Number)this.txtFactorG.getValue()).floatValue());
        colorConvertParameter.setFactorB(((Number)this.txtFactorB.getValue()).floatValue());
        colorConvertParameter.setFactorA(((Number)this.txtFactorA.getValue()).floatValue());
        colorConvertParameter.setGammaR(((Number)this.txtGammaR.getValue()).floatValue());
        colorConvertParameter.setGammaG(((Number)this.txtGammaG.getValue()).floatValue());
        colorConvertParameter.setGammaB(((Number)this.txtGammaB.getValue()).floatValue());
        colorConvertParameter.setGammaA(((Number)this.txtGammaA.getValue()).floatValue());
        colorConvertParameter.setHue(((Number)this.txtHue.getValue()).floatValue());
        colorConvertParameter.setSaturation(((Number)this.txtSaturation.getValue()).floatValue());
        colorConvertParameter.setBrightness(((Number)this.txtBrightness.getValue()).floatValue());
        this.chachedParam = colorConvertParameter;
        return colorConvertParameter;
    }

    public ColorGroup getColorGroup() {
        return (ColorGroup)this.cmbColorGroup.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorGroup(ColorGroup colorGroup) {
        if (colorGroup == null) {
            colorGroup = ColorGroup.NA;
        }
        this.disableEvent.incrementAndGet();
        try {
            this.cmbColorGroup.setSelectedItem(colorGroup);
        }
        finally {
            this.disableEvent.decrementAndGet();
        }
    }

    public boolean isSyncColorGroup() {
        return this.chkColorGroupSync == null ? false : this.chkColorGroupSync.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncColorGroup(boolean bl) {
        if (this.chkColorGroupSync != null) {
            this.disableEvent.incrementAndGet();
            try {
                this.chkColorGroupSync.setSelected(bl);
            }
            finally {
                this.disableEvent.decrementAndGet();
            }
        }
    }
}

