/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.ColorGroup;

class ColorGroupsTableRow {
    private final String id;
    private final boolean enabled;
    private String localizedName;
    public static final ColorGroupsTableRow NA = new ColorGroupsTableRow("n/a", "", false);

    public ColorGroupsTableRow(String string, String string2) {
        this(string, string2, true);
    }

    public static ColorGroupsTableRow valueOf(ColorGroup colorGroup) {
        if (colorGroup == null || !colorGroup.isEnabled()) {
            return NA;
        }
        return new ColorGroupsTableRow(colorGroup.getId(), colorGroup.getLocalizedName(), true);
    }

    public ColorGroup convert() {
        if (!this.isEnabled()) {
            return ColorGroup.NA;
        }
        return new ColorGroup(this.getId(), this.getLocalizedName());
    }

    private ColorGroupsTableRow(String string, String string2, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = string.trim();
        this.localizedName = string2 == null || string2.trim().length() == 0 ? string : string2;
        this.enabled = bl;
    }

    public void setLocalizedName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.enabled) {
            throw new UnsupportedOperationException("unmodified object.");
        }
        this.localizedName = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ColorGroupsTableRow) {
            ColorGroupsTableRow colorGroupsTableRow = (ColorGroupsTableRow)object;
            return this.id.equals(colorGroupsTableRow.getId());
        }
        return false;
    }

    public static boolean equals(ColorGroupsTableRow colorGroupsTableRow, ColorGroupsTableRow colorGroupsTableRow2) {
        if (colorGroupsTableRow == colorGroupsTableRow2) {
            return true;
        }
        if (colorGroupsTableRow == null || colorGroupsTableRow2 == null) {
            return false;
        }
        return colorGroupsTableRow.equals(colorGroupsTableRow2);
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

