/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.ExportPartsSelectModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsTableModel
extends AbstractTableModelWithComboBoxModel<ExportPartsSelectModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames;
    private static final int[] columnWidths;
    private boolean enabled = true;

    ExportPartsTableModel() {
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        for (int i = 0; i < columnWidths.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ExportPartsSelectModel exportPartsSelectModel = (ExportPartsSelectModel)this.getRow(n);
        switch (n2) {
            case 0: {
                return exportPartsSelectModel.isSelected() && this.enabled;
            }
            case 1: {
                return exportPartsSelectModel.getPartsCategory().getLocalizedCategoryName();
            }
            case 2: {
                return exportPartsSelectModel.getPartsName();
            }
            case 3: {
                Timestamp timestamp = exportPartsSelectModel.getTimestamp();
                if (timestamp != null) {
                    return timestamp.toString();
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ExportPartsSelectModel exportPartsSelectModel = (ExportPartsSelectModel)this.getRow(n);
        switch (n2) {
            case 0: {
                exportPartsSelectModel.setSelected((Boolean)object);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return this.isEnabled();
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<ExportPartsSelectModel>(){

            @Override
            public int compare(ExportPartsSelectModel exportPartsSelectModel, ExportPartsSelectModel exportPartsSelectModel2) {
                int n = 0;
                Timestamp timestamp = exportPartsSelectModel.getTimestamp();
                Timestamp timestamp2 = exportPartsSelectModel2.getTimestamp();
                n = timestamp == null || timestamp2 == null ? (timestamp == null && timestamp2 == null ? 0 : (timestamp == null ? 1 : -1)) : timestamp2.compareTo(timestamp);
                if (n == 0) {
                    n = exportPartsSelectModel.compareTo(exportPartsSelectModel2);
                }
                return n;
            }
        });
        this.fireTableDataChanged();
    }

    public void selectAll() {
        for (ExportPartsSelectModel exportPartsSelectModel : this.elements) {
            exportPartsSelectModel.setSelected(true);
        }
        this.fireTableDataChanged();
    }

    public void deselectAll() {
        for (ExportPartsSelectModel exportPartsSelectModel : this.elements) {
            exportPartsSelectModel.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    public Map<PartsIdentifier, PartsSpec> getSelectedParts() {
        HashMap<PartsIdentifier, PartsSpec> hashMap = new HashMap<PartsIdentifier, PartsSpec>();
        for (ExportPartsSelectModel exportPartsSelectModel : this.elements) {
            if (!exportPartsSelectModel.isSelected() || !this.isEnabled()) continue;
            hashMap.put(exportPartsSelectModel.getPartsIdentifier(), exportPartsSelectModel.getPartsSpec());
        }
        return hashMap;
    }

    public Map<PartsSet, List<PartsIdentifier>> checkMissingPartsList(Collection<PartsSet> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        Map<PartsIdentifier, PartsSpec> map = this.getSelectedParts();
        HashMap<PartsSet, List<PartsIdentifier>> hashMap = new HashMap<PartsSet, List<PartsIdentifier>>();
        for (PartsSet partsSet : collection) {
            ArrayList<PartsIdentifier> arrayList = new ArrayList<PartsIdentifier>();
            for (PartsCategory partsCategory : partsSet.keySet()) {
                for (PartsIdentifier partsIdentifier : (List)partsSet.get(partsCategory)) {
                    if (map.containsKey(partsIdentifier)) continue;
                    arrayList.add(partsIdentifier);
                }
            }
            Collections.sort(arrayList);
            hashMap.put(partsSet, arrayList);
        }
        return hashMap;
    }

    public void selectByPartsSet(Collection<PartsSet> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        HashSet<PartsIdentifier> hashSet = new HashSet<PartsIdentifier>();
        for (PartsSet object : collection) {
            for (PartsCategory partsCategory : object.keySet()) {
                for (PartsIdentifier partsIdentifier : (List)object.get(partsCategory)) {
                    hashSet.add(partsIdentifier);
                }
            }
        }
        for (ExportPartsSelectModel exportPartsSelectModel : this.elements) {
            if (!hashSet.contains(exportPartsSelectModel.getPartsIdentifier())) continue;
            exportPartsSelectModel.setSelected(true);
        }
        this.fireTableDataChanged();
    }

    public int getSelectedCount() {
        int n = 0;
        for (ExportPartsSelectModel exportPartsSelectModel : this.elements) {
            if (!exportPartsSelectModel.isSelected() || !this.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireTableDataChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        columnNames = new String[]{properties.getProperty("parts.column.selected"), properties.getProperty("parts.column.category"), properties.getProperty("parts.column.name"), properties.getProperty("parts.column.timestamp")};
        columnWidths = new int[]{Integer.parseInt(properties.getProperty("parts.column.selected.width")), Integer.parseInt(properties.getProperty("parts.column.category.width")), Integer.parseInt(properties.getProperty("parts.column.name.width")), Integer.parseInt(properties.getProperty("parts.column.timestamp.width"))};
    }
}

