/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsImageCollectionParser;
import charactermanaj.ui.ButtonCellEditor;
import charactermanaj.ui.ButtonCellRender;
import charactermanaj.ui.InformationModel;
import charactermanaj.ui.InformationTableModel;
import charactermanaj.util.DesktopUtil;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class InformationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/informationdialog";
    private JTable informationTable;
    private InformationTableModel informationTableModel;

    public InformationDialog(JFrame jFrame, PartsSpecResolver partsSpecResolver, PartsSet partsSet) {
        super((Frame)jFrame, true);
        Object object;
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException("partsSpecResolver is null");
        }
        if (partsSet == null) {
            throw new IllegalArgumentException("partsSet is null");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InformationDialog.this.onClose();
            }
        });
        final Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(properties.getProperty("title"));
        this.informationTableModel = new InformationTableModel();
        PartsImageCollectionParser partsImageCollectionParser = new PartsImageCollectionParser(partsSpecResolver);
        partsImageCollectionParser.parse(partsSet, new PartsImageCollectionParser.PartsImageCollectionHandler(){

            public void detectImageSource(PartsIdentifier partsIdentifier, Layer layer, final ImageResource imageResource, ColorConvertParameter colorConvertParameter) {
                AbstractAction abstractAction = new AbstractAction(properties.getProperty("btn.edit")){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        InformationDialog.this.onOpen(imageResource);
                    }
                };
                URL uRL = imageResource.getURL();
                if (uRL != null && uRL.getProtocol().equals("file") && DesktopUtil.isSupported()) {
                    abstractAction.setEnabled(true);
                } else {
                    abstractAction.setEnabled(false);
                }
                InformationModel informationModel = new InformationModel(partsIdentifier, layer, imageResource, colorConvertParameter, abstractAction);
                InformationDialog.this.informationTableModel.addRow(informationModel);
            }
        });
        this.informationTableModel.sort();
        this.informationTable = new JTable(this.informationTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                int n3 = Math.max(component.getPreferredSize().width, tableColumn.getPreferredWidth());
                if (tableColumn.getPreferredWidth() != n3) {
                    tableColumn.setPreferredWidth(n3);
                }
                return component;
            }
        };
        this.informationTableModel.adjustColumnModel(this.informationTable.getColumnModel());
        this.informationTable.setAutoResizeMode(0);
        this.informationTable.setRowHeight(this.informationTable.getRowHeight() + 4);
        this.informationTable.setDefaultRenderer(JButton.class, new ButtonCellRender());
        this.informationTable.setDefaultEditor(JButton.class, new ButtonCellEditor());
        for (int i = 0; i < this.informationTable.getRowCount(); ++i) {
            for (int j = 0; j < this.informationTable.getColumnCount(); ++j) {
                object = this.informationTable.getCellRenderer(i, j);
                this.informationTable.prepareRenderer((TableCellRenderer)object, i, j);
            }
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction(properties.getProperty("popupmenu.copyPath")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                InformationDialog.this.onCopyFilePath();
            }
        });
        this.informationTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            private void evaluatePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(InformationDialog.this.informationTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new JScrollPane(this.informationTable), "Center");
        object = new AbstractAction(properties.getProperty("btnClose")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                InformationDialog.this.onClose();
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton((Action)object);
        jPanel.add((Component)jButton, gridBagConstraints);
        container.add((Component)jPanel, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeInformationDialog");
        actionMap.put("closeInformationDialog", (Action)object);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    protected void onClose() {
        this.dispose();
    }

    protected void onCopyFilePath() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int n : this.informationTable.getSelectedRows()) {
            InformationModel informationModel = (InformationModel)this.informationTableModel.getRow(n);
            printWriter.println(informationModel.getImageResourceName());
        }
        Object object = Toolkit.getDefaultToolkit();
        String string = stringWriter.toString();
        if (string.length() == 0) {
            ((Toolkit)object).beep();
            return;
        }
        StringSelection stringSelection = new StringSelection(stringWriter.toString());
        Clipboard clipboard = ((Toolkit)object).getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    protected void onOpen(ImageResource imageResource) {
        try {
            URL uRL = imageResource.getURL();
            if (uRL != null && uRL.getProtocol().equals("file")) {
                File file = new File(uRL.getPath());
                DesktopUtil.edit(file);
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }
}

