/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorCoordinator {
    private IdentityHashMap<ImageSelectPanel, ColorDialog> colorDialogMap = new IdentityHashMap();
    private PartsColorManager partsColorMrg;
    private ColorGroupCoordinator colorGroupCoordinator;

    public PartsColorCoordinator(PartsColorManager partsColorManager, ColorGroupCoordinator colorGroupCoordinator) {
        if (partsColorManager == null || colorGroupCoordinator == null) {
            throw new IllegalArgumentException();
        }
        this.partsColorMrg = partsColorManager;
        this.colorGroupCoordinator = colorGroupCoordinator;
    }

    public void register(final ImageSelectPanel imageSelectPanel, final ColorDialog colorDialog) {
        if (imageSelectPanel == null || colorDialog == null) {
            throw new IllegalArgumentException();
        }
        if (this.colorDialogMap.containsKey(imageSelectPanel)) {
            throw new IllegalArgumentException("already registered: " + imageSelectPanel);
        }
        this.colorDialogMap.put(imageSelectPanel, colorDialog);
        imageSelectPanel.addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

            public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
            }

            public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
            }

            public void onChange(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                PartsColorCoordinator.this.loadColorSettingToColorDialog(imageSelectPanel, colorDialog);
            }

            public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                PartsColorCoordinator.this.loadColorSettingToColorDialog(imageSelectPanel, colorDialog);
            }
        });
        colorDialog.addColorChangeListener(new ColorChangeListener(){

            public void onColorChange(ColorChangeEvent colorChangeEvent) {
                PartsColorCoordinator.this.saveColorSettingAll();
            }

            public void onColorGroupChange(ColorChangeEvent colorChangeEvent) {
                PartsColorCoordinator.this.saveColorSettingAll();
            }
        });
    }

    protected void loadColorSettingToColorDialog(ImageSelectPanel imageSelectPanel, ColorDialog colorDialog) {
        PartsIdentifier partsIdentifier = imageSelectPanel.getSelectedPartsIdentifier();
        if (partsIdentifier == null) {
            return;
        }
        colorDialog.setPartsIdentifier(partsIdentifier);
        PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            Layer layer = entry.getKey();
            ColorInfo colorInfo = entry.getValue();
            ColorGroup colorGroup = colorInfo.getColorGroup();
            if (colorGroup == null) {
                colorGroup = ColorGroup.NA;
            }
            colorDialog.setColorGroup(layer, colorGroup);
            boolean bl = colorInfo.isSyncColorGroup();
            colorDialog.setSyncColorGroup(layer, bl);
            ColorConvertParameter colorConvertParameter = colorInfo.getColorParameter();
            colorDialog.setColorConvertParameter(layer, colorConvertParameter);
            if (!bl) continue;
            this.colorGroupCoordinator.syncColorGroup(colorDialog.getPartsCategory(), layer, colorDialog);
        }
    }

    protected void saveColorSettingAll() {
        for (Map.Entry<ImageSelectPanel, ColorDialog> entry : this.colorDialogMap.entrySet()) {
            ImageSelectPanel imageSelectPanel = entry.getKey();
            ColorDialog colorDialog = entry.getValue();
            this.saveColorSettingFromColorDialog(imageSelectPanel, colorDialog);
        }
    }

    protected void saveColorSettingFromColorDialog(ImageSelectPanel imageSelectPanel, ColorDialog colorDialog) {
        PartsIdentifier partsIdentifier = imageSelectPanel.getSelectedPartsIdentifier();
        if (partsIdentifier == null) {
            return;
        }
        Map<Layer, ColorConvertParameter> map = colorDialog.getColorConvertParameters();
        PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, true);
        for (Map.Entry<Layer, ColorConvertParameter> entry : map.entrySet()) {
            Layer layer = entry.getKey();
            ColorConvertParameter colorConvertParameter = entry.getValue();
            ColorInfo colorInfo = new ColorInfo();
            ColorGroup colorGroup = colorDialog.getColorGroup(layer);
            colorInfo.setColorGroup(colorGroup);
            boolean bl = colorDialog.isSyncColorGroup(layer);
            colorInfo.setSyncColorGroup(bl);
            colorInfo.setColorParameter(colorConvertParameter);
            partsColorInfo.put(layer, colorInfo);
        }
        boolean bl = colorDialog.isApplyAll();
        this.partsColorMrg.setPartsColorInfo(partsIdentifier, partsColorInfo, bl);
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameterMap() {
        HashMap<Layer, ColorConvertParameter> hashMap = new HashMap<Layer, ColorConvertParameter>();
        for (ColorDialog colorDialog : this.colorDialogMap.values()) {
            for (Map.Entry<Layer, ColorConvertParameter> entry : colorDialog.getColorConvertParameters().entrySet()) {
                Layer layer = entry.getKey();
                ColorConvertParameter colorConvertParameter = entry.getValue();
                hashMap.put(layer, colorConvertParameter);
            }
        }
        return hashMap;
    }

    public void initColorDialog() {
        for (Map.Entry<ImageSelectPanel, ColorDialog> entry : this.colorDialogMap.entrySet()) {
            ImageSelectPanel imageSelectPanel = entry.getKey();
            ColorDialog colorDialog = entry.getValue();
            PartsIdentifier partsIdentifier = imageSelectPanel.getSelectedPartsIdentifier();
            colorDialog.setPartsIdentifier(partsIdentifier);
            if (partsIdentifier == null) continue;
            PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
            for (Map.Entry<Layer, ColorInfo> entry2 : partsColorInfo.entrySet()) {
                Layer layer = entry2.getKey();
                ColorInfo colorInfo = entry2.getValue();
                colorDialog.setColorGroup(layer, colorInfo.getColorGroup());
                colorDialog.setSyncColorGroup(layer, colorInfo.isSyncColorGroup());
                colorDialog.setColorConvertParameter(layer, colorInfo.getColorParameter());
            }
        }
    }
}

