/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LocalizedResourcePropertyLoader
extends ResourceLoader {
    private HashMap<ResourceLoader.ResourceNames, Properties> propCache = new HashMap();
    private static final LocalizedResourcePropertyLoader inst = new LocalizedResourcePropertyLoader();

    private LocalizedResourcePropertyLoader() {
    }

    public static LocalizedResourcePropertyLoader getInstance() {
        return inst;
    }

    public Properties getLocalizedProperties(String string) {
        return this.getLocalizedProperties(string, null);
    }

    public Properties getLocalizedProperties(String string, Locale locale) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        String[] stringArray = new String[]{string + ".xml", string + "_" + string2 + ".xml", string + "_" + string2 + "_" + string3 + ".xml", string + "_" + string2 + "_" + string3 + "_" + string4 + ".xml"};
        return this.getProperties(new ResourceLoader.ResourceNames(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(ResourceLoader.ResourceNames resourceNames) {
        Properties properties;
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        HashMap<ResourceLoader.ResourceNames, Properties> hashMap = this.propCache;
        synchronized (hashMap) {
            properties = this.propCache.get(resourceNames);
            if (properties == null) {
                properties = this.loadProperties(resourceNames);
                this.propCache.put(resourceNames, properties);
            }
        }
        if (properties == null) {
            throw new RuntimeException("missing resource: " + resourceNames);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(ResourceLoader.ResourceNames resourceNames) {
        if (resourceNames == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader classLoader = this.getClassLoader();
        boolean bl = false;
        Properties properties = new Properties();
        for (String string : resourceNames) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            Properties properties2 = new Properties();
            try {
                InputStream inputStream = uRL.openStream();
                try {
                    properties2.loadFromXML(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("resource loading error." + uRL, exception);
            }
            bl = true;
            properties.putAll((Map<?, ?>)properties2);
        }
        if (bl) {
            return properties;
        }
        return null;
    }
}

