package charactermanaj.ui;

import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JMenuItem;

import charactermanaj.Main;

public class MenuData extends AbstractCollection<MenuData> {
	
	private String name;
	
	private String text;
	
	private Character mnemonic;
	
	private String mnemonicDisp;
	
	private boolean ignoreMacOSX;
	
	private ActionListener actionListener;
	
	private ArrayList<MenuData> children = new ArrayList<MenuData>();

	public MenuData() {
		this(null, null, null, false, null);
	}
	
	public MenuData(String text, Character mnemonic, String mnemonicDisp, boolean ignoreMacOSX, ActionListener actionListener) {
		this.text = text;
		this.mnemonic = mnemonic;
		this.mnemonicDisp = mnemonicDisp;
		this.ignoreMacOSX = ignoreMacOSX;
		this.actionListener = actionListener;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Character getMnemonic() {
		return mnemonic;
	}

	public void setMnemonic(Character mnemonic) {
		this.mnemonic = mnemonic;
	}
	
	public String getMnemonicDisp() {
		return mnemonicDisp;
	}
	
	public void setMnimonicDisp(String mnemonicDisp) {
		this.mnemonicDisp = mnemonicDisp;
	}

	public boolean isIgnoreMacOSX() {
		return ignoreMacOSX;
	}

	public void setIgnoreMacOSX(boolean ignoreMacOSX) {
		this.ignoreMacOSX = ignoreMacOSX;
	}
	
	public ActionListener getActionListener() {
		return actionListener;
	}
	
	public void setActionListener(ActionListener actionListener) {
		this.actionListener = actionListener;
	}
	
	@Override
	public int size() {
		return children.size();
	}
	
	@Override
	public Iterator<MenuData> iterator() {
		return children.iterator();
	}
	
	@Override
	public boolean add(MenuData o) {
		return children.add(o);
	}

	public boolean makeMenu(JMenuItem menu) {
		if (! isIgnoreMacOSX() || ! Main.isMacOSX()) {
			if (Main.isMacOSX()) {
				menu.setText(getText());
			} else {
				Character mnemonic = getMnemonic();
				String mnemonicDisp =getMnemonicDisp();
				if (mnemonicDisp == null) {
					mnemonicDisp = "";
				}
				menu.setName(getName());
				menu.setText(getText() + mnemonicDisp);
				if (mnemonic != null) {
					menu.setMnemonic(mnemonic);
				}
			}
			if (actionListener != null) {
				menu.addActionListener(actionListener);
			}
			return true;
		}
		return false;
	}
	
}
