/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ImportTypeSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importTypeSelectPanel";
    private ImportWizardDialog parent;
    private SamplePicturePanel samplePicturePanel;
    private JTextField txtCharacterId;
    private JTextField txtCharacterRev;
    private JTextField txtCharacterName;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkPartsImages;
    private JCheckBox chkPresets;
    private JCheckBox chkSampleImage;
    private JCheckBox chkAddDescription;
    private String additionalDescription;

    public ImportTypeSelectPanel() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        GridBagLayout basicPanelLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(basicPanelLayout);
        JPanel contentsSpecPanel = new JPanel();
        contentsSpecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.contentsSpec"))));
        BoxLayout contentsSpecPanelLayout = new BoxLayout(contentsSpecPanel, 3);
        contentsSpecPanel.setLayout(contentsSpecPanelLayout);
        this.chkPartsImages = new JCheckBox(strings.getProperty("basic.chk.partsImages"));
        this.chkPresets = new JCheckBox(strings.getProperty("basic.chk.presets"));
        this.chkSampleImage = new JCheckBox(strings.getProperty("basic.chk.samplePicture"));
        contentsSpecPanel.add(this.chkPartsImages);
        contentsSpecPanel.add(this.chkPresets);
        contentsSpecPanel.add(this.chkSampleImage);
        JPanel archiveInfoPanel = new JPanel();
        archiveInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.archiveInfo"))));
        Dimension archiveInfoPanelMinSize = new Dimension(300, 200);
        archiveInfoPanel.setMinimumSize(archiveInfoPanelMinSize);
        archiveInfoPanel.setPreferredSize(archiveInfoPanelMinSize);
        GridBagLayout commentPanelLayout = new GridBagLayout();
        archiveInfoPanel.setLayout(commentPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileId"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterId = new JTextField();
        this.txtCharacterId.setEditable(false);
        this.txtCharacterId.setEnabled(false);
        archiveInfoPanel.add((Component)this.txtCharacterId, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileRev"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterRev = new JTextField();
        this.txtCharacterRev.setEditable(false);
        this.txtCharacterRev.setEnabled(false);
        archiveInfoPanel.add((Component)this.txtCharacterRev, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("basic.profileName"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.txtCharacterName = new JTextField();
        archiveInfoPanel.add((Component)this.txtCharacterName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("author"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.txtAuthor = new JTextField();
        archiveInfoPanel.add((Component)this.txtAuthor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        archiveInfoPanel.add((Component)new JLabel(strings.getProperty("description"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 5;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.txtDescription = new JTextArea();
        archiveInfoPanel.add((Component)new JScrollPane(this.txtDescription), gbc);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.chkAddDescription = new JCheckBox(strings.getProperty("appendDescription"));
        archiveInfoPanel.add((Component)this.chkAddDescription, gbc);
        this.samplePicturePanel = new SamplePicturePanel();
        JScrollPane samplePicturePanelSP = new JScrollPane(this.samplePicturePanel);
        samplePicturePanelSP.setBorder(null);
        JPanel samplePictureTitledPanel = new JPanel(new BorderLayout());
        samplePictureTitledPanel.add((Component)samplePicturePanelSP, "Center");
        samplePictureTitledPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.sampleImage"))));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)contentsSpecPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)archiveInfoPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)samplePictureTitledPanel, gbc);
        ActionListener modListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportTypeSelectPanel.this.fireChangeEvent();
            }
        };
        this.chkPartsImages.addActionListener(modListener);
        this.chkPresets.addActionListener(modListener);
        this.chkSampleImage.addActionListener(modListener);
        this.chkAddDescription.addActionListener(modListener);
    }

    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        boolean hasContents;
        String readme;
        this.parent = parent;
        if (previousPanel == parent.importPartsSelectPanel) {
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        CharacterData current = parent.current;
        CharacterData cd = parent.importModel.getCharacterData();
        boolean updatable = current != null && current.isValid();
        boolean creatable = current == null && cd != null && cd.isValid();
        this.txtCharacterName.setEnabled(current == null);
        this.txtCharacterName.setEditable(current == null);
        this.txtAuthor.setEditable(current == null);
        this.txtAuthor.setEnabled(current == null);
        boolean matchID = false;
        boolean matchREV = false;
        if (cd != null && cd.isValid()) {
            this.txtCharacterId.setText(cd.getId());
            this.txtCharacterRev.setText(cd.getRev());
            this.txtCharacterName.setText(cd.getName());
            if (current != null) {
                boolean bl = current.getId() == null ? cd.getId() == null : (matchID = current.getId().equals(cd.getId()));
                matchREV = current.getRev() == null ? cd.getRev() == null : current.getRev().equals(cd.getRev());
            } else {
                matchID = true;
                matchREV = true;
            }
            AppConfig appConfig = AppConfig.getInstance();
            Color invalidBgColor = appConfig.getInvalidBgColor();
            this.txtCharacterId.setBackground(matchID ? this.getBackground() : invalidBgColor);
            this.txtCharacterRev.setBackground(matchREV ? this.getBackground() : invalidBgColor);
            this.txtAuthor.setText(cd.getAuthor());
            readme = cd.getDescription();
        } else {
            this.txtCharacterId.setText("");
            this.txtCharacterRev.setText("");
            this.txtCharacterName.setText("");
            this.txtAuthor.setText("");
            readme = parent.importModel.getReadme();
        }
        boolean existsReadme = readme != null && readme.trim().length() > 0;
        this.additionalDescription = existsReadme ? readme : "";
        this.txtDescription.setText(this.additionalDescription);
        this.chkAddDescription.setEnabled((updatable || creatable) && existsReadme);
        this.chkAddDescription.setSelected((updatable || creatable) && existsReadme);
        boolean hasPresetOrFavorites = cd == null ? false : !cd.getPartsSets().isEmpty();
        this.chkPresets.setEnabled(hasPresetOrFavorites);
        this.chkPresets.setSelected(hasPresetOrFavorites);
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMap = parent.importModel.getPartsImageContents();
        boolean hasParts = !partsImageContentsMap.isEmpty();
        this.chkPartsImages.setEnabled(hasParts);
        this.chkPartsImages.setSelected(hasParts);
        BufferedImage samplePicture = parent.importModel.getSamplePicture();
        if (samplePicture != null && (updatable || creatable)) {
            this.samplePicturePanel.setSamplePicture(samplePicture);
            this.chkSampleImage.setEnabled(true);
            this.chkSampleImage.setSelected(current == null);
        } else {
            this.samplePicturePanel.setSamplePicture(samplePicture);
            this.chkSampleImage.setEnabled(false);
            this.chkSampleImage.setSelected(false);
        }
        boolean bl = hasContents = hasParts || hasPresetOrFavorites || current == null && cd != null && cd.isValid();
        if (!hasContents) {
            JOptionPane.showMessageDialog(this, strings.getProperty("noContents"));
        } else if (cd == null) {
            JOptionPane.showMessageDialog(this, strings.getProperty("notFormalArchive"));
        } else if (!matchID) {
            String fmt = strings.getProperty("unmatchedProfileId");
            String msg = MessageFormat.format(fmt, cd.getId() == null ? "" : cd.getId());
            JOptionPane.showMessageDialog(this, msg);
        } else if (!matchREV) {
            String fmt = strings.getProperty("unmatchedProfileRev");
            String msg = MessageFormat.format(fmt, cd.getRev() == null ? "" : cd.getRev());
            JOptionPane.showMessageDialog(this, msg);
        }
    }

    public boolean isImportPreset() {
        return this.chkPresets.isSelected();
    }

    public boolean isImportPartsImages() {
        return this.chkPartsImages.isSelected();
    }

    public boolean isImportSampleImage() {
        return this.chkSampleImage.isSelected();
    }

    public boolean isAddDescription() {
        return this.chkAddDescription.isSelected();
    }

    public String getAdditionalDescription() {
        return this.txtDescription.getText();
    }

    public String getCharacterName() {
        return this.txtCharacterName.getText();
    }

    public String getAuthor() {
        return this.txtAuthor.getText();
    }

    public boolean isReadyPrevious() {
        return true;
    }

    public String doPrevious() {
        return "fileSelectPanel";
    }

    public boolean isReadyNext() {
        return this.isImportPartsImages() || this.isImportPreset();
    }

    public boolean isReadyFinish() {
        return !this.isImportPartsImages() && !this.isImportPreset() && (this.parent != null && this.parent.current == null || this.isImportSampleImage());
    }

    public String doNext() {
        return "importPartsSelectPanel";
    }
}

