/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.util.XMLUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomLayerOrderXMLReader {
    private CharacterData cd;

    public CustomLayerOrderXMLReader(CharacterData cd) {
        if (cd == null) {
            throw new NullPointerException("categories is required.");
        }
        this.cd = cd;
    }

    public Map<String, List<CustomLayerOrder>> read(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, List<CustomLayerOrder>> map = new TreeMap<String, List<CustomLayerOrder>>();
        Document doc = XMLUtilities.loadDocument(is);
        String lang = Locale.getDefault().getLanguage();
        try {
            Element docElm = doc.getDocumentElement();
            if (!"custom-layer-orders".equals(docElm.getNodeName())) {
                throw new IOException("Invalid Format.");
            }
            String ns = docElm.getNamespaceURI();
            if (ns == null || !ns.startsWith("http://charactermanaj.osdn.jp/schema/customlayerorder.xsd")) {
                throw new IOException("unsupported xml format");
            }
            String docVersion = docElm.getAttribute("version").trim();
            if (!"1.0".equals(docVersion)) {
                throw new IOException("unsupported version: " + docVersion);
            }
            for (Element elmPattern : XMLUtilities.getChildElements(docElm, "pattern")) {
                String patternName = elmPattern.getAttribute("name");
                for (Element elmLocalizedName : XMLUtilities.getChildElements(elmPattern, "localized-name")) {
                    String localizedLang = elmLocalizedName.getAttribute("lang");
                    String localizedName = elmLocalizedName.getAttribute("name");
                    if (!lang.equals(localizedLang)) continue;
                    patternName = localizedName;
                }
                ArrayList<CustomLayerOrder> orders = new ArrayList<CustomLayerOrder>();
                for (Element elmMapping : XMLUtilities.getChildElements(elmPattern, "mapping")) {
                    Layer layer;
                    String categoryId = elmMapping.getAttribute("category");
                    String layerId = elmMapping.getAttribute("layer");
                    int layerOrder = Integer.parseInt(elmMapping.getAttribute("order"));
                    PartsCategory category = this.cd.getPartsCategory(categoryId);
                    if (category == null || (layer = category.getLayer(layerId)) == null) continue;
                    CustomLayerOrder order = new CustomLayerOrder();
                    order.setCategory(category);
                    order.setLayer(layer);
                    order.setLayerOrder(layerOrder);
                    orders.add(order);
                }
                map.put(patternName, orders);
            }
        }
        catch (RuntimeException ex) {
            IOException ex2 = new IOException("CustomLayerOrderXML invalid format.");
            ex2.initCause(ex);
            throw ex2;
        }
        return map;
    }
}

