/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.InformationModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.table.TableColumnModel;

class InformationTableModel
extends AbstractTableModelWithComboBoxModel<InformationModel> {
    private static final ColumnDef[] COLUMNS = ColumnDef.values();
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[COLUMNS.length];
    private static final int[] columnWidths = new int[COLUMNS.length];

    InformationTableModel() {
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < COLUMNS.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(columnWidths[idx]);
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNS[columnIndex].getType();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InformationModel information = (InformationModel)this.getRow(rowIndex);
        return COLUMNS[columnIndex].getValue(information);
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (JButton.class.equals(COLUMNS[columnIndex].getType())) {
            InformationModel information = (InformationModel)this.getRow(rowIndex);
            return information.getButton().isEnabled();
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/informationdialog");
        for (int idx = 0; idx < COLUMNS.length; ++idx) {
            InformationTableModel.columnNames[idx] = strings.getProperty(COLUMNS[idx].getResource());
            InformationTableModel.columnWidths[idx] = Integer.parseInt(strings.getProperty(COLUMNS[idx].getResource() + ".width"));
        }
    }

    private static enum ColumnDef {
        PARTS_NAME("column.partsName", (Class)String.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getPartsName();
            }
        }
        ,
        CATEGORY("column.categoryName", (Class)String.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getCategoryName();
            }
        }
        ,
        LAYER("column.layerName", (Class)String.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getLayerName();
            }
        }
        ,
        DEFAULT_LAYER_ORDER("column.defaultLayerOrder", (Class)Integer.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getDefaultLayerOrder();
            }
        }
        ,
        ACTUAL_LAYER_ORDER("column.layerOrder", (Class)Integer.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getLayerOrder();
            }
        }
        ,
        IMAGE_SIZE("column.imagesize", (Class)String.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getImageSizeStr();
            }
        }
        ,
        COLOR_TYPE("column.colortype", (Class)String.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getColorTypeStr();
            }
        }
        ,
        EDIT_BUTTON("column.editbtn", (Class)JButton.class){

            @Override
            public Object getValue(InformationModel information) {
                return information.getButton();
            }
        };

        private final String resource;
        private final Class<?> cls;

        private ColumnDef(String resource, Class<?> cls) {
            this.resource = resource;
            this.cls = cls;
        }

        public String getResource() {
            return this.resource;
        }

        public Class<?> getType() {
            return this.cls;
        }

        public abstract Object getValue(InformationModel var1);
    }
}

