/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.Layer;
import charactermanaj.model.io.PartsImageCollectionParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CustomLayerPatternMgr
implements PartsImageCollectionParser.LayerOrderMapper {
    private final Map<String, List<CustomLayerOrder>> customLayerPatternMap = new TreeMap<String, List<CustomLayerOrder>>();
    private final Set<String> activeCustomLayers = new HashSet<String>();
    private Map<Layer, Integer> customLayerOrderMap;

    private void initCustomLayerOrder() {
        this.customLayerOrderMap = new HashMap<Layer, Integer>();
        for (String patternName : this.activeCustomLayers) {
            this.initCustomLayerOrder(this.customLayerPatternMap.get(patternName));
        }
    }

    private void initCustomLayerOrder(List<CustomLayerOrder> customLayerOrderList) {
        if (customLayerOrderList != null) {
            for (CustomLayerOrder customLayerOrder : customLayerOrderList) {
                Layer layer = customLayerOrder.getLayer();
                int layerOrder = customLayerOrder.getLayerOrder();
                this.customLayerOrderMap.put(layer, layerOrder);
            }
        }
    }

    public void applyCustomLayerOrder(List<CustomLayerOrder> customLayerOrderList) {
        this.customLayerOrderMap = new HashMap<Layer, Integer>();
        this.initCustomLayerOrder(customLayerOrderList);
    }

    @Override
    public int getLayerOrder(Layer layer) {
        Integer layerOrder;
        if (this.customLayerOrderMap == null) {
            this.initCustomLayerOrder();
        }
        if ((layerOrder = this.customLayerOrderMap.get(layer)) == null) {
            layerOrder = layer.getOrder();
        }
        return layerOrder;
    }

    public Map<String, List<CustomLayerOrder>> getMap() {
        return this.customLayerPatternMap;
    }

    public void setMap(Map<String, List<CustomLayerOrder>> map) {
        this.customLayerPatternMap.clear();
        this.customLayerPatternMap.putAll(map);
        this.activeCustomLayers.retainAll(this.customLayerPatternMap.keySet());
        this.initCustomLayerOrder();
    }

    public boolean isSelected(String name) {
        return this.activeCustomLayers.contains(name);
    }

    public void setSelected(String name, boolean selected) {
        if (this.customLayerPatternMap.containsKey(name)) {
            if (selected) {
                this.unselectConflict(name);
                this.activeCustomLayers.add(name);
            } else {
                this.activeCustomLayers.remove(name);
            }
            this.initCustomLayerOrder();
        }
    }

    private void unselectConflict(String name) {
        HashSet<Layer> targetLayers = new HashSet<Layer>();
        List<CustomLayerOrder> targetLayerOrders = this.customLayerPatternMap.get(name);
        if (targetLayerOrders != null) {
            for (CustomLayerOrder layerOrder : targetLayerOrders) {
                targetLayers.add(layerOrder.getLayer());
            }
        }
        ArrayList<String> conflictPatterns = new ArrayList<String>();
        block1: for (String patternName : this.activeCustomLayers) {
            List<CustomLayerOrder> layerOrders;
            if (patternName.equals(name) || (layerOrders = this.customLayerPatternMap.get(patternName)) == null) continue;
            for (CustomLayerOrder layerOrder : layerOrders) {
                Layer layer = layerOrder.getLayer();
                if (!targetLayers.contains(layer)) continue;
                conflictPatterns.add(patternName);
                continue block1;
            }
        }
        this.activeCustomLayers.removeAll(conflictPatterns);
    }

    public List<CustomLayerOrder> getMergedCustomLayerOrderList() {
        ArrayList<CustomLayerOrder> mergedList = new ArrayList<CustomLayerOrder>();
        for (String patternName : this.activeCustomLayers) {
            List<CustomLayerOrder> list = this.customLayerPatternMap.get(patternName);
            if (list == null) continue;
            for (CustomLayerOrder layerOrder : list) {
                if (mergedList.contains(layerOrder)) continue;
                mergedList.add(layerOrder);
            }
        }
        return mergedList;
    }
}

