/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;

final class ImageBuildPartsInfo
implements Comparable<ImageBuildPartsInfo> {
    private int order;
    private int layerOrder;
    private Layer layer;
    private ImageResource imageResource;
    private ColorConvertParameter colorParam;

    public ImageBuildPartsInfo(int order, Layer layer, int layerOrder, ImageResource imageResource, ColorConvertParameter colorParam) {
        this.order = order;
        this.layer = layer;
        this.layerOrder = layerOrder;
        this.imageResource = imageResource;
        this.colorParam = colorParam;
    }

    public int hashCode() {
        return this.order ^ this.layer.hashCode() ^ this.imageResource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ImageBuildPartsInfo) {
            ImageBuildPartsInfo o = (ImageBuildPartsInfo)obj;
            return this.order == o.order && this.layer.equals(o.layer) && this.imageResource.equals(o.imageResource) && this.colorParam.equals(o.colorParam);
        }
        return false;
    }

    @Override
    public int compareTo(ImageBuildPartsInfo o) {
        int ret = this.layerOrder - o.layerOrder;
        if (ret == 0) {
            ret = this.layer.compareTo(o.layer);
        }
        if (ret == 0) {
            ret = this.order - o.order;
        }
        if (ret == 0) {
            ret = this.imageResource.compareTo(o.imageResource);
        }
        return ret;
    }

    public int getOrder() {
        return this.order;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public int getLayerOrder() {
        return this.layerOrder;
    }

    public ColorConvertParameter getColorParam() {
        return this.colorParam;
    }

    public ImageResource getFile() {
        return this.imageResource;
    }
}

