/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportPartsImageSet;
import charactermanaj.ui.ImportPartsModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.TableColumnModel;

class ImportPartsTableModel
extends AbstractTableModelWithComboBoxModel<ImportPartsModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    public static final int COLUMN_LASTMODIFIED = 5;
    public static final int COLUMN_ALPHA = 4;
    public static final int COLUMN_SIZE = 3;
    private Set<PartsIdentifier> currentProfilePartsIdentifiers;

    ImportPartsTableModel() {
    }

    public void initModel(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents, PartsManageData partsManageData, CharacterData currentProfile) {
        ImportPartsImageSet partsImageSet;
        this.clear();
        if (partsImageContents == null || partsManageData == null) {
            return;
        }
        HashSet<PartsIdentifier> currentProfilePartsIdentifiers = new HashSet<PartsIdentifier>();
        if (currentProfile != null) {
            for (PartsCategory partsCategory : currentProfile.getPartsCategories()) {
                currentProfilePartsIdentifiers.addAll(currentProfile.getPartsSpecMap(partsCategory).keySet());
            }
        }
        this.currentProfilePartsIdentifiers = Collections.unmodifiableSet(currentProfilePartsIdentifiers);
        HashMap<String, ImportPartsImageSet> partsImageSets = new HashMap<String, ImportPartsImageSet>();
        for (AbstractCharacterDataArchiveFile.PartsImageContent content : partsImageContents) {
            String partsName = content.getPartsName();
            partsImageSet = (ImportPartsImageSet)partsImageSets.get(partsName);
            if (partsImageSet == null) {
                partsImageSet = new ImportPartsImageSet(partsName);
                partsImageSets.put(partsName, partsImageSet);
            }
            partsImageSet.add(content);
        }
        ArrayList arrayList = new ArrayList(partsImageSets.keySet());
        Collections.sort(arrayList);
        for (String partsName : arrayList) {
            partsImageSet = (ImportPartsImageSet)partsImageSets.get(partsName);
            int numOfLink = partsImageSet.getPartsCategories().size();
            for (PartsCategory partsCategory : partsImageSet.getPartsCategories()) {
                PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsName, partsCategory.getCategoryId());
                String localizedPartsName = partsManageData.getLocalizedName(partsKey);
                if (localizedPartsName == null || localizedPartsName.length() == 0) {
                    localizedPartsName = partsName;
                }
                PartsAuthorInfo partsAuthorInfo = partsManageData.getPartsAuthorInfo(partsKey);
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersion(partsKey);
                PartsIdentifier partsIdentifier = new PartsIdentifier(partsCategory, partsName, localizedPartsName);
                PartsSpec partsSpec = currentProfile != null ? currentProfile.getPartsSpec(partsIdentifier) : null;
                ImportPartsModel rowModel = new ImportPartsModel(partsIdentifier, partsAuthorInfo, versionInfo, partsSpec, partsImageSet, numOfLink);
                this.addRow(rowModel);
            }
        }
        for (ImportPartsModel rowModel : this.elements) {
            double version;
            double versionAtCurrent;
            Long lastModifiedAtCurrent = rowModel.getLastModifiedAtCurrentProfile();
            if (lastModifiedAtCurrent == null) {
                lastModifiedAtCurrent = 0L;
            }
            ImportPartsImageSet partsImageSet2 = rowModel.getImageSet();
            if (lastModifiedAtCurrent < partsImageSet2.lastModified()) {
                partsImageSet2.setChecked(true);
            }
            if (!((versionAtCurrent = rowModel.getVersionAtCurrent()) < (version = rowModel.getVersion()))) continue;
            partsImageSet2.setChecked(true);
        }
        this.sort();
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getSelectedPartsImageContents() {
        IdentityHashMap<ImportPartsImageSet, ImportPartsImageSet> partsImageSets = new IdentityHashMap<ImportPartsImageSet, ImportPartsImageSet>();
        for (ImportPartsModel rowModel : this.elements) {
            ImportPartsImageSet partsImageSet = rowModel.getImageSet();
            if (!partsImageSet.isChecked()) continue;
            partsImageSets.put(partsImageSet, partsImageSet);
        }
        ArrayList<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents = new ArrayList<AbstractCharacterDataArchiveFile.PartsImageContent>();
        for (ImportPartsImageSet partsImageSet : partsImageSets.values()) {
            partsImageContents.addAll(partsImageSet);
        }
        return partsImageContents;
    }

    public Collection<PartsIdentifier> getSelectedPartsIdentifiers() {
        HashSet<PartsIdentifier> partsIdentifiers = new HashSet<PartsIdentifier>();
        for (ImportPartsModel rowModel : this.elements) {
            if (!rowModel.isChecked()) continue;
            partsIdentifiers.add(rowModel.getPartsIdentifier());
        }
        return partsIdentifiers;
    }

    public Collection<PartsIdentifier> getCurrentProfilePartsIdentifers() {
        return this.currentProfilePartsIdentifiers;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ImportPartsModel rowModel = (ImportPartsModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.isChecked();
            }
            case 1: {
                return rowModel.getPartsName();
            }
            case 2: {
                return rowModel.getPartsCategory().getLocalizedCategoryName();
            }
            case 3: {
                return rowModel.getWidth() + "x" + rowModel.getHeight() + (rowModel.isUnmatchedSize() ? "*" : "");
            }
            case 4: {
                return rowModel.isAlphaColor();
            }
            case 5: {
                long lastModified = rowModel.getLastModified();
                if (lastModified > 0L) {
                    return new Timestamp(lastModified).toString();
                }
                return "";
            }
            case 6: {
                Long lastModifiedAtCur = rowModel.getLastModifiedAtCurrentProfile();
                if (lastModifiedAtCur != null && lastModifiedAtCur > 0L) {
                    return new Timestamp(lastModifiedAtCur).toString();
                }
                return "";
            }
            case 7: {
                return rowModel.getAuthor();
            }
            case 8: {
                return rowModel.getAuthorAtCurrent();
            }
            case 9: {
                double version = rowModel.getVersion();
                if (version > 0.0) {
                    return Double.toString(version);
                }
                return "";
            }
            case 10: {
                double versionAtCurrent = rowModel.getVersionAtCurrent();
                if (versionAtCurrent > 0.0) {
                    return Double.toString(versionAtCurrent);
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ImportPartsModel rowModel = (ImportPartsModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                rowModel.setChecked((Boolean)aValue);
                break;
            }
            default: {
                return;
            }
        }
        if (rowModel.getNumOfLink() > 1) {
            this.fireTableDataChanged();
        } else {
            this.fireListUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        int mx = columnModel.getColumnCount();
        for (int idx = 0; idx < mx; ++idx) {
            columnModel.getColumn(idx).setWidth(COLUMN_WIDTHS[idx]);
        }
    }

    public void selectAll() {
        boolean modified = false;
        for (ImportPartsModel rowModel : this.elements) {
            if (rowModel.isChecked()) continue;
            rowModel.setChecked(true);
            modified = true;
        }
        if (modified) {
            this.fireTableDataChanged();
        }
    }

    public void deselectAll() {
        boolean modified = false;
        for (ImportPartsModel rowModel : this.elements) {
            if (!rowModel.isChecked()) continue;
            rowModel.setChecked(false);
            modified = true;
        }
        if (modified) {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<ImportPartsModel>(){

            @Override
            public int compare(ImportPartsModel o1, ImportPartsModel o2) {
                int ret = (o1.isChecked() ? 0 : 1) - (o2.isChecked() ? 0 : 1);
                if (ret == 0) {
                    ret = o1.getPartsIdentifier().compareTo(o2.getPartsIdentifier());
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<ImportPartsModel>(){

            @Override
            public int compare(ImportPartsModel o1, ImportPartsModel o2) {
                long ret = (o1.isChecked() ? 0 : 1) - (o2.isChecked() ? 0 : 1);
                if (ret == 0L) {
                    Long tm1 = o1.getLastModifiedAtCurrentProfile();
                    Long tm2 = o2.getLastModifiedAtCurrentProfile();
                    long lastModified1 = Math.max(o1.getLastModified(), tm1 == null ? 0L : tm1);
                    long lastModified2 = Math.max(o2.getLastModified(), tm2 == null ? 0L : tm2);
                    ret = lastModified1 - lastModified2;
                }
                if (ret == 0L) {
                    ret = o1.getPartsIdentifier().compareTo(o2.getPartsIdentifier());
                }
                return ret == 0L ? 0 : (ret > 0L ? 1 : -1);
            }
        });
        this.fireTableDataChanged();
    }

    public void selectByPartsIdentifiers(Collection<PartsIdentifier> partsIdentifiers) {
        boolean modified = false;
        if (partsIdentifiers != null) {
            for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                for (ImportPartsModel rowModel : this.elements) {
                    if (!rowModel.getPartsIdentifier().equals(partsIdentifier) || rowModel.isChecked()) continue;
                    rowModel.setChecked(true);
                    modified = true;
                }
            }
        }
        if (modified) {
            this.fireTableDataChanged();
        }
    }

    public void setCheck(int[] selRows, boolean checked) {
        if (selRows == null || selRows.length == 0) {
            return;
        }
        Arrays.sort(selRows);
        for (int selRow : selRows) {
            ImportPartsModel rowModel = (ImportPartsModel)this.getRow(selRow);
            rowModel.setChecked(checked);
        }
        this.fireTableRowsUpdated(selRows[0], selRows[selRows.length - 1]);
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        COLUMN_NAMES = new String[]{strings.getProperty("parts.column.check"), strings.getProperty("parts.column.partsname"), strings.getProperty("parts.column.category"), strings.getProperty("parts.column.imagesize"), strings.getProperty("parts.column.alpha"), strings.getProperty("parts.column.lastmodified"), strings.getProperty("parts.column.org-lastmodified"), strings.getProperty("parts.column.author"), strings.getProperty("parts.column.org-author"), strings.getProperty("parts.column.version"), strings.getProperty("parts.column.org-version")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(strings.getProperty("parts.column.check.size")), Integer.parseInt(strings.getProperty("parts.column.partsname.size")), Integer.parseInt(strings.getProperty("parts.column.category.size")), Integer.parseInt(strings.getProperty("parts.column.imagesize.size")), Integer.parseInt(strings.getProperty("parts.column.alpha.size")), Integer.parseInt(strings.getProperty("parts.column.lastmodified.size")), Integer.parseInt(strings.getProperty("parts.column.org-lastmodified.size")), Integer.parseInt(strings.getProperty("parts.column.author.size")), Integer.parseInt(strings.getProperty("parts.column.org-author.size")), Integer.parseInt(strings.getProperty("parts.column.version.size")), Integer.parseInt(strings.getProperty("parts.column.org-version.size"))};
    }
}

