/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import javax.swing.AbstractAction;
import javax.swing.JButton;

class InformationModel
implements Comparable<InformationModel> {
    private PartsIdentifier partsIdentifier;
    private Layer layer;
    private int layerOrder;
    private ImageResource imageResource;
    private JButton btnOpen;
    private PNGFileImageHeader pngHeader;

    public InformationModel(PartsIdentifier partsIdentifier, Layer layer, int layerOrder, ImageResource imageResource, ColorConvertParameter colorConvertParameter, PNGFileImageHeader pngHeader, AbstractAction actOpen) {
        this.partsIdentifier = partsIdentifier;
        this.layer = layer;
        this.layerOrder = layerOrder;
        this.imageResource = imageResource;
        this.pngHeader = pngHeader;
        this.btnOpen = new JButton(actOpen){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return "open";
            }
        };
    }

    public int hashCode() {
        return this.partsIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof InformationModel) {
            InformationModel o = (InformationModel)obj;
            return this.partsIdentifier.equals(o.partsIdentifier) && this.layer.equals(o.layer);
        }
        return false;
    }

    @Override
    public int compareTo(InformationModel o) {
        int ret = this.partsIdentifier.compareTo(o.partsIdentifier);
        if (ret == 0) {
            ret = this.layer.compareTo(o.layer);
        }
        if (ret == 0) {
            ret = this.imageResource.compareTo(o.imageResource);
        }
        return ret;
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public String getCategoryName() {
        return this.partsIdentifier.getPartsCategory().getLocalizedCategoryName();
    }

    public String getLayerName() {
        return this.layer.getLocalizedName();
    }

    public int getDefaultLayerOrder() {
        return this.layer.getOrder();
    }

    public int getLayerOrder() {
        return this.layerOrder;
    }

    public String getImageResourceName() {
        return this.imageResource.getFullName();
    }

    public JButton getButton() {
        return this.btnOpen;
    }

    public String getImageSizeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        return this.pngHeader.getWidth() + "x" + this.pngHeader.getHeight();
    }

    public String getColorTypeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        StringBuilder buf = new StringBuilder();
        int colorType = this.pngHeader.getColorType();
        if ((colorType & 1) != 0) {
            buf.append("Indexed ");
        }
        if ((colorType & 2) != 0) {
            buf.append("Color ");
        } else {
            buf.append("Greyscale ");
        }
        if (colorType == 6 || this.pngHeader.hasTransparencyInformation()) {
            buf.append("Alpha ");
        }
        buf.append(this.pngHeader.getBitDepth() + "bit");
        return buf.toString().trim();
    }
}

