/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class PSDCreator {
    private static boolean useRLECompression = true;

    public static boolean isUseRLECompression() {
        return useRLECompression;
    }

    public static void setUseRLECompression(boolean useRLECompression) {
        PSDCreator.useRLECompression = useRLECompression;
    }

    public static byte[] createPSD(Collection<LayerData> layerDatas) throws IOException {
        if (layerDatas == null) {
            throw new NullPointerException("layerDatas is required.");
        }
        if (layerDatas.isEmpty()) {
            throw new IllegalArgumentException("layerDatas must not be empty.");
        }
        BufferedImage cimg = PSDCreator.createCompositeImage(layerDatas);
        int width = cimg.getWidth();
        int height = cimg.getHeight();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write("8BPS".getBytes());
        dos.writeShort(1);
        dos.write(new byte[6]);
        dos.writeShort(4);
        dos.writeInt(height);
        dos.writeInt(width);
        int depth = 8;
        dos.writeShort(depth);
        dos.writeShort(3);
        dos.writeInt(0);
        dos.writeInt(0);
        byte[] layerMaskSection = PSDCreator.createLayerMaskSection(layerDatas);
        dos.writeInt(layerMaskSection.length);
        dos.write(layerMaskSection);
        byte[] pictureDatas = PSDCreator.createPictureSection(cimg, width, height);
        dos.write(pictureDatas);
        return bos.toByteArray();
    }

    private static byte[] createLayerMaskSection(Collection<LayerData> layerDatas) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] layerData = PSDCreator.createLayerData(layerDatas);
        dos.writeInt(layerData.length);
        dos.write(layerData);
        return bos.toByteArray();
    }

    private static byte[] createLayerData(Collection<LayerData> layerDatas) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        int numOfLayers = layerDatas.size();
        dos.writeShort(numOfLayers);
        short[] channels = new short[]{-1, 0, 1, 2};
        HashMap<LayerChannelPair, byte[]> channelDataMap = new HashMap<LayerChannelPair, byte[]>();
        for (LayerData layerData : layerDatas) {
            String layerName = layerData.getLayerName();
            BufferedImage image = layerData.getImage();
            int width = image.getWidth();
            int height = image.getHeight();
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeInt(height);
            dos.writeInt(width);
            dos.writeShort(channels.length);
            byte[][] channelsData = PSDCreator.createChannels(image);
            for (int channel = 0; channel < channels.length; ++channel) {
                byte[] outChannelData;
                byte[] channelData = channelsData[channel];
                if (useRLECompression) {
                    int bufsiz = 0;
                    ArrayList<byte[]> rleRows = new ArrayList<byte[]>();
                    for (int y = 0; y < height; ++y) {
                        byte[] rleRow = PSDCreator.compressRLE(channelData, y * width, width);
                        rleRows.add(rleRow);
                        bufsiz += 2 + rleRow.length;
                    }
                    ByteBuffer outbuf = ByteBuffer.allocate(bufsiz);
                    for (byte[] rleRow : rleRows) {
                        outbuf.putShort((short)rleRow.length);
                    }
                    for (byte[] rleRow : rleRows) {
                        outbuf.put(rleRow);
                    }
                    outChannelData = outbuf.array();
                } else {
                    outChannelData = channelData;
                }
                dos.writeShort(channels[channel]);
                dos.writeInt(2 + outChannelData.length);
                channelDataMap.put(new LayerChannelPair(layerData, channel), outChannelData);
            }
            dos.write("8BIM".getBytes());
            dos.write("norm".getBytes());
            dos.write(-1);
            dos.write(0);
            dos.write(0);
            dos.write(0);
            byte[] layerMaskData = PSDCreator.createLayerMaskData();
            byte[] layerBlendingData = PSDCreator.createLayerBlendingData();
            byte[] layerNameData = PSDCreator.createLayerName(layerName);
            int lenOfAdditional = layerMaskData.length + layerBlendingData.length + layerNameData.length;
            dos.writeInt(lenOfAdditional);
            dos.write(layerMaskData);
            dos.write(layerBlendingData);
            dos.write(layerNameData);
        }
        for (LayerData layerData : layerDatas) {
            for (int channel = 0; channel < channels.length; ++channel) {
                byte[] outChannelData = (byte[])channelDataMap.get(new LayerChannelPair(layerData, channel));
                assert (outChannelData != null);
                dos.writeShort(useRLECompression ? 1 : 0);
                dos.write(outChannelData);
            }
        }
        return bos.toByteArray();
    }

    private static byte[] createLayerMaskData() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(0);
        return bos.toByteArray();
    }

    private static byte[] createLayerBlendingData() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(0);
        return bos.toByteArray();
    }

    private static byte[] createLayerName(String layerName) throws IOException {
        byte[] nameBuf = layerName.getBytes("UTF-8");
        int layerNameSize = 1 + nameBuf.length;
        int blockSize = layerNameSize / 4 * 4 + (layerNameSize % 4 > 0 ? 4 : 0);
        int paddingSize = blockSize - layerNameSize;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write((byte)nameBuf.length);
        dos.write(nameBuf);
        dos.write(new byte[paddingSize]);
        return bos.toByteArray();
    }

    private static byte[][] createChannels(BufferedImage img) {
        WritableRaster raster = img.getRaster();
        DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = buffer.getData();
        int width = img.getWidth();
        int height = img.getHeight();
        int mx = width * height;
        byte[][] channels = new byte[4][mx];
        for (int idx = 0; idx < mx; ++idx) {
            int argb = pixels[idx];
            int alpha = argb >> 24 & 0xFF;
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            channels[0][idx] = (byte)alpha;
            channels[1][idx] = (byte)red;
            channels[2][idx] = (byte)green;
            channels[3][idx] = (byte)blue;
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createCompositeImage(Collection<LayerData> layerDatas) {
        int width = 0;
        int height = 0;
        for (LayerData layerData : layerDatas) {
            BufferedImage img = layerData.getImage();
            int w = img.getWidth();
            int h = img.getHeight();
            if (w > width) {
                width = w;
            }
            if (h <= height) continue;
            height = h;
        }
        BufferedImage cimg = new BufferedImage(width, height, 2);
        Graphics2D g = cimg.createGraphics();
        try {
            for (LayerData layerData : layerDatas) {
                BufferedImage img = layerData.getImage();
                int w = img.getWidth();
                int h = img.getHeight();
                g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
            }
        }
        finally {
            g.dispose();
        }
        return cimg;
    }

    private static byte[] createPictureSection(BufferedImage img, int width, int height) {
        ByteBuffer channelData;
        byte[][] channels = PSDCreator.createChannels(img);
        assert (width == img.getWidth());
        assert (height == img.getHeight());
        int[] channelMap = new int[]{1, 2, 3, 0};
        if (useRLECompression) {
            int bufsiz = 2;
            ArrayList<byte[]> rows = new ArrayList<byte[]>();
            for (int channel = 0; channel < channels.length; ++channel) {
                byte[] pixels = channels[channelMap[channel]];
                for (int y = 0; y < height; ++y) {
                    byte[] row = PSDCreator.compressRLE(pixels, y * width, width);
                    rows.add(row);
                    bufsiz += 2 + row.length;
                }
            }
            channelData = ByteBuffer.allocate(bufsiz);
            channelData.order(ByteOrder.BIG_ENDIAN);
            channelData.putShort((short)1);
            for (byte[] row : rows) {
                channelData.putShort((short)row.length);
            }
            for (byte[] row : rows) {
                channelData.put(row);
            }
        } else {
            byte[] pixels;
            int channel;
            int bufsiz = 2;
            for (channel = 0; channel < channels.length; ++channel) {
                pixels = channels[channelMap[channel]];
                bufsiz += pixels.length;
            }
            channelData = ByteBuffer.allocate(bufsiz);
            channelData.order(ByteOrder.BIG_ENDIAN);
            channelData.putShort((short)0);
            for (channel = 0; channel < channels.length; ++channel) {
                pixels = channels[channelMap[channel]];
                channelData.put(pixels);
            }
        }
        return channelData.array();
    }

    public static byte[] compressRLE(byte[] data, int offset, int length) {
        ByteBuffer outbuf = ByteBuffer.allocate(length * 2);
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        while (buf.hasRemaining()) {
            byte ch2;
            byte ch = buf.get();
            int count = 0;
            buf.mark();
            byte prev = ch;
            while (buf.hasRemaining() && count < 128 && prev != (ch2 = buf.get())) {
                prev = ch2;
                if (buf.hasRemaining() || ++count >= 128) continue;
                ++count;
                break;
            }
            buf.reset();
            if (count > 0) {
                outbuf.put((byte)(count - 1));
                outbuf.put(ch);
                while (--count > 0) {
                    ch = buf.get();
                    outbuf.put(ch);
                }
                continue;
            }
            prev = ch;
            for (count = 1; buf.hasRemaining() && count < 128; ++count) {
                ch = buf.get();
                if (prev != ch) {
                    buf.reset();
                    break;
                }
                buf.mark();
            }
            outbuf.put((byte)(-count + 1));
            outbuf.put(prev);
        }
        outbuf.flip();
        int limit = outbuf.limit();
        byte[] array = outbuf.array();
        byte[] result = new byte[limit];
        System.arraycopy(array, 0, result, 0, limit);
        return result;
    }

    static final class LayerChannelPair {
        private final LayerData layerData;
        private final int channel;

        public LayerChannelPair(LayerData layerData, int channel) {
            this.layerData = layerData;
            this.channel = channel;
        }

        public LayerData getLayerData() {
            return this.layerData;
        }

        public int getChannel() {
            return this.channel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.channel;
            result = 31 * result + (this.layerData == null ? 0 : this.layerData.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LayerChannelPair other = (LayerChannelPair)obj;
            if (this.channel != other.channel) {
                return false;
            }
            return !(this.layerData == null ? other.layerData != null : !this.layerData.equals(other.layerData));
        }
    }

    public static class LayerData {
        private String layerName;
        private BufferedImage image;

        public LayerData(String layerName, BufferedImage image) {
            this.layerName = layerName;
            this.image = image;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

