/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.util.BeanPropertiesUtilities;
import charactermanaj.util.ConfigurationDirUtilities;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class AppConfig {
    private static final String CONFIG_NAME = "appConfig.xml";
    public static final String COMMON_CHARACTER_DIR_PROPERTY_NAME = "character.dir";
    private static final String DEFAULT_SPECIFICATION_VERSION = "1.0";
    private static final Logger logger = Logger.getLogger(AppConfig.class.getName());
    private static final AppConfig singleton = new AppConfig();
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private String implementationVersion;
    private String specificationVersion;
    public static final String SAMPLE_IMAGE_BG_COLOR = "sampleImageBgColor";
    private Color sampleImageBgColor = Color.white;
    public static final String DEFAULT_IMAGE_BG_COLOR = "defaultImageBgColor";
    private Color defaultImageBgColor = Color.white;
    public static final String CHECKED_ITEM_BG_COLOR = "checkedItemBgColor";
    private Color checkedItemBgColor = Color.cyan.brighter();
    public static final String SELECTED_ITEM_BG_COLOR = "selectedItemBgColor";
    private Color selectedItemBgColor = Color.orange;
    public static final String INVALID_BG_COLOR = "invalidBgColor";
    private Color invalidBgColor = Color.red.brighter().brighter();
    public static final String COMPRESSION_QUALITY = "compressionQuality";
    private float compressionQuality = 0.8f;
    public static final String EXPORT_PRESET_WARNINGS_FOREGROUND_COLOR = "exportPresetWarningsForegroundColor";
    private Color exportPresetWarningsForegroundColor = Color.red;
    public static final String JAR_TRANSFER_BUFFER_SIZE = "jarTransferBufferSize";
    private int jarTransferBufferSize = 4096;
    public static final String ZIP_NAME_ENCODING = "zipNameEncoding";
    private String zipNameEncoding = "csWindows31J";
    public static final String DISABLED_CELL_FOREGROUND_COLOR = "disabledCellForegroundColor";
    private Color disabledCellForegroundColor = Color.gray;
    public static final String DIR_WATCH_INTERVAL = "dirWatchInterval";
    private int dirWatchInterval = 7000;
    public static final String ENABLE_DIR_WATCH = "enableDirWatch";
    private boolean enableDirWatch = true;
    public static final String FILE_TRANSFER_BUFFER_SIZE = "fileTransferBufferSize";
    private int fileTransferBufferSize = 4096;
    public static final String PREVIEW_INDEICATOR_DELAY = "previewIndeicatorDelay";
    private long previewIndeicatorDelay = 300L;
    public static final String INFORMATION_DIALOG_OPEN_METHOD = "informationDialogOpenMethod";
    private boolean informationDialogOpenMethod = true;
    public static final String NO_REMOVE_LOG = "noRemoveLog";
    private boolean noRemoveLog = false;
    public static final String GRID_COLOR = "gridColor";
    private Color gridColor = Color.gray;
    public static final String ENABLE_AUTO_COLOR_CHANGE = "enableAutoColorChange";
    private boolean enableAutoColorChange = true;
    public static final String AUTHOR_EDIT_CONFLICT_BG_COLOR = "authorEditConflictBgColor";
    Color authorEditConflictBgColor = Color.yellow;
    public static final String MAIN_FRAME_MAX_WIDTH = "mainFrameMaxWidth";
    private int mainFrameMaxWidth = 800;
    public static final String MAIN_FRAME_MAX_HEIGHT = "mainFrameMaxHeight";
    private int mainFrameMaxHeight = 600;
    public static final String NOT_DISABLE_LAYER_TAB = "notDisableLayerTab";
    private boolean notDisableLayerTab;
    public static final String PURGE_LOG_DAYS = "purgeLogDays";
    private long purgeLogDays = 10L;
    public static final String PARTS_COLOR_GROUP_PATTERN = "partsColorGroupPattern";
    private String partsColorGroupPattern = "^.*\\(@\\).*$";
    private Color selectPanelTitleColor = Color.BLUE;
    public static final String SELECT_PANEL_TITLE_COLOR = "selectPanelTitleColor";
    private boolean enableAutoShrinkPanel;
    public static final String ENABLE_AUTO_SHRINK_PANEL = "enableAutoShrinkPanel";
    public static final String DISABLE_WATCH_DIR_IF_NOT_WRITABLE = "disableWatchDirIfNotWritable";
    private boolean disableWatchDirIfNotWritable = true;
    public static final String ENABLE_PNG_SUPPORT_FOR_WINDOWS = "enablePNGSupportForWindows";
    private boolean enablePNGSupportForWindows = true;
    private double renderingOptimizeThresholdForNormal = 2.0;
    public static final String RENDERING_OPTIMIZE_THRESHOLD_FOR_NORMAL = "renderingOptimizeThresholdForNormal";
    private double renderingOptimizeThresholdForCheck = 0.0;
    public static final String RENDERING_OPTIMIZE_THRESHOLD_FOR_CHECK = "renderingOptimizeThresholdForCheck";
    private boolean enableInterpolationBicubic = true;
    public static final String ENABLE_INTERPOLATION_BICUBIC = "enableInterpolationBicubic";
    private String predefinedZoomRanges = "20, 50, 80, 100, 120, 150, 200, 300, 400, 800";
    public static final String PREDEFINED_ZOOM_RANGES = "predefinedZoomRanges";
    private boolean enableZoomPanel = true;
    public static final String ENABLE_ZOOM_PANEL = "enableZoomPanel";
    private int zoomPanelActivationArea = 30;
    public static final String ZOOM_PANEL_ACTIVATION_AREA = "zoomPanelActivationArea";
    private boolean enableRenderingHints = true;
    public static final String ENABLE_RENDERING_HINTS = "enableRenderingHints";
    private int drawGridMask = 2;
    public static final String DRAW_GRID_MASK = "drawGridMask";
    private Color previewGridColor = new Color(0x7F7F0000, true);
    public static final String PREVIEW_GRID_COLOR = "previewGridColor";
    private int previewGridSize = 20;
    public static final String PREVIEW_GRID_SIZE = "previewGridSize";
    private int previewUnfilledSpaceForCheckMode = 0;
    public static final String PREVIEW_UNFILLED_SPACE_FOR_CHECK_MODE = "previewUnfilledSpaceForCheckMode";
    private boolean enableCheckInfoTooltip = true;
    public static final String ENABLE_CHECK_INFO_TOOLTIP = "enableCheckInfoTooltip";
    private int wheelScrollUnit = 10;
    public static final String WHEEL_SCROLL_UNIT = "wheelScrollUnit";
    private boolean enableOffscreenWallpaper = false;
    public static final String ENABLE_OFFSCREEN_WALLPAPER = "enableOffscreenWallpaper";
    private int offscreenWallpaperSize = 300;
    private static final String OFFSCREEN_WALLPAPER_SIZE = "offscreenWallpaperSize";
    private int randomChooserMaxHistory = 10;
    public static final String RANDOM_CHOOSER_MAX_HISTORY = "randomChooserMaxHistory";
    private int defaultFontSize = 12;
    public static final String DEFAULT_FONT_SIZE = "defaultFontSize";
    private String fontPriority = "Lucida Grande";
    public static final String FONT_PRIORITY = "fontPriority";
    private boolean enableRestoreWindow = false;
    public static final String ENABLE_RESTORE_WINDOW = "enableRestoreWindow";
    private boolean enableColorAdvancedSettings = true;
    public static final String ENABLE_COLOR_ADVANCED_SETTINGS = "enableColorAdvancedSettings";
    private boolean useRecycleBinIfSupported = true;
    public static final String USE_RECYCLE_BIN_IF_SUPPORTED = "useRecycleBinIfSupported";
    public boolean useRLECompressionForPSD = true;
    private static final String USE_RLE_COMPRESSION_FOR_PSD = "useRLECompressionForPSD";

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static AppConfig getInstance() {
        return singleton;
    }

    private AppConfig() {
        this.loadAppVersions();
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    private void loadAppVersions() {
        Package pak = this.getClass().getPackage();
        String implementationVersion = "develop";
        String specificationVersion = DEFAULT_SPECIFICATION_VERSION;
        if (pak != null) {
            String specVInfo;
            String vInfo = pak.getImplementationVersion();
            if (vInfo != null && implementationVersion.trim().length() > 0) {
                implementationVersion = vInfo.trim();
            }
            if ((specVInfo = pak.getSpecificationVersion()) != null && specVInfo.trim().length() > 0) {
                specificationVersion = specVInfo.trim();
            }
        }
        this.implementationVersion = implementationVersion;
        this.specificationVersion = specificationVersion;
    }

    private String[] getLocalizedSuffix(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        return new String[]{"", "_" + language, "_" + language + "_" + country, "_" + language + "_" + country + "_" + variant};
    }

    private List<File> expandLocalizedSuffix(File base, Locale locale) {
        String right;
        String left;
        String path = base.getPath();
        int pt = path.lastIndexOf(".");
        if (pt >= 0) {
            left = path.substring(0, pt);
            right = path.substring(pt);
        } else {
            left = path;
            right = "";
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String suffix : this.getLocalizedSuffix(locale)) {
            String newPath = left + suffix + right;
            files.add(new File(newPath));
        }
        return files;
    }

    public List<URI> getCandidateURIs() throws IOException {
        ArrayList<URI> uris = new ArrayList<URI>();
        this.getAppConfigResourceURI(uris);
        String specifiedAppConfig = System.getProperty("appConfigFile");
        if (specifiedAppConfig != null) {
            if (specifiedAppConfig.trim().length() > 0) {
                File specifiedAppConfigFile = new File(specifiedAppConfig);
                uris.add(specifiedAppConfigFile.toURI());
            }
        } else {
            File codeBase = ConfigurationDirUtilities.getApplicationBaseDir();
            for (File localizedFile : this.expandLocalizedSuffix(new File(codeBase, CONFIG_NAME).getCanonicalFile(), null)) {
                uris.add(localizedFile.toURI());
            }
            File userDataDir = ConfigurationDirUtilities.getUserDataDir();
            uris.add(new File(userDataDir, CONFIG_NAME).toURI());
        }
        return uris;
    }

    protected void getAppConfigResourceURI(List<URI> uris) {
        for (File localizedFile : this.expandLocalizedSuffix(new File(this.getClass().getResource("/appConfig.xml").getPath()), null)) {
            uris.add(localizedFile.toURI());
        }
    }

    public List<File> getPrioritySaveFileList() {
        ArrayList<File> saveFiles = new ArrayList<File>();
        String specifiedAppConfig = System.getProperty("appConfigFile");
        if (specifiedAppConfig != null) {
            File specifiedAppConfigFile;
            if (specifiedAppConfig.trim().length() > 0 && (!(specifiedAppConfigFile = new File(specifiedAppConfig)).exists() || specifiedAppConfigFile.canWrite())) {
                saveFiles.add(specifiedAppConfigFile);
            }
        } else {
            File userDataDir = ConfigurationDirUtilities.getUserDataDir();
            saveFiles.add(new File(userDataDir, CONFIG_NAME));
        }
        return saveFiles;
    }

    public void loadConfig() {
        try {
            this.loadConfig(this.getCandidateURIs());
        }
        catch (IOException ex) {
            throw new RuntimeException("appConfig.xml loading failed.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(List<URI> uris) {
        if (uris == null) {
            uris = Collections.emptyList();
        }
        Properties config = new Properties();
        try {
            for (URI uri : uris) {
                File file;
                if (uri == null) continue;
                if ("file".equals(uri.getScheme()) && !(file = new File(uri)).exists()) {
                    logger.log(Level.CONFIG, "appConfig.xml is not found.:" + file);
                    continue;
                }
                try {
                    URL resourceURL = uri.toURL();
                    InputStream is = resourceURL.openStream();
                    try {
                        config.loadFromXML(is);
                        logger.log(Level.CONFIG, "appConfig.xml is loaded.:" + uri);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.CONFIG, "appConfig.xml is not found.: " + uri, ex);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "appConfig.xml loading failed.: " + uri, ex);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("appConfig.xml loading failed.", ex);
        }
        BeanPropertiesUtilities.loadFromProperties(this, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(List<File> prioritySaveFiles) throws IOException {
        Properties config = this.getProperties();
        IOException oex = null;
        for (File configStore : prioritySaveFiles) {
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(configStore));
                try {
                    config.storeToXML((OutputStream)os, CONFIG_NAME, "UTF-8");
                    return;
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u8a2d\u5b9a\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + ex, ex);
                oex = ex;
            }
        }
        if (oex != null) {
            throw oex;
        }
    }

    public void saveConfig() throws IOException {
        this.saveConfig(this.getPrioritySaveFileList());
    }

    public static Map<String, Object> getDefaultProperties() {
        BeanPropertiesUtilities.PropertyAccessorMap<AppConfig> accessorMap = BeanPropertiesUtilities.getPropertyAccessorMap(AppConfig.class);
        AppConfig dummy = new AppConfig();
        ArrayList<URI> uris = new ArrayList<URI>();
        dummy.getAppConfigResourceURI(uris);
        dummy.loadConfig(uris);
        accessorMap.setBean(dummy);
        HashMap<String, Object> defMap = new HashMap<String, Object>();
        for (Map.Entry<String, BeanPropertiesUtilities.PropertyAccessor> propEntry : accessorMap.entrySet()) {
            String name = propEntry.getKey();
            BeanPropertiesUtilities.PropertyAccessor accessor = propEntry.getValue();
            Object value = accessor.getValue();
            defMap.put(name, value);
        }
        return defMap;
    }

    public static Set<String> checkProperties(Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        AppConfig dummy = new AppConfig();
        return AppConfig.update(props, dummy);
    }

    public Set<String> update(Map<String, Object> props) {
        return AppConfig.update(props, this);
    }

    private static Set<String> update(Map<String, Object> props, AppConfig bean) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> rejectedNames = new HashSet<String>();
        BeanPropertiesUtilities.PropertyAccessorMap<AppConfig> accessorMap = BeanPropertiesUtilities.getPropertyAccessorMap(AppConfig.class);
        accessorMap.setBean(bean);
        for (Map.Entry<String, Object> propEntry : props.entrySet()) {
            String name = propEntry.getKey();
            Object value = propEntry.getValue();
            BeanPropertiesUtilities.PropertyAccessor accessor = (BeanPropertiesUtilities.PropertyAccessor)accessorMap.get(name);
            if (accessor == null) {
                rejectedNames.add(name);
                continue;
            }
            Class<?> propertyType = accessor.getPropertyType();
            if (propertyType.isPrimitive() && value == null) {
                rejectedNames.add(name);
                continue;
            }
            try {
                accessor.setValue(value);
            }
            catch (Exception ex) {
                rejectedNames.add(name);
                logger.log(Level.WARNING, "invalid propery: " + name + " /val=" + value, ex);
            }
        }
        return rejectedNames;
    }

    public Properties getProperties() {
        Properties config = new Properties();
        BeanPropertiesUtilities.saveToProperties(this, config);
        return config;
    }

    public Color getSampleImageBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSampleImageBgColor(Color sampleImageBgColor) {
        if (sampleImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.sampleImageBgColor;
        if (old == null ? sampleImageBgColor != null : !old.equals(sampleImageBgColor)) {
            this.sampleImageBgColor = sampleImageBgColor;
            this.propChangeSupport.firePropertyChange(SAMPLE_IMAGE_BG_COLOR, old, sampleImageBgColor);
        }
    }

    public Color getDefaultImageBgColor() {
        return this.defaultImageBgColor;
    }

    public void setDefaultImageBgColor(Color defaultImageBgColor) {
        if (defaultImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.defaultImageBgColor;
        if (old == null ? defaultImageBgColor != null : !old.equals(defaultImageBgColor)) {
            this.defaultImageBgColor = defaultImageBgColor;
            this.propChangeSupport.firePropertyChange(DEFAULT_IMAGE_BG_COLOR, old, defaultImageBgColor);
        }
    }

    public Color getCheckedItemBgColor() {
        return this.checkedItemBgColor;
    }

    public void setCheckedItemBgColor(Color checkedItemBgColor) {
        if (checkedItemBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.checkedItemBgColor;
        if (old == null ? checkedItemBgColor != null : !old.equals(checkedItemBgColor)) {
            this.checkedItemBgColor = checkedItemBgColor;
            this.propChangeSupport.firePropertyChange(CHECKED_ITEM_BG_COLOR, old, checkedItemBgColor);
        }
    }

    public Color getSelectedItemBgColor() {
        return this.selectedItemBgColor;
    }

    public void setSelectedItemBgColor(Color selectedItemBgColor) {
        if (selectedItemBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.selectedItemBgColor;
        if (old == null ? selectedItemBgColor != null : !old.equals(selectedItemBgColor)) {
            this.selectedItemBgColor = selectedItemBgColor;
            this.propChangeSupport.firePropertyChange(SELECTED_ITEM_BG_COLOR, old, selectedItemBgColor);
        }
    }

    public Color getInvalidBgColor() {
        return this.invalidBgColor;
    }

    public void setInvalidBgColor(Color invalidBgColor) {
        if (invalidBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.invalidBgColor;
        if (old == null ? invalidBgColor != null : !old.equals(invalidBgColor)) {
            this.invalidBgColor = invalidBgColor;
            this.propChangeSupport.firePropertyChange(INVALID_BG_COLOR, old, invalidBgColor);
        }
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public void setCompressionQuality(float compressionQuality) {
        if (compressionQuality < 0.1f || compressionQuality > 1.0f) {
            throw new IllegalArgumentException();
        }
        float old = this.compressionQuality;
        if (old != compressionQuality) {
            this.compressionQuality = compressionQuality;
            this.propChangeSupport.firePropertyChange(COMPRESSION_QUALITY, Float.valueOf(old), Float.valueOf(compressionQuality));
        }
    }

    public Color getExportPresetWarningsForegroundColor() {
        return this.exportPresetWarningsForegroundColor;
    }

    public void setExportPresetWarningsForegroundColor(Color exportPresetWarningsForegroundColor) {
        if (exportPresetWarningsForegroundColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.exportPresetWarningsForegroundColor;
        if (old == null ? exportPresetWarningsForegroundColor != null : !old.equals(exportPresetWarningsForegroundColor)) {
            this.exportPresetWarningsForegroundColor = exportPresetWarningsForegroundColor;
            this.propChangeSupport.firePropertyChange(EXPORT_PRESET_WARNINGS_FOREGROUND_COLOR, old, exportPresetWarningsForegroundColor);
        }
    }

    public int getJarTransferBufferSize() {
        return this.jarTransferBufferSize;
    }

    public void setJarTransferBufferSize(int jarTransferBufferSize) {
        if (jarTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        int old = this.jarTransferBufferSize;
        if (old != jarTransferBufferSize) {
            this.jarTransferBufferSize = jarTransferBufferSize;
            this.propChangeSupport.firePropertyChange(JAR_TRANSFER_BUFFER_SIZE, old, jarTransferBufferSize);
        }
    }

    public String getZipNameEncoding() {
        return this.zipNameEncoding;
    }

    public void setZipNameEncoding(String zipNameEncoding) {
        if (zipNameEncoding == null) {
            throw new IllegalArgumentException();
        }
        try {
            Charset.forName(zipNameEncoding);
        }
        catch (Exception ex) {
            throw new RuntimeException("unsupported charset: " + zipNameEncoding);
        }
        String old = this.zipNameEncoding;
        if (old == null ? zipNameEncoding != null : !old.equals(zipNameEncoding)) {
            this.zipNameEncoding = zipNameEncoding;
            this.propChangeSupport.firePropertyChange(ZIP_NAME_ENCODING, old, zipNameEncoding);
        }
    }

    public Color getDisabledCellForgroundColor() {
        return this.disabledCellForegroundColor;
    }

    public void setDisabledCellForegroundColor(Color disabledCellForegroundColor) {
        if (disabledCellForegroundColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.disabledCellForegroundColor;
        if (old == null ? disabledCellForegroundColor != null : !old.equals(disabledCellForegroundColor)) {
            this.disabledCellForegroundColor = disabledCellForegroundColor;
            this.propChangeSupport.firePropertyChange(DISABLED_CELL_FOREGROUND_COLOR, old, disabledCellForegroundColor);
        }
    }

    public int getDirWatchInterval() {
        return this.dirWatchInterval;
    }

    public void setDirWatchInterval(int dirWatchInterval) {
        if (dirWatchInterval <= 0) {
            throw new IllegalArgumentException();
        }
        int old = this.dirWatchInterval;
        if (old != dirWatchInterval) {
            this.dirWatchInterval = dirWatchInterval;
            this.propChangeSupport.firePropertyChange(DIR_WATCH_INTERVAL, old, dirWatchInterval);
        }
    }

    public boolean isEnableDirWatch() {
        return this.enableDirWatch;
    }

    public void setEnableDirWatch(boolean enableDirWatch) {
        boolean old = this.enableDirWatch;
        if (old != enableDirWatch) {
            this.enableDirWatch = enableDirWatch;
            this.propChangeSupport.firePropertyChange(ENABLE_DIR_WATCH, old, enableDirWatch);
        }
    }

    public int getFileTransferBufferSize() {
        return this.fileTransferBufferSize;
    }

    public void setFileTransferBufferSize(int fileTransferBufferSize) {
        if (fileTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        int old = this.fileTransferBufferSize;
        if (old != fileTransferBufferSize) {
            this.fileTransferBufferSize = fileTransferBufferSize;
            this.propChangeSupport.firePropertyChange(FILE_TRANSFER_BUFFER_SIZE, old, fileTransferBufferSize);
        }
    }

    public long getPreviewIndicatorDelay() {
        return this.previewIndeicatorDelay;
    }

    public void setPreviewIndeicatorDelay(long previewIndeicatorDelay) {
        if (previewIndeicatorDelay < 0L) {
            throw new IllegalArgumentException();
        }
        long old = this.previewIndeicatorDelay;
        if (old != previewIndeicatorDelay) {
            this.previewIndeicatorDelay = previewIndeicatorDelay;
            this.propChangeSupport.firePropertyChange(PREVIEW_INDEICATOR_DELAY, old, previewIndeicatorDelay);
        }
    }

    public boolean isInformationDialogOpenMethod() {
        return this.informationDialogOpenMethod;
    }

    public void setInformationDialogOpenMethod(boolean informationDialogOpenMethod) {
        boolean old = this.informationDialogOpenMethod;
        if (old != informationDialogOpenMethod) {
            this.informationDialogOpenMethod = informationDialogOpenMethod;
            this.propChangeSupport.firePropertyChange(INFORMATION_DIALOG_OPEN_METHOD, old, informationDialogOpenMethod);
        }
    }

    public boolean isNoRemoveLog() {
        return this.noRemoveLog;
    }

    public void setNoRemoveLog(boolean noRemoveLog) {
        boolean old = this.noRemoveLog;
        if (old != noRemoveLog) {
            this.noRemoveLog = noRemoveLog;
            this.propChangeSupport.firePropertyChange(NO_REMOVE_LOG, old, noRemoveLog);
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.gridColor;
        if (old == null ? gridColor != null : !old.equals(gridColor)) {
            this.gridColor = gridColor;
            this.propChangeSupport.firePropertyChange(GRID_COLOR, old, gridColor);
        }
    }

    public boolean isEnableAutoColorChange() {
        return this.enableAutoColorChange;
    }

    public void setEnableAutoColorChange(boolean enableAutoColorChange) {
        boolean old = this.enableAutoColorChange;
        if (old != enableAutoColorChange) {
            this.enableAutoColorChange = enableAutoColorChange;
            this.propChangeSupport.firePropertyChange(ENABLE_AUTO_COLOR_CHANGE, old, enableAutoColorChange);
        }
    }

    public void setAuthorEditConflictBgColor(Color authorEditConflictBgColor) {
        if (authorEditConflictBgColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.authorEditConflictBgColor;
        if (old == null ? authorEditConflictBgColor != null : !old.equals(authorEditConflictBgColor)) {
            this.authorEditConflictBgColor = authorEditConflictBgColor;
            this.propChangeSupport.firePropertyChange(AUTHOR_EDIT_CONFLICT_BG_COLOR, old, authorEditConflictBgColor);
        }
    }

    public Color getAuthorEditConflictBgColor() {
        return this.authorEditConflictBgColor;
    }

    public void setMainFrameMaxWidth(int mainFrameMaxWidth) {
        int old = mainFrameMaxWidth;
        if (old != mainFrameMaxWidth) {
            this.mainFrameMaxWidth = mainFrameMaxWidth;
            this.propChangeSupport.firePropertyChange(MAIN_FRAME_MAX_WIDTH, old, mainFrameMaxWidth);
        }
    }

    public int getMainFrameMaxWidth() {
        return this.mainFrameMaxWidth;
    }

    public void setMainFrameMaxHeight(int mainFrameMaxHeight) {
        int old = this.mainFrameMaxHeight;
        if (old != mainFrameMaxHeight) {
            this.mainFrameMaxHeight = mainFrameMaxHeight;
            this.propChangeSupport.firePropertyChange(MAIN_FRAME_MAX_HEIGHT, old, mainFrameMaxHeight);
        }
    }

    public int getMainFrameMaxHeight() {
        return this.mainFrameMaxHeight;
    }

    public boolean isNotDisableLayerTab() {
        return this.notDisableLayerTab;
    }

    public void setNotDisableLayerTab(boolean notDisableLayerTab) {
        boolean old = this.notDisableLayerTab;
        if (old != notDisableLayerTab) {
            this.notDisableLayerTab = notDisableLayerTab;
            this.propChangeSupport.firePropertyChange(NOT_DISABLE_LAYER_TAB, old, notDisableLayerTab);
        }
    }

    public long getPurgeLogDays() {
        return this.purgeLogDays;
    }

    public void setPurgeLogDays(long purgeLogDays) {
        long old = this.purgeLogDays;
        if (old != purgeLogDays) {
            this.purgeLogDays = purgeLogDays;
            this.propChangeSupport.firePropertyChange(PURGE_LOG_DAYS, old, purgeLogDays);
        }
    }

    public String getPartsColorGroupPattern() {
        return this.partsColorGroupPattern;
    }

    public void setPartsColorGroupPattern(String pattern) {
        String old;
        if (pattern != null && pattern.trim().length() > 0) {
            Pattern.compile(pattern);
        }
        if ((old = this.partsColorGroupPattern) == null ? pattern != null : !old.equals(pattern)) {
            this.partsColorGroupPattern = pattern;
            this.propChangeSupport.firePropertyChange(PARTS_COLOR_GROUP_PATTERN, old, pattern);
        }
    }

    public Color getSelectPanelTitleColor() {
        return this.selectPanelTitleColor;
    }

    public void setSelectPanelTitleColor(Color selectPanelTitleColor) {
        if (selectPanelTitleColor == null) {
            throw new IllegalArgumentException();
        }
        Color old = this.selectPanelTitleColor;
        if (old == null ? selectPanelTitleColor != null : !old.equals(selectPanelTitleColor)) {
            this.selectPanelTitleColor = selectPanelTitleColor;
            this.propChangeSupport.firePropertyChange(SELECT_PANEL_TITLE_COLOR, old, selectPanelTitleColor);
        }
    }

    public boolean isEnableAutoShrinkPanel() {
        return this.enableAutoShrinkPanel;
    }

    public void setEnableAutoShrinkPanel(boolean enableAutoShrinkPanel) {
        boolean old = this.enableAutoShrinkPanel;
        if (old != enableAutoShrinkPanel) {
            this.enableAutoShrinkPanel = enableAutoShrinkPanel;
            this.propChangeSupport.firePropertyChange(ENABLE_AUTO_SHRINK_PANEL, old, enableAutoShrinkPanel);
        }
    }

    public boolean isDisableWatchDirIfNotWritable() {
        return this.disableWatchDirIfNotWritable;
    }

    public void setDisableWatchDirIfNotWritable(boolean disableWatchDirIfNotWritable) {
        boolean old = this.disableWatchDirIfNotWritable;
        if (old != disableWatchDirIfNotWritable) {
            this.disableWatchDirIfNotWritable = disableWatchDirIfNotWritable;
            this.propChangeSupport.firePropertyChange(DISABLE_WATCH_DIR_IF_NOT_WRITABLE, old, disableWatchDirIfNotWritable);
        }
    }

    public void setEnablePNGSupportForWindows(boolean enablePNGSupportForWindows) {
        boolean old = this.enablePNGSupportForWindows;
        if (old != enablePNGSupportForWindows) {
            this.enablePNGSupportForWindows = enablePNGSupportForWindows;
            this.propChangeSupport.firePropertyChange(ENABLE_PNG_SUPPORT_FOR_WINDOWS, old, enablePNGSupportForWindows);
        }
    }

    public boolean isEnablePNGSupportForWindows() {
        return this.enablePNGSupportForWindows;
    }

    public void setRenderingOptimizeThresholdForNormal(double renderingOptimizeThresholdForNormal) {
        double old = this.renderingOptimizeThresholdForNormal;
        if (old != renderingOptimizeThresholdForNormal) {
            this.renderingOptimizeThresholdForNormal = renderingOptimizeThresholdForNormal;
            this.propChangeSupport.firePropertyChange(RENDERING_OPTIMIZE_THRESHOLD_FOR_NORMAL, old, renderingOptimizeThresholdForNormal);
        }
    }

    public double getRenderingOptimizeThresholdForNormal() {
        return this.renderingOptimizeThresholdForNormal;
    }

    public void setRenderingOptimizeThresholdForCheck(double renderingOptimizeThresholdForCheck) {
        double old = this.renderingOptimizeThresholdForCheck;
        if (old != renderingOptimizeThresholdForCheck) {
            this.renderingOptimizeThresholdForCheck = renderingOptimizeThresholdForCheck;
            this.propChangeSupport.firePropertyChange(RENDERING_OPTIMIZE_THRESHOLD_FOR_CHECK, old, renderingOptimizeThresholdForCheck);
        }
    }

    public double getRenderingOptimizeThresholdForCheck() {
        return this.renderingOptimizeThresholdForCheck;
    }

    public void setEnableInterpolationBicubic(boolean enableInterpolationBicubic) {
        boolean old = this.enableInterpolationBicubic;
        if (old != enableInterpolationBicubic) {
            this.enableInterpolationBicubic = enableInterpolationBicubic;
            this.propChangeSupport.firePropertyChange(ENABLE_INTERPOLATION_BICUBIC, old, enableInterpolationBicubic);
        }
    }

    public boolean isEnableInterpolationBicubic() {
        return this.enableInterpolationBicubic;
    }

    public String getPredefinedZoomRanges() {
        return this.predefinedZoomRanges;
    }

    public void setPredefinedZoomRanges(String predefinedZoomRanges) {
        if (predefinedZoomRanges == null) {
            throw new IllegalArgumentException();
        }
        String old = this.predefinedZoomRanges;
        if (old == null ? predefinedZoomRanges != null : !old.equals(predefinedZoomRanges)) {
            this.predefinedZoomRanges = predefinedZoomRanges;
            this.propChangeSupport.firePropertyChange(PREDEFINED_ZOOM_RANGES, old, predefinedZoomRanges);
        }
    }

    public boolean isEnableZoomPanel() {
        return this.enableZoomPanel;
    }

    public void setEnableZoomPanel(boolean enableZoomPanel) {
        boolean old = this.enableZoomPanel;
        if (old != enableZoomPanel) {
            this.enableZoomPanel = enableZoomPanel;
            this.propChangeSupport.firePropertyChange(ENABLE_ZOOM_PANEL, old, enableZoomPanel);
        }
    }

    public int getZoomPanelActivationArea() {
        return this.zoomPanelActivationArea;
    }

    public void setZoomPanelActivationArea(int zoomPanelActivationArea) {
        int old = this.zoomPanelActivationArea;
        if (old != zoomPanelActivationArea) {
            this.zoomPanelActivationArea = zoomPanelActivationArea;
            this.propChangeSupport.firePropertyChange(ZOOM_PANEL_ACTIVATION_AREA, old, zoomPanelActivationArea);
        }
    }

    public void setEnableRenderingHints(boolean enableRenderingHints) {
        boolean old = this.enableRenderingHints;
        if (old != enableRenderingHints) {
            this.enableRenderingHints = enableRenderingHints;
            this.propChangeSupport.firePropertyChange(ENABLE_RENDERING_HINTS, old, enableRenderingHints);
        }
    }

    public boolean isEnableRenderingHints() {
        return this.enableRenderingHints;
    }

    public int getDrawGridMask() {
        return this.drawGridMask;
    }

    public void setDrawGridMask(int drawGridMask) {
        int old = this.drawGridMask;
        if (old != (drawGridMask &= 3)) {
            this.drawGridMask = drawGridMask;
            this.propChangeSupport.firePropertyChange(DRAW_GRID_MASK, old, drawGridMask);
        }
    }

    public Color getPreviewGridColor() {
        return this.previewGridColor;
    }

    public void setPreviewGridColor(Color previewGridColor) {
        Color old = this.previewGridColor;
        if (old == null ? previewGridColor != null : !old.equals(previewGridColor)) {
            this.previewGridColor = previewGridColor;
            this.propChangeSupport.firePropertyChange(PREVIEW_GRID_COLOR, old, previewGridColor);
        }
    }

    public int getPreviewGridSize() {
        return this.previewGridSize;
    }

    public void setPreviewGridSize(int previewGridSize) {
        int old = this.previewGridSize;
        if (old != previewGridSize) {
            this.previewGridSize = previewGridSize;
            this.propChangeSupport.firePropertyChange(PREVIEW_GRID_SIZE, old, previewGridSize);
        }
    }

    public int getPreviewUnfilledSpaceForCheckMode() {
        return this.previewUnfilledSpaceForCheckMode;
    }

    public void setPreviewUnfilledSpaceForCheckMode(int previewUnfilledSpaceForCheckMode) {
        int old = this.previewUnfilledSpaceForCheckMode;
        if (old != previewUnfilledSpaceForCheckMode) {
            this.previewUnfilledSpaceForCheckMode = previewUnfilledSpaceForCheckMode;
            this.propChangeSupport.firePropertyChange(PREVIEW_UNFILLED_SPACE_FOR_CHECK_MODE, old, previewUnfilledSpaceForCheckMode);
        }
    }

    public boolean isEnableCheckInfoTooltip() {
        return this.enableCheckInfoTooltip;
    }

    public void setEnableCheckInfoTooltip(boolean enableCheckInfoTooltip) {
        boolean old = this.enableCheckInfoTooltip;
        if (old != enableCheckInfoTooltip) {
            this.enableCheckInfoTooltip = enableCheckInfoTooltip;
            this.propChangeSupport.firePropertyChange(ENABLE_CHECK_INFO_TOOLTIP, old, enableCheckInfoTooltip);
        }
    }

    public int getWheelScrollUnit() {
        return this.wheelScrollUnit;
    }

    public void setWheelScrollUnit(int wheelScrollUnit) {
        int old = this.wheelScrollUnit;
        if (old != wheelScrollUnit) {
            this.wheelScrollUnit = wheelScrollUnit;
            this.propChangeSupport.firePropertyChange(WHEEL_SCROLL_UNIT, old, wheelScrollUnit);
        }
    }

    public boolean isEnableOffscreenWallpaper() {
        return this.enableOffscreenWallpaper;
    }

    public void setEnableOffscreenWallpaper(boolean enableOffscreenWallpaper) {
        boolean old = this.enableOffscreenWallpaper;
        if (old != enableOffscreenWallpaper) {
            this.enableOffscreenWallpaper = enableOffscreenWallpaper;
            this.propChangeSupport.firePropertyChange(ENABLE_OFFSCREEN_WALLPAPER, old, enableOffscreenWallpaper);
        }
    }

    public int getOffscreenWallpaperSize() {
        return this.offscreenWallpaperSize;
    }

    public void setOffscreenWallpaperSize(int offscreenWallpaperSize) {
        int old = this.offscreenWallpaperSize;
        if (old != offscreenWallpaperSize) {
            this.offscreenWallpaperSize = offscreenWallpaperSize;
            this.propChangeSupport.firePropertyChange(OFFSCREEN_WALLPAPER_SIZE, old, offscreenWallpaperSize);
        }
    }

    public int getRandomChooserMaxHistory() {
        return this.randomChooserMaxHistory;
    }

    public void setRandomChooserMaxHistory(int randomChooserMaxHistory) {
        int old = this.randomChooserMaxHistory;
        if (old != randomChooserMaxHistory) {
            this.randomChooserMaxHistory = randomChooserMaxHistory;
            this.propChangeSupport.firePropertyChange(RANDOM_CHOOSER_MAX_HISTORY, old, randomChooserMaxHistory);
        }
    }

    public int getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public void setDefaultFontSize(int defaultFontSize) {
        int old = this.defaultFontSize;
        if (old != defaultFontSize) {
            this.defaultFontSize = defaultFontSize;
            this.propChangeSupport.firePropertyChange(DEFAULT_FONT_SIZE, old, defaultFontSize);
        }
    }

    public String getFontPriority() {
        return this.fontPriority;
    }

    public void setFontPriority(String fontPriority) {
        if (fontPriority == null) {
            throw new IllegalArgumentException();
        }
        String old = this.fontPriority;
        if (old == null ? fontPriority != null : !old.equals(fontPriority)) {
            this.fontPriority = fontPriority;
            this.propChangeSupport.firePropertyChange(FONT_PRIORITY, old, fontPriority);
        }
    }

    public boolean isEnableRestoreWindow() {
        return this.enableRestoreWindow;
    }

    public void setEnableRestoreWindow(boolean enableRestoreWindow) {
        boolean old = this.enableRestoreWindow;
        if (old != enableRestoreWindow) {
            this.enableRestoreWindow = enableRestoreWindow;
            this.propChangeSupport.firePropertyChange(ENABLE_RESTORE_WINDOW, old, enableRestoreWindow);
        }
    }

    public boolean isEnableColorAdvancedSettings() {
        return this.enableColorAdvancedSettings;
    }

    public void setEnableColorAdvancedSettings(boolean enableColorAdvancedSettings) {
        boolean old = this.enableColorAdvancedSettings;
        if (old != enableColorAdvancedSettings) {
            this.enableColorAdvancedSettings = enableColorAdvancedSettings;
            this.propChangeSupport.firePropertyChange(ENABLE_COLOR_ADVANCED_SETTINGS, old, this.enableRestoreWindow);
        }
    }

    public boolean isUseRecycleBinIfSupported() {
        return this.useRecycleBinIfSupported;
    }

    public void setUseRecycleBinIfSupported(boolean useRecycleBinIfSupported) {
        boolean old = this.useRecycleBinIfSupported;
        if (old != useRecycleBinIfSupported) {
            this.useRecycleBinIfSupported = useRecycleBinIfSupported;
            this.propChangeSupport.firePropertyChange(USE_RECYCLE_BIN_IF_SUPPORTED, old, useRecycleBinIfSupported);
        }
    }

    public boolean isUseRLECompressionForPSD() {
        return this.useRLECompressionForPSD;
    }

    public void setUseRLECompressionForPSD(boolean useRLECompressionForPSD) {
        boolean old = this.useRLECompressionForPSD;
        if (old != useRLECompressionForPSD) {
            this.useRLECompressionForPSD = useRLECompressionForPSD;
            this.propChangeSupport.firePropertyChange(USE_RLE_COMPRESSION_FOR_PSD, old, useRLECompressionForPSD);
        }
    }
}

