/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentThread;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class PartsImageDirectoryWatchAgentHandle
implements PartsImageDirectoryWatchAgent,
PartsImageDirectoryWatchListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final PartsImageDirectoryWatchAgentThread agent;
    private final LinkedList<PartsImageDirectoryWatchListener> listeners = new LinkedList();
    private boolean connected;

    protected PartsImageDirectoryWatchAgentHandle(PartsImageDirectoryWatchAgentThread agent) {
        this.agent = agent;
    }

    @Override
    public CharacterData getCharcterData() {
        return this.agent.getCharcterData();
    }

    @Override
    public void connect() {
        this.logger.log(Level.FINE, "agent connect request. " + this);
        if (!this.connected) {
            this.agent.addPartsImageDirectoryWatchListener(this);
            this.connected = true;
        }
    }

    @Override
    public void disconnect() {
        this.logger.log(Level.FINE, "agent disconnect request. " + this);
        if (this.connected) {
            this.connected = false;
            this.agent.removePartsImageDirectoryWatchListener(this);
        }
    }

    @Override
    public void suspend() {
        this.logger.log(Level.FINE, "agent stop request. " + this);
        this.agent.suspend(this);
    }

    @Override
    public void resume() {
        this.logger.log(Level.FINE, "agent resume request. " + this);
        this.agent.resume(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
            synchronized (linkedList) {
                this.listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectPartsImageChange(PartsImageDirectoryWatchEvent e) {
        if (!this.connected) {
            this.logger.log(Level.FINE, "skip agent event. " + this);
            return;
        }
        this.logger.log(Level.FINE, "agent event occured. " + this);
        PartsImageDirectoryWatchListener[] partsImageDirectoryWatchListenerArray = this.listeners;
        synchronized (this.listeners) {
            PartsImageDirectoryWatchListener[] ls = this.listeners.toArray(new PartsImageDirectoryWatchListener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PartsImageDirectoryWatchListener l : ls) {
                l.detectPartsImageChange(e);
            }
            return;
        }
    }
}

