/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

class CategoriesTableModel
extends AbstractTableModelWithComboBoxModel<CategoriesTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CategoriesTableModel.class.getName());
    private static final Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/profileditdialog");
    private static final ColumnDef[] COLUMNS = ColumnDef.values();
    private int serialCounter = 1;
    private UsedCategoryDetector usedCategoryDetector;

    public void adjustColumnModel(TableColumnModel columnModel, double scale) {
        for (int idx = 0; idx < COLUMNS.length; ++idx) {
            ColumnDef columnDef = COLUMNS[idx];
            String reskey = columnDef.getResourceKey();
            int width = Integer.parseInt(strings.getProperty(reskey + ".width"));
            columnModel.getColumn(idx).setPreferredWidth((int)((double)width * scale));
        }
    }

    public void setUsedCategoryDetector(UsedCategoryDetector usedCategoryDetector) {
        this.usedCategoryDetector = usedCategoryDetector;
    }

    public UsedCategoryDetector getUsedCategoryDetector() {
        return this.usedCategoryDetector;
    }

    public void addCategory() {
        String id = "cat" + UUID.randomUUID().toString();
        String name = "Category" + this.serialCounter++;
        CategoriesTableRow partsCategory = new CategoriesTableRow(this.serialCounter, id, name, false, false, 10, null);
        this.addRow(partsCategory);
    }

    public void reorder() {
        int mx = this.elements.size();
        for (int idx = 0; idx < mx; ++idx) {
            CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(idx);
            partsCategory.setOrder(idx + 1);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int moveDown(int rowIndex) {
        int ret = super.moveDown(rowIndex);
        this.reorder();
        return ret;
    }

    @Override
    public int moveUp(int rowIndex) {
        int ret = super.moveUp(rowIndex);
        this.reorder();
        return ret;
    }

    @Override
    public String getColumnName(int column) {
        String reskey = COLUMNS[column].getResourceKey();
        return strings.getProperty(reskey, reskey);
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(rowIndex);
        ColumnDef columnDef = COLUMNS[columnIndex];
        if (columnDef == ColumnDef.USED_LAYERS) {
            StringBuilder layerNames = new StringBuilder();
            List<LayersTableRow> layers = null;
            if (this.usedCategoryDetector != null) {
                layers = this.usedCategoryDetector.getLayers(partsCategory);
            }
            if (layers != null) {
                for (LayersTableRow layer : layers) {
                    if (layerNames.length() > 0) {
                        layerNames.append(", ");
                    }
                    layerNames.append(layer.getLayerName());
                }
            }
            return layerNames.toString();
        }
        return columnDef.getValue(partsCategory);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(rowIndex);
        try {
            ColumnDef columnDef = COLUMNS[columnIndex];
            if (columnDef.isEditable()) {
                columnDef.setValue(partsCategory, aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNS[columnIndex].getDataType();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable() && COLUMNS[columnIndex].isEditable();
    }

    static enum ColumnDef {
        CATEGORY_NAME("categories.column.categoryname", true, (Class)String.class){

            @Override
            public Object getValue(CategoriesTableRow row) {
                return row.getLocalizedCategoryName();
            }

            @Override
            public void setValue(CategoriesTableRow row, Object aValue) {
                row.setLocalizedCategoryName((String)aValue);
            }
        }
        ,
        MULTIPLE_SELECTABLE("categories.column.multipleselectable", true, (Class)Boolean.class){

            @Override
            public Object getValue(CategoriesTableRow row) {
                return row.isMultipleSelectable();
            }

            @Override
            public void setValue(CategoriesTableRow row, Object aValue) {
                row.setMultipleSelectable((Boolean)aValue);
            }
        }
        ,
        OPTIONAL("categories.column.optional", true, (Class)Boolean.class){

            @Override
            public Object getValue(CategoriesTableRow row) {
                return row.isOptional();
            }

            @Override
            public void setValue(CategoriesTableRow row, Object aValue) {
                row.setOptional((Boolean)aValue);
            }
        }
        ,
        DISPLAY_ROW_COUNT("categories.column.displayrowcount", true, (Class)Integer.class){

            @Override
            public Object getValue(CategoriesTableRow row) {
                return row.getVisibleRows();
            }

            @Override
            public void setValue(CategoriesTableRow row, Object aValue) {
                row.setVisibleRows(((Number)aValue).intValue());
            }
        }
        ,
        USED_LAYERS("categories.column.usedlayers", false, (Class)String.class){

            @Override
            public Object getValue(CategoriesTableRow row) {
                return null;
            }
        };

        private final String reskey;
        private final boolean editable;
        private final Class<?> dataType;

        private ColumnDef(String reskey, boolean editable, Class<?> dataType) {
            this.reskey = reskey;
            this.editable = editable;
            this.dataType = dataType;
        }

        public Class<?> getDataType() {
            return this.dataType;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String getResourceKey() {
            return this.reskey;
        }

        public abstract Object getValue(CategoriesTableRow var1);

        public void setValue(CategoriesTableRow row, Object value) {
            throw new UnsupportedOperationException(this.name());
        }
    }

    public static interface UsedCategoryDetector {
        public List<LayersTableRow> getLayers(CategoriesTableRow var1);
    }
}

