/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.graphics.io.PNGFileImageHeaderReader;
import charactermanaj.model.AppConfig;
import charactermanaj.model.Layer;
import charactermanaj.model.LayerOrderMapper;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsImageCollectionParser;
import charactermanaj.ui.ButtonCellEditor;
import charactermanaj.ui.ButtonCellRender;
import charactermanaj.ui.InformationRowModel;
import charactermanaj.ui.InformationTableModel;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class InformationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(InformationDialog.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/informationdialog";
    private PartsSpecResolver partsSpecResolver;
    private JTable informationTable;
    private InformationTableModel informationTableModel;
    private TableRowSorter<InformationTableModel> sorter;
    private boolean modeOpen;
    private Runnable closeHandler;

    public InformationDialog(JFrame parent, PartsSpecResolver partsSpecResolver, Runnable closeHandler) {
        super((Frame)parent, false);
        this.partsSpecResolver = partsSpecResolver;
        this.closeHandler = closeHandler;
        AppConfig appConfig = AppConfig.getInstance();
        this.modeOpen = appConfig.isInformationDialogOpenMethod();
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException("partsSpecResolver is null");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InformationDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        this.informationTableModel = new InformationTableModel();
        this.informationTable = new JTable(this.informationTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component prepareRenderer = super.prepareRenderer(renderer, row, column);
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                int preferredWidth = Math.max(prepareRenderer.getPreferredSize().width, tableColumn.getPreferredWidth());
                if (tableColumn.getPreferredWidth() != preferredWidth) {
                    tableColumn.setPreferredWidth(preferredWidth);
                }
                return prepareRenderer;
            }
        };
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        this.informationTableModel.adjustColumnModel(this.informationTable.getColumnModel(), scaleSupport.getManualScaleX());
        this.informationTable.setShowGrid(true);
        this.informationTable.setGridColor(appConfig.getGridColor());
        this.informationTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.informationTable.setAutoResizeMode(0);
        this.informationTable.setRowHeight(this.informationTable.getRowHeight() + 4);
        this.informationTable.setRowHeight((int)((double)this.informationTable.getFont().getSize() * 1.2));
        this.informationTable.setDefaultRenderer(JButton.class, new ButtonCellRender());
        this.informationTable.setDefaultEditor(JButton.class, new ButtonCellEditor());
        this.sorter = new TableRowSorter<InformationTableModel>(this.informationTableModel);
        this.sorter.setSortable(InformationTableModel.ColumnDef.EDIT_BUTTON.ordinal(), false);
        this.informationTable.setRowSorter(this.sorter);
        this.informationTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InformationDialog.this.sorter.setSortKeys(null);
                    e.consume();
                }
            }
        });
        for (int row = 0; row < this.informationTable.getRowCount(); ++row) {
            for (int col = 0; col < this.informationTable.getColumnCount(); ++col) {
                TableCellRenderer renderer = this.informationTable.getCellRenderer(row, col);
                this.informationTable.prepareRenderer(renderer, row, col);
            }
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(strings.getProperty("popupmenu.copyPath")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationDialog.this.onCopyFilePath();
            }
        });
        this.informationTable.setComponentPopupMenu(popupMenu);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JScrollPane informationTableSP = new JScrollPane(this.informationTable);
        JPanel informationTableSPPabel = new JPanel(new BorderLayout());
        informationTableSPPabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        informationTableSPPabel.add((Component)informationTableSP, "Center");
        contentPane.add((Component)informationTableSPPabel, "Center");
        AbstractAction actClose = new AbstractAction(strings.getProperty("btnClose")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationDialog.this.onClose();
            }
        };
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JButton btnClose = new JButton(actClose);
        btnPanel.add((Component)btnClose, gbc);
        contentPane.add((Component)btnPanel, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnClose);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeInformationDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeInformationDialog");
        am.put("closeInformationDialog", actClose);
        Dimension dim = this.getPreferredSize();
        dim = scaleSupport.manualScaled(dim);
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
    }

    public void showPartsInformation(PartsSet partsSet, LayerOrderMapper layerOrderMapper) {
        final Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        final PNGFileImageHeaderReader pngHeaderReader = PNGFileImageHeaderReader.getInstance();
        this.informationTableModel.clear();
        if (partsSet != null) {
            PartsImageCollectionParser parser = new PartsImageCollectionParser(this.partsSpecResolver);
            parser.parse(partsSet, layerOrderMapper, new PartsImageCollectionParser.PartsImageCollectionHandler(){
                private int serialOrder = 1;

                @Override
                public void detectImageSource(PartsIdentifier partsIdentifier, Layer layer, float layerOrder, final ImageResource imageResource, ColorConvertParameter param) {
                    PNGFileImageHeader pngHeader;
                    AbstractAction act = new AbstractAction(strings.getProperty(InformationDialog.this.modeOpen ? "btn.edit.open" : "btn.edit.edit")){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InformationDialog.this.onOpen(imageResource);
                        }
                    };
                    URI uri = imageResource.getURI();
                    if (uri != null && "file".equals(uri.getScheme()) && DesktopUtilities.isSupported()) {
                        act.setEnabled(true);
                    } else {
                        act.setEnabled(false);
                    }
                    try {
                        pngHeader = pngHeaderReader.readHeader(uri);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "PNG Header loading error.: " + uri, ex);
                        pngHeader = null;
                    }
                    InformationRowModel information = new InformationRowModel(this.serialOrder++, partsIdentifier, layer, layerOrder, imageResource, param, pngHeader, act);
                    InformationDialog.this.informationTableModel.addRow(information);
                }
            });
            this.informationTableModel.sort();
        }
    }

    protected void onClose() {
        if (this.closeHandler != null) {
            this.closeHandler.run();
        } else {
            this.dispose();
        }
    }

    protected void onCopyFilePath() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int selRow : this.informationTable.getSelectedRows()) {
            InformationRowModel information = (InformationRowModel)this.informationTableModel.getRow(selRow);
            pw.println(information.getImageResourceName());
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        String text = sw.toString();
        if (text.length() == 0) {
            tk.beep();
            return;
        }
        StringSelection textSelection = new StringSelection(sw.toString());
        Clipboard cb = tk.getSystemClipboard();
        cb.setContents(textSelection, null);
    }

    protected void onOpen(ImageResource imageResource) {
        try {
            URI uri = imageResource.getURI();
            if (uri != null && "file".equals(uri.getScheme())) {
                File file = new File(uri);
                DesktopUtilities.open(file);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }
}

