/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ManageFavoriteDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/managefavoritesdialog";
    private CharacterData characterData;
    private PartsSetListTableModel partsSetListModel;
    private JTable partsSetList;
    private FavoriteManageCallback callback;
    private Action actSelect;
    private Action actDelete;
    private Action actRename;

    public ManageFavoriteDialog(JFrame parent, CharacterData characterData) {
        super((Frame)parent, false);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManageFavoriteDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("manageFavorites"));
        this.characterData = characterData;
        characterData.getPartsSets();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.partsSetListModel = new PartsSetListTableModel();
        this.partsSetList = new JTable(this.partsSetListModel);
        this.partsSetList.setRowSelectionAllowed(true);
        this.partsSetList.setSelectionMode(2);
        this.partsSetList.setRowHeight((int)((double)this.partsSetList.getFont().getSize() * 1.2));
        this.partsSetList.setTableHeader(null);
        this.partsSetList.getColumnModel().getColumn(1).setMaxWidth(150);
        this.partsSetList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageFavoriteDialog.this.updateButtonUI();
            }
        });
        this.actSelect = new AbstractAction(strings.getProperty("select")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onSelect();
            }
        };
        this.actDelete = new AbstractAction(strings.getProperty("remove")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onDelete();
            }
        };
        this.actRename = new AbstractAction(strings.getProperty("rename")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onRename();
            }
        };
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        buttonsPanel.setLayout(gb);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        buttonsPanel.add((Component)new JButton(this.actSelect), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        buttonsPanel.add((Component)new JButton(this.actDelete), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        buttonsPanel.add((Component)new JButton(this.actRename), gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        buttonsPanel.add(Box.createGlue(), gbc);
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        panel2.setLayout(new BorderLayout());
        AbstractAction actCancel = new AbstractAction(strings.getProperty("close")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoriteDialog.this.onClose();
            }
        };
        JButton btnClose = new JButton(actCancel);
        panel2.add((Component)btnClose, "East");
        JScrollPane scr = new JScrollPane(this.partsSetList);
        scr.setBorder(BorderFactory.createEtchedBorder());
        scr.setPreferredSize(new Dimension(300, 150));
        contentPane.add((Component)scr, "Center");
        contentPane.add((Component)buttonsPanel, "East");
        contentPane.add((Component)panel2, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnClose);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(127, 0), "deleteFav");
        im.put(KeyStroke.getKeyStroke(27, 0), "closeManageFavoriteDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeManageFavoriteDialog");
        am.put("deleteFav", this.actDelete);
        am.put("closeManageFavoriteDialog", actCancel);
        Dimension dim = new Dimension(400, 500);
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        if (scaleSupport != null) {
            dim = scaleSupport.manualScaled(dim);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(this.actSelect));
        popupMenu.add(new JMenuItem(this.actRename));
        popupMenu.add(new JMenuItem(this.actDelete));
        this.partsSetList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ManageFavoriteDialog.this.onSelect();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point pt = e.getPoint();
                    int rowIndex = ManageFavoriteDialog.this.partsSetList.rowAtPoint(pt);
                    if (rowIndex >= 0) {
                        int[] selrows = ManageFavoriteDialog.this.partsSetList.getSelectedRows();
                        Arrays.sort(selrows);
                        if (Arrays.binarySearch(selrows, rowIndex) < 0) {
                            ListSelectionModel selModel = ManageFavoriteDialog.this.partsSetList.getSelectionModel();
                            selModel.setSelectionInterval(rowIndex, rowIndex);
                        }
                    }
                }
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(ManageFavoriteDialog.this.partsSetList, e.getX(), e.getY());
                }
            }
        });
        this.initListModel();
        this.updateButtonUI();
    }

    public void initListModel() {
        ArrayList<PartsSet> partssets = new ArrayList<PartsSet>();
        for (PartsSet partsset : this.characterData.getPartsSets().values()) {
            partssets.add(partsset);
        }
        Collections.sort(partssets, PartsSet.DEFAULT_COMPARATOR);
        this.partsSetListModel.setPartsSetList(partssets);
    }

    protected void updateButtonUI() {
        int[] rows = this.partsSetList.getSelectedRows();
        this.actSelect.setEnabled(rows.length == 1);
        this.actRename.setEnabled(rows.length == 1);
        this.actDelete.setEnabled(rows.length >= 1);
    }

    protected List<PartsSet> getSelectedPartsSet() {
        int[] rows;
        ArrayList<PartsSet> selectedPartsSet = new ArrayList<PartsSet>();
        for (int row : rows = this.partsSetList.getSelectedRows()) {
            PartsSet partsSet = this.partsSetListModel.getRow(row);
            selectedPartsSet.add(partsSet);
        }
        return selectedPartsSet;
    }

    protected void onDelete() {
        List<PartsSet> removePartsSet = this.getSelectedPartsSet();
        if (removePartsSet.isEmpty() || this.callback == null) {
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String msg = strings.getProperty("favorite.remove.confirm");
        JOptionPane optionPane = new JOptionPane(msg, 3, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public void selectInitialValue() {
                String noBtnCaption = UIManager.getString("OptionPane.noButtonText");
                for (JButton btn : UIHelper.getInstance().getDescendantOfClass(JButton.class, this)) {
                    if (!btn.getText().equals(noBtnCaption)) continue;
                    btn.requestFocus();
                }
            }
        };
        JDialog dlg = optionPane.createDialog(this, strings.getProperty("confirm.remove"));
        dlg.setVisible(true);
        Object ret = optionPane.getValue();
        if (ret == null || ((Number)ret).intValue() != 0) {
            return;
        }
        boolean dirty = false;
        boolean deletePreset = false;
        Map<String, PartsSet> partsSetMap = this.characterData.getPartsSets();
        for (PartsSet partsSet : removePartsSet) {
            Iterator<Map.Entry<String, PartsSet>> ite = partsSetMap.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, PartsSet> entry = ite.next();
                PartsSet target = entry.getValue();
                if (target != partsSet) continue;
                dirty = true;
                if (target.isPresetParts()) {
                    deletePreset = true;
                }
                ite.remove();
            }
        }
        if (dirty) {
            this.callback.updateFavorites(this.characterData, deletePreset);
            this.initListModel();
        }
    }

    protected void onRename() {
        int row = this.partsSetList.getSelectedRow();
        if (row < 0 || this.callback == null) {
            return;
        }
        PartsSet partsSet = this.partsSetListModel.getRow(row);
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String localizedName = JOptionPane.showInputDialog(this, strings.getProperty("inputName"), partsSet.getLocalizedName());
        if (localizedName != null) {
            partsSet.setLocalizedName(localizedName);
            this.callback.updateFavorites(this.characterData, partsSet.isPresetParts());
            this.initListModel();
        }
    }

    protected void onSelect() {
        int row = this.partsSetList.getSelectedRow();
        if (row < 0) {
            return;
        }
        PartsSet partsSet = this.partsSetListModel.getRow(row);
        if (this.callback != null) {
            this.callback.selectFavorites(partsSet);
        }
    }

    protected void onClose() {
        this.dispose();
    }

    public void setFavoriteManageCallback(FavoriteManageCallback callback) {
        this.callback = callback;
    }

    public FavoriteManageCallback getFavoriteManageCallback() {
        return this.callback;
    }

    public static interface FavoriteManageCallback {
        public void selectFavorites(PartsSet var1);

        public void updateFavorites(CharacterData var1, boolean var2);
    }

    public static class PartsSetListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3012538368342673506L;
        private List<PartsSet> partsSetList = Collections.emptyList();
        private static Columns[] columns = Columns.values();

        @Override
        public int getColumnCount() {
            return columns.length;
        }

        @Override
        public int getRowCount() {
            return this.partsSetList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PartsSet partsSet = this.getRow(rowIndex);
            return columns[columnIndex].getValue(partsSet);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columns[columnIndex].getColumnClass();
        }

        @Override
        public String getColumnName(int column) {
            return columns[column].getColumnName();
        }

        public PartsSet getRow(int rowIndex) {
            return this.partsSetList.get(rowIndex);
        }

        public void updateRow(int rowIndex, PartsSet partsSet) {
            this.partsSetList.set(rowIndex, partsSet);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public List<PartsSet> getPartsSetList() {
            return new ArrayList<PartsSet>(this.partsSetList);
        }

        public void setPartsSetList(List<PartsSet> partsSetList) {
            if (partsSetList == null) {
                partsSetList = Collections.emptyList();
            }
            this.partsSetList = new ArrayList<PartsSet>(partsSetList);
            this.fireTableDataChanged();
        }

        private static enum Columns {
            DISPLAY_NAME("Name"){

                @Override
                public Object getValue(PartsSet partsSet) {
                    if (partsSet != null) {
                        return partsSet.getLocalizedName();
                    }
                    return null;
                }
            }
            ,
            IS_PRESET("Type"){

                @Override
                public Object getValue(PartsSet partsSet) {
                    if (partsSet != null) {
                        return partsSet.isPresetParts() ? "Preset" : "Favorites";
                    }
                    return null;
                }
            };

            private String columnName;

            private Columns(String columnName) {
                this.columnName = columnName;
            }

            public Class<?> getColumnClass() {
                return String.class;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public abstract Object getValue(PartsSet var1);
        }
    }
}

