/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class ProfileSelectorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<CharacterData> rows = Collections.emptyList();

    ProfileSelectorTableModel() {
    }

    public void setModel(List<CharacterData> rows) {
        if (rows == null) {
            throw new IllegalArgumentException();
        }
        this.rows = new ArrayList<CharacterData>(rows);
        this.fireTableDataChanged();
    }

    public void add(CharacterData cd) {
        if (cd == null) {
            throw new IllegalArgumentException();
        }
        this.rows.add(cd);
        int lastRow = this.rows.size() - 1;
        this.fireTableRowsInserted(lastRow, lastRow);
    }

    public void set(int selRow, CharacterData cd) {
        this.rows.set(selRow, cd);
        this.fireTableRowsDeleted(selRow, selRow);
    }

    public void remove(int selRow) {
        this.rows.remove(selRow);
        this.fireTableRowsDeleted(selRow, selRow);
    }

    public List<CharacterData> getModel() {
        return this.rows;
    }

    public CharacterData getRow(int rowIndex) {
        CharacterData cd = this.rows.get(rowIndex);
        return cd;
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public void adjustColumnModel(TableColumnModel columnModel, double scale) {
        Columns[] columns = Columns.values();
        for (int idx = 0; idx < columns.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth((int)((double)columns[idx].getWidth() * scale));
        }
    }

    @Override
    public String getColumnName(int column) {
        return Columns.values()[column].getDisplayName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CharacterData cd = this.getRow(rowIndex);
        Columns column = Columns.values()[columnIndex];
        return column.getValue(cd);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private static enum Columns {
        NAME("profile.column.name"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getName();
            }
        }
        ,
        ID("profile.column.id"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getId();
            }
        }
        ,
        REVISION("profile.column.revision"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getRev();
            }
        }
        ,
        CANVAS_SIZE("profile.column.canvasSize"){

            @Override
            public String getValue(CharacterData cd) {
                Dimension siz = cd.getImageSize();
                if (siz != null) {
                    return siz.width + "x" + siz.height;
                }
                return "";
            }
        }
        ,
        DESCRIPTION("profile.column.description"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getDescription();
            }
        }
        ,
        AUTHOR("profile.column.author"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getAuthor();
            }
        }
        ,
        LOCATION("profile.column.location"){

            @Override
            public String getValue(CharacterData cd) {
                return cd.getDocBase().toString();
            }
        };

        private final String columnName;
        private String displayName;
        private int width;

        private Columns(String columnName) {
            this.columnName = columnName;
        }

        public String getDisplayName() {
            this.loadProperty();
            return this.displayName;
        }

        public int getWidth() {
            this.loadProperty();
            return this.width;
        }

        private void loadProperty() {
            if (this.displayName != null) {
                return;
            }
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/profileselectordialog");
            this.displayName = strings.getProperty(this.columnName);
            this.width = Integer.parseInt(strings.getProperty(this.columnName + ".width"));
        }

        public abstract String getValue(CharacterData var1);
    }
}

