/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.ui.URLTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableColumnModel;

class URLTableModel
extends AbstractTableModelWithComboBoxModel<URLTableRow> {
    private static final long serialVersionUID = 7075478118793390224L;
    private static final String[] COLUMN_NAMES = new String[]{"\u4f5c\u8005", "URL"};
    private static final int[] COLUMN_WIDTHS = new int[]{100, 300};

    URLTableModel() {
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        URLTableRow row = (URLTableRow)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getAuthor();
            }
            case 1: {
                return row.getDownloadURL();
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public void adjustColumnModel(TableColumnModel columnModel, double scale) {
        for (int idx = 0; idx < COLUMN_WIDTHS.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth((int)((double)COLUMN_WIDTHS[idx] * scale));
        }
    }

    public void initModel(CharacterData characterData) {
        this.clear();
        HashMap<String, String> downloadUrlsMap = new HashMap<String, String>();
        if (characterData != null) {
            for (PartsCategory partsCategory : characterData.getPartsCategories()) {
                for (Map.Entry<PartsIdentifier, PartsSpec> entry : characterData.getPartsSpecMap(partsCategory).entrySet()) {
                    PartsSpec partsSpec = entry.getValue();
                    String author = partsSpec.getAuthor();
                    String downloadURL = partsSpec.getDownloadURL();
                    if (downloadURL == null || downloadURL.trim().length() <= 0) continue;
                    if (author == null || author.trim().length() == 0) {
                        author = "";
                    }
                    downloadUrlsMap.put(downloadURL, author);
                }
            }
        }
        for (Map.Entry entry : downloadUrlsMap.entrySet()) {
            String downloadURL = (String)entry.getKey();
            String author = (String)entry.getValue();
            URLTableRow row = new URLTableRow();
            row.setDownloadURL(downloadURL);
            row.setAuthor(author);
            this.addRow(row);
        }
        Collections.sort(this.elements, new Comparator<URLTableRow>(){

            @Override
            public int compare(URLTableRow o1, URLTableRow o2) {
                int ret = o1.getAuthor().compareTo(o2.getAuthor());
                if (ret == 0) {
                    ret = o1.getDownloadURL().compareTo(o2.getDownloadURL());
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }
}

