/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.Serializable;
import twitter4j.FilterQuery;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.TwitterBase;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.Authorization;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.logging.Logger;

public final class TwitterStream
extends TwitterBase
implements Serializable {
    private final HttpClientWrapper http;
    private static final Logger logger = Logger.getLogger(TwitterStream.class);
    private StatusListener statusListener;
    private StreamHandlingThread handler = null;
    private static final long serialVersionUID = -762817147320767897L;
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;

    public TwitterStream() {
        super(ConfigurationContext.getInstance());
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    public TwitterStream(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    public TwitterStream(String screenName, String password, StatusListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.statusListener = listener;
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
        this.ensureBasicEnabled();
    }

    TwitterStream(Configuration conf, Authorization auth, StatusListener listener) {
        super(conf, auth);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(conf));
        this.statusListener = listener;
        this.ensureBasicEnabled();
    }

    public void firehose(final int count) {
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFirehoseStream(count);
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/firehose.json", new HttpParameter[]{new HttpParameter("count", String.valueOf(count))}, this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void links(final int count) {
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getLinksStream(count);
            }
        });
    }

    public StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/links.json", new HttpParameter[]{new HttpParameter("count", String.valueOf(count))}, this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void retweet() {
        this.ensureBasicEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getRetweetStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[0], this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void sample() {
        this.ensureBasicEnabled();
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getSampleStream();
            }
        });
    }

    public StatusStream getSampleStream() throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json", this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(final FilterQuery query) throws TwitterException {
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(query);
            }
        });
    }

    public StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureBasicEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", query.asHttpParameterArray(), this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(final int count, final int[] follow, final String[] track) {
        this.startHandler(new StreamHandlingThread(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(count, follow, track);
            }
        });
    }

    public StatusStream getFilterStream(int count, int[] follow, String[] track) throws TwitterException {
        return this.getFilterStream(new FilterQuery(count, follow, track, null));
    }

    private synchronized void startHandler(StreamHandlingThread handler) {
        this.cleanup();
        if (null == this.statusListener) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanup() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    abstract class StreamHandlingThread
    extends Thread {
        StatusStream stream;
        private static final String NAME = "Twitter Stream Handling Thread";
        private boolean closed;

        StreamHandlingThread() {
            super("Twitter Stream Handling Thread[initializing]");
            this.stream = null;
            this.closed = false;
        }

        public void run() {
            int timeToSleep = 0;
            while (!this.closed) {
                try {
                    if (this.closed || null != this.stream) continue;
                    this.setStatus("[Establishing connection]");
                    this.stream = this.getStream();
                    timeToSleep = 0;
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        this.stream.next(TwitterStream.this.statusListener);
                    }
                }
                catch (TwitterException te) {
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        timeToSleep = te.getStatusCode() > 200 ? 10000 : 250;
                    }
                    if (!this.closed) {
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    TwitterStream.this.statusListener.onException(te);
                }
            }
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[Disposing thread]");
            this.closed = true;
        }

        private void setStatus(String message) {
            String actualMessage = NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }
}

