/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol.proto;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPC_ServiceDescriptor
extends ProtocolMessage<RPC_ServiceDescriptor> {
    private static final long serialVersionUID = 1L;
    private byte[] filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private byte[] name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private byte[] full_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private double failure_detection_delay_ = 0.0;
    private List<Method> method_ = null;
    private UninterpretedTags uninterpreted;
    private int optional_0_;
    public static final RPC_ServiceDescriptor IMMUTABLE_DEFAULT_INSTANCE = new RPC_ServiceDescriptor(){
        private static final long serialVersionUID = 1L;

        public RPC_ServiceDescriptor clearFilename() {
            return this;
        }

        public RPC_ServiceDescriptor setFilenameAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setFilename(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setFilename(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor clearName() {
            return this;
        }

        public RPC_ServiceDescriptor setNameAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setName(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setName(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor clearFullName() {
            return this;
        }

        public RPC_ServiceDescriptor setFullNameAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setFullName(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor setFullName(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor clearFailureDetectionDelay() {
            return this;
        }

        public RPC_ServiceDescriptor setFailureDetectionDelay(double x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public RPC_ServiceDescriptor clearMethod() {
            return this;
        }

        public Method getMutableMethod(int i) {
            return (Method)ProtocolSupport.unsupportedOperation();
        }

        public Method addMethod() {
            return (Method)ProtocolSupport.unsupportedOperation();
        }

        public Method addMethod(Method v) {
            return (Method)ProtocolSupport.unsupportedOperation();
        }

        public Method insertMethod(int i, Method v) {
            return (Method)ProtocolSupport.unsupportedOperation();
        }

        public Method removeMethod(int i) {
            return (Method)ProtocolSupport.unsupportedOperation();
        }

        public RPC_ServiceDescriptor mergeFrom(RPC_ServiceDescriptor that) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean merge(ProtocolSource source) {
            ProtocolSupport.unsupportedOperation();
            return false;
        }

        public RPC_ServiceDescriptor freeze() {
            return this;
        }

        public RPC_ServiceDescriptor unfreeze() {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean isFrozen() {
            return true;
        }
    };
    public static final int kfilename = 1;
    public static final int kname = 2;
    public static final int kfull_name = 18;
    public static final int kfailure_detection_delay = 16;
    public static final int kMethodGroup = 3;
    public static final int kMethodname = 4;
    public static final int kMethodargument_type = 5;
    public static final int kMethodresult_type = 6;
    public static final int kMethodstream_type = 14;
    public static final int kMethodprotocol = 7;
    public static final int kMethoddeadline = 8;
    public static final int kMethodduplicate_suppression = 9;
    public static final int kMethodfail_fast = 10;
    public static final int kMethodclient_logging = 11;
    public static final int kMethodserver_logging = 12;
    public static final int kMethodsecurity_level = 13;
    public static final int kMethodresponse_format = 15;
    public static final int kMethodrequest_format = 17;
    public static final String[] text = new String[19];
    public static final int[] types;
    public static final String style = "";
    public static final String style_content_type = "";

    public final byte[] getFilenameAsBytes() {
        return this.filename_;
    }

    public final boolean hasFilename() {
        return (this.optional_0_ & 1) != 0;
    }

    public RPC_ServiceDescriptor clearFilename() {
        this.optional_0_ &= 0xFFFFFFFE;
        this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public RPC_ServiceDescriptor setFilenameAsBytes(byte[] x) {
        this.optional_0_ |= 1;
        this.filename_ = x;
        return this;
    }

    public final String getFilename() {
        return ProtocolSupport.toStringUtf8(this.filename_);
    }

    public RPC_ServiceDescriptor setFilename(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 1;
        this.filename_ = ProtocolSupport.toBytesUtf8(v);
        return this;
    }

    public final String getFilename(Charset cs) {
        return ProtocolSupport.toString(this.filename_, cs);
    }

    public RPC_ServiceDescriptor setFilename(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 1;
        this.filename_ = ProtocolSupport.toBytes(v, cs);
        return this;
    }

    public final byte[] getNameAsBytes() {
        return this.name_;
    }

    public final boolean hasName() {
        return (this.optional_0_ & 2) != 0;
    }

    public RPC_ServiceDescriptor clearName() {
        this.optional_0_ &= 0xFFFFFFFD;
        this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public RPC_ServiceDescriptor setNameAsBytes(byte[] x) {
        this.optional_0_ |= 2;
        this.name_ = x;
        return this;
    }

    public final String getName() {
        return ProtocolSupport.toStringUtf8(this.name_);
    }

    public RPC_ServiceDescriptor setName(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.name_ = ProtocolSupport.toBytesUtf8(v);
        return this;
    }

    public final String getName(Charset cs) {
        return ProtocolSupport.toString(this.name_, cs);
    }

    public RPC_ServiceDescriptor setName(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.name_ = ProtocolSupport.toBytes(v, cs);
        return this;
    }

    public final byte[] getFullNameAsBytes() {
        return this.full_name_;
    }

    public final boolean hasFullName() {
        return (this.optional_0_ & 4) != 0;
    }

    public RPC_ServiceDescriptor clearFullName() {
        this.optional_0_ &= 0xFFFFFFFB;
        this.full_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public RPC_ServiceDescriptor setFullNameAsBytes(byte[] x) {
        this.optional_0_ |= 4;
        this.full_name_ = x;
        return this;
    }

    public final String getFullName() {
        return ProtocolSupport.toStringUtf8(this.full_name_);
    }

    public RPC_ServiceDescriptor setFullName(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 4;
        this.full_name_ = ProtocolSupport.toBytesUtf8(v);
        return this;
    }

    public final String getFullName(Charset cs) {
        return ProtocolSupport.toString(this.full_name_, cs);
    }

    public RPC_ServiceDescriptor setFullName(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 4;
        this.full_name_ = ProtocolSupport.toBytes(v, cs);
        return this;
    }

    public final double getFailureDetectionDelay() {
        return this.failure_detection_delay_;
    }

    public final boolean hasFailureDetectionDelay() {
        return (this.optional_0_ & 8) != 0;
    }

    public RPC_ServiceDescriptor clearFailureDetectionDelay() {
        this.optional_0_ &= 0xFFFFFFF7;
        this.failure_detection_delay_ = 0.0;
        return this;
    }

    public RPC_ServiceDescriptor setFailureDetectionDelay(double x) {
        this.optional_0_ |= 8;
        this.failure_detection_delay_ = x;
        return this;
    }

    public final int methodSize() {
        return this.method_ != null ? this.method_.size() : 0;
    }

    public final Method getMethod(int i) {
        assert (i >= 0 && i < (this.method_ != null ? this.method_.size() : 0));
        return this.method_.get(i);
    }

    public RPC_ServiceDescriptor clearMethod() {
        if (this.method_ != null) {
            this.method_.clear();
        }
        return this;
    }

    public Method getMutableMethod(int i) {
        assert (i >= 0 && this.method_ != null && i < this.method_.size());
        return this.method_.get(i);
    }

    public Method addMethod() {
        Method v = new Method();
        if (this.method_ == null) {
            this.method_ = new ArrayList<Method>(4);
        }
        this.method_.add(v);
        return v;
    }

    public Method addMethod(Method v) {
        if (this.method_ == null) {
            this.method_ = new ArrayList<Method>(4);
        }
        this.method_.add(v);
        return v;
    }

    public Method insertMethod(int i, Method v) {
        if (this.method_ == null) {
            this.method_ = new ArrayList<Method>(4);
        }
        this.method_.add(i, v);
        return v;
    }

    public Method removeMethod(int i) {
        return this.method_.remove(i);
    }

    public final Iterator<Method> methodIterator() {
        if (this.method_ == null) {
            return ProtocolSupport.emptyIterator();
        }
        return this.method_.iterator();
    }

    public final List<Method> methods() {
        return ProtocolSupport.unmodifiableList(this.method_);
    }

    public final List<Method> mutableMethods() {
        if (this.method_ == null) {
            this.method_ = new ArrayList<Method>(4);
        }
        return this.method_;
    }

    @Override
    public RPC_ServiceDescriptor mergeFrom(RPC_ServiceDescriptor that) {
        assert (that != this);
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if ((that_t0 & 1) != 0) {
            this_t0 |= 1;
            this.filename_ = that.filename_;
        }
        if ((that_t0 & 2) != 0) {
            this_t0 |= 2;
            this.name_ = that.name_;
        }
        if ((that_t0 & 4) != 0) {
            this_t0 |= 4;
            this.full_name_ = that.full_name_;
        }
        if ((that_t0 & 8) != 0) {
            this_t0 |= 8;
            this.failure_detection_delay_ = that.failure_detection_delay_;
        }
        if (that.method_ != null) {
            for (Method v : that.method_) {
                this.addMethod().mergeFrom(v);
            }
        }
        if ((that_t0 & 0x10) != 0) {
            this_t0 |= 0x10;
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            this.uninterpreted.putAll(that.uninterpreted);
        }
        this.optional_0_ = this_t0;
        return this;
    }

    @Override
    public boolean equalsIgnoreUninterpreted(RPC_ServiceDescriptor that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(RPC_ServiceDescriptor that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(RPC_ServiceDescriptor that, boolean ignoreUninterpreted) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFEF) != (that_t0 & 0xFFFFFFEF)) {
            return false;
        }
        if ((this_t0 & 1) != 0 && !Arrays.equals(this.filename_, that.filename_)) {
            return false;
        }
        if ((this_t0 & 2) != 0 && !Arrays.equals(this.name_, that.name_)) {
            return false;
        }
        if ((this_t0 & 4) != 0 && !Arrays.equals(this.full_name_, that.full_name_)) {
            return false;
        }
        if ((this_t0 & 8) != 0 && this.failure_detection_delay_ != that.failure_detection_delay_) {
            return false;
        }
        int n = this.method_ != null ? this.method_.size() : 0;
        if (n != (that.method_ != null ? that.method_.size() : 0)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.method_.get(i).equals(that.method_.get(i), ignoreUninterpreted)) continue;
            return false;
        }
        return ignoreUninterpreted || (this_t0 & 0x10) == 0 || this.uninterpreted.equals(that.uninterpreted);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof RPC_ServiceDescriptor && this.equals((RPC_ServiceDescriptor)that);
    }

    @Override
    public int hashCode() {
        int n;
        int hash = -1296297482;
        int this_t0 = this.optional_0_;
        hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.filename_) : -113);
        hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.name_) : -113);
        hash *= 31;
        int n2 = n = this.method_ != null ? this.method_.size() : 0;
        for (int i = 0; i < n; ++i) {
            hash = hash * 31 + this.method_.get(i).hashCode();
        }
        hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.hashCode(this.failure_detection_delay_) : -113);
        hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.full_name_) : -113);
        if ((this_t0 & 0x10) != 0) {
            hash = hash * 31 + this.uninterpreted.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isInitialized() {
        int this_t0 = this.optional_0_;
        if ((this_t0 & 3) != 3) {
            if ((this_t0 & 1) == 0) {
                return false;
            }
            return false;
        }
        if (this.method_ != null) {
            for (Method v : this.method_) {
                if (v.isInitialized()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int encodingSize() {
        int n = 2 + Protocol.stringSize(this.filename_.length) + Protocol.stringSize(this.name_.length);
        int m = this.method_ != null ? this.method_.size() : 0;
        n += m;
        for (int i = 0; i < m; ++i) {
            n += this.method_.get(i).encodingSize();
        }
        int this_t0 = this.optional_0_;
        if ((this_t0 & 0xC) != 0) {
            if ((this_t0 & 4) != 0) {
                n += 2 + Protocol.stringSize(this.full_name_.length);
            }
            if ((this_t0 & 8) != 0) {
                n += 10;
            }
        }
        return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.encodingSize() : n;
    }

    @Override
    public int maxEncodingSize() {
        int n = 22 + this.filename_.length + this.name_.length;
        int m = this.method_ != null ? this.method_.size() : 0;
        n += m;
        for (int i = 0; i < m; ++i) {
            n += this.method_.get(i).maxEncodingSize();
        }
        int this_t0 = this.optional_0_;
        if ((this_t0 & 4) != 0) {
            n += 7 + this.full_name_.length;
        }
        return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
    }

    @Override
    public MessageAppender getMessageAppender() {
        if (this.uninterpreted == null) {
            this.optional_0_ |= 0x10;
            this.uninterpreted = new UninterpretedTags();
        }
        return this.uninterpreted;
    }

    @Override
    public void clear() {
        this.optional_0_ = 0;
        this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.full_name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.failure_detection_delay_ = 0.0;
        if (this.method_ != null) {
            this.method_.clear();
        }
        this.uninterpreted = null;
    }

    @Override
    public RPC_ServiceDescriptor newInstance() {
        return new RPC_ServiceDescriptor();
    }

    @Override
    public ProtocolType getProtocolType() {
        return StaticHolder.protocolType;
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        int m;
        sink.putByte((byte)10);
        sink.putPrefixedData(this.filename_);
        sink.putByte((byte)18);
        sink.putPrefixedData(this.name_);
        int n = m = this.method_ != null ? this.method_.size() : 0;
        for (int i = 0; i < m; ++i) {
            Method v = this.method_.get(i);
            sink.putByte((byte)27);
            v.outputTo(sink);
        }
        int this_t0 = this.optional_0_;
        if ((this_t0 & 8) != 0) {
            sink.putByte((byte)-127);
            sink.putByte((byte)1);
            sink.putDouble(this.failure_detection_delay_);
        }
        if ((this_t0 & 4) != 0) {
            sink.putByte((byte)-110);
            sink.putByte((byte)1);
            sink.putPrefixedData(this.full_name_);
        }
        if ((this_t0 & 0x10) != 0) {
            this.uninterpreted.put(sink);
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        boolean result = true;
        int this_t0 = this.optional_0_;
        block8: while (source.hasRemaining()) {
            int tt = source.getVarInt();
            switch (tt) {
                case 0: {
                    result = false;
                    break block8;
                }
                case 10: {
                    this.filename_ = source.getPrefixedData();
                    this_t0 |= 1;
                    continue block8;
                }
                case 18: {
                    this.name_ = source.getPrefixedData();
                    this_t0 |= 2;
                    continue block8;
                }
                case 27: {
                    if (this.addMethod().merge(source)) continue block8;
                    result = false;
                    break block8;
                }
                case 129: {
                    this.failure_detection_delay_ = source.getDouble();
                    this_t0 |= 8;
                    continue block8;
                }
                case 146: {
                    this.full_name_ = source.getPrefixedData();
                    this_t0 |= 4;
                    continue block8;
                }
                default: {
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.put(tt, source.getUninterpreted(tt));
                    this_t0 |= 0x10;
                    continue block8;
                }
            }
        }
        this.optional_0_ = this_t0;
        return result;
    }

    @Override
    public RPC_ServiceDescriptor getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public static final RPC_ServiceDescriptor getDefaultInstance() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    @Override
    public RPC_ServiceDescriptor freeze() {
        this.filename_ = ProtocolSupport.freezeString(this.filename_);
        this.name_ = ProtocolSupport.freezeString(this.name_);
        this.full_name_ = ProtocolSupport.freezeString(this.full_name_);
        this.method_ = ProtocolSupport.freezeMessages(this.method_);
        return this;
    }

    @Override
    public RPC_ServiceDescriptor unfreeze() {
        this.method_ = ProtocolSupport.unfreezeMessages(this.method_);
        return this;
    }

    @Override
    public boolean isFrozen() {
        return ProtocolSupport.isFrozenMessages(this.method_);
    }

    static {
        RPC_ServiceDescriptor.text[0] = "ErrorCode";
        RPC_ServiceDescriptor.text[1] = "filename";
        RPC_ServiceDescriptor.text[2] = "name";
        RPC_ServiceDescriptor.text[3] = "Method";
        RPC_ServiceDescriptor.text[4] = "name";
        RPC_ServiceDescriptor.text[5] = "argument_type";
        RPC_ServiceDescriptor.text[6] = "result_type";
        RPC_ServiceDescriptor.text[7] = "protocol";
        RPC_ServiceDescriptor.text[8] = "deadline";
        RPC_ServiceDescriptor.text[9] = "duplicate_suppression";
        RPC_ServiceDescriptor.text[10] = "fail_fast";
        RPC_ServiceDescriptor.text[11] = "client_logging";
        RPC_ServiceDescriptor.text[12] = "server_logging";
        RPC_ServiceDescriptor.text[13] = "security_level";
        RPC_ServiceDescriptor.text[14] = "stream_type";
        RPC_ServiceDescriptor.text[15] = "response_format";
        RPC_ServiceDescriptor.text[16] = "failure_detection_delay";
        RPC_ServiceDescriptor.text[17] = "request_format";
        RPC_ServiceDescriptor.text[18] = "full_name";
        types = new int[19];
        Arrays.fill(types, 6);
        RPC_ServiceDescriptor.types[0] = 0;
        RPC_ServiceDescriptor.types[1] = 2;
        RPC_ServiceDescriptor.types[2] = 2;
        RPC_ServiceDescriptor.types[3] = 3;
        RPC_ServiceDescriptor.types[4] = 2;
        RPC_ServiceDescriptor.types[5] = 2;
        RPC_ServiceDescriptor.types[6] = 2;
        RPC_ServiceDescriptor.types[7] = 2;
        RPC_ServiceDescriptor.types[8] = 1;
        RPC_ServiceDescriptor.types[9] = 0;
        RPC_ServiceDescriptor.types[10] = 0;
        RPC_ServiceDescriptor.types[11] = 0;
        RPC_ServiceDescriptor.types[12] = 0;
        RPC_ServiceDescriptor.types[13] = 2;
        RPC_ServiceDescriptor.types[14] = 2;
        RPC_ServiceDescriptor.types[15] = 2;
        RPC_ServiceDescriptor.types[16] = 1;
        RPC_ServiceDescriptor.types[17] = 2;
        RPC_ServiceDescriptor.types[18] = 2;
    }

    private static class StaticHolder {
        private static final ProtocolType protocolType = new ProtocolType(RPC_ServiceDescriptor.class, "Z\u001cnet/proto/protocoltype.proto\n\u0015RPC_ServiceDescriptor\u0013\u001a\bfilename \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0004name \u0002(\u00020\t8\u0002\u0014\u0013\u001a\tfull_name \u0012(\u00020\t8\u0001\u0014\u0013\u001a\u0017failure_detection_delay \u0010(\u00010\u00018\u0001\u0014\u0013\u001a\u0006Method \u0003(\u00030\n8\u0003\u0014\u0013\u001a\u000bMethod.name \u0004(\u00020\t8\u0002`\u0004\u0014\u0013\u001a\u0014Method.argument_type \u0005(\u00020\t8\u0002`\u0004\u0014\u0013\u001a\u0012Method.result_type \u0006(\u00020\t8\u0002`\u0004\u0014\u0013\u001a\u0012Method.stream_type \u000e(\u00020\t8\u0001`\u0004\u0014\u0013\u001a\u000fMethod.protocol \u0007(\u00020\t8\u0001`\u0004\u0014\u0013\u001a\u000fMethod.deadline \b(\u00010\u00018\u0001`\u0004\u0014\u0013\u001a\u001cMethod.duplicate_suppression \t(\u00000\b8\u0001`\u0004\u0014\u0013\u001a\u0010Method.fail_fast \n(\u00000\b8\u0001`\u0004\u0014\u0013\u001a\u0015Method.client_logging \u000b(\u00000\u00058\u0001`\u0004\u0014\u0013\u001a\u0015Method.server_logging \f(\u00000\u00058\u0001`\u0004\u0014\u0013\u001a\u0015Method.security_level \r(\u00020\t8\u0001`\u0004\u0014\u0013\u001a\u0016Method.response_format \u000f(\u00020\t8\u0001`\u0004\u0014\u0013\u001a\u0015Method.request_format \u0011(\u00020\t8\u0001`\u0004\u0014", new ProtocolType.FieldType("filename", "filename", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("name", "name", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("full_name", "full_name", 18, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("failure_detection_delay", "failure_detection_delay", 16, 3, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Method", "method", 3, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Method.class));

        private StaticHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Method
    extends ProtocolMessage<Method> {
        private static final long serialVersionUID = 1L;
        private byte[] name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] argument_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] result_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] stream_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] protocol_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private double deadline_ = 0.0;
        private boolean duplicate_suppression_ = false;
        private boolean fail_fast_ = false;
        private int client_logging_ = 0;
        private int server_logging_ = 0;
        private byte[] security_level_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] response_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] request_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Method IMMUTABLE_DEFAULT_INSTANCE = new Method(){
            private static final long serialVersionUID = 1L;

            public Method clearName() {
                return this;
            }

            public Method setNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearArgumentType() {
                return this;
            }

            public Method setArgumentTypeAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setArgumentType(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setArgumentType(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearResultType() {
                return this;
            }

            public Method setResultTypeAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setResultType(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setResultType(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearStreamType() {
                return this;
            }

            public Method setStreamTypeAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setStreamType(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setStreamType(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearProtocol() {
                return this;
            }

            public Method setProtocolAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setProtocol(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setProtocol(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearDeadline() {
                return this;
            }

            public Method setDeadline(double x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearDuplicateSuppression() {
                return this;
            }

            public Method setDuplicateSuppression(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearFailFast() {
                return this;
            }

            public Method setFailFast(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearClientLogging() {
                return this;
            }

            public Method setClientLogging(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearServerLogging() {
                return this;
            }

            public Method setServerLogging(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearSecurityLevel() {
                return this;
            }

            public Method setSecurityLevelAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setSecurityLevel(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setSecurityLevel(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearResponseFormat() {
                return this;
            }

            public Method setResponseFormatAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setResponseFormat(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setResponseFormat(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method clearRequestFormat() {
                return this;
            }

            public Method setRequestFormatAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setRequestFormat(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method setRequestFormat(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Method mergeFrom(Method that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Method freeze() {
                return this;
            }

            public Method unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };

        public final byte[] getNameAsBytes() {
            return this.name_;
        }

        public final boolean hasName() {
            return (this.optional_0_ & 1) != 0;
        }

        public Method clearName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.name_ = x;
            return this;
        }

        public final String getName() {
            return ProtocolSupport.toStringUtf8(this.name_);
        }

        public Method setName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getName(Charset cs) {
            return ProtocolSupport.toString(this.name_, cs);
        }

        public Method setName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getArgumentTypeAsBytes() {
            return this.argument_type_;
        }

        public final boolean hasArgumentType() {
            return (this.optional_0_ & 2) != 0;
        }

        public Method clearArgumentType() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.argument_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setArgumentTypeAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.argument_type_ = x;
            return this;
        }

        public final String getArgumentType() {
            return ProtocolSupport.toStringUtf8(this.argument_type_);
        }

        public Method setArgumentType(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.argument_type_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getArgumentType(Charset cs) {
            return ProtocolSupport.toString(this.argument_type_, cs);
        }

        public Method setArgumentType(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.argument_type_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getResultTypeAsBytes() {
            return this.result_type_;
        }

        public final boolean hasResultType() {
            return (this.optional_0_ & 4) != 0;
        }

        public Method clearResultType() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.result_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setResultTypeAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.result_type_ = x;
            return this;
        }

        public final String getResultType() {
            return ProtocolSupport.toStringUtf8(this.result_type_);
        }

        public Method setResultType(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.result_type_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getResultType(Charset cs) {
            return ProtocolSupport.toString(this.result_type_, cs);
        }

        public Method setResultType(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.result_type_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getStreamTypeAsBytes() {
            return this.stream_type_;
        }

        public final boolean hasStreamType() {
            return (this.optional_0_ & 8) != 0;
        }

        public Method clearStreamType() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.stream_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setStreamTypeAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.stream_type_ = x;
            return this;
        }

        public final String getStreamType() {
            return ProtocolSupport.toStringUtf8(this.stream_type_);
        }

        public Method setStreamType(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.stream_type_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getStreamType(Charset cs) {
            return ProtocolSupport.toString(this.stream_type_, cs);
        }

        public Method setStreamType(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.stream_type_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getProtocolAsBytes() {
            return this.protocol_;
        }

        public final boolean hasProtocol() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public Method clearProtocol() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.protocol_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setProtocolAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.protocol_ = x;
            return this;
        }

        public final String getProtocol() {
            return ProtocolSupport.toStringUtf8(this.protocol_);
        }

        public Method setProtocol(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.protocol_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getProtocol(Charset cs) {
            return ProtocolSupport.toString(this.protocol_, cs);
        }

        public Method setProtocol(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.protocol_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final double getDeadline() {
            return this.deadline_;
        }

        public final boolean hasDeadline() {
            return (this.optional_0_ & 0x20) != 0;
        }

        public Method clearDeadline() {
            this.optional_0_ &= 0xFFFFFFDF;
            this.deadline_ = 0.0;
            return this;
        }

        public Method setDeadline(double x) {
            this.optional_0_ |= 0x20;
            this.deadline_ = x;
            return this;
        }

        public final boolean isDuplicateSuppression() {
            return this.duplicate_suppression_;
        }

        public final boolean hasDuplicateSuppression() {
            return (this.optional_0_ & 0x40) != 0;
        }

        public Method clearDuplicateSuppression() {
            this.optional_0_ &= 0xFFFFFFBF;
            this.duplicate_suppression_ = false;
            return this;
        }

        public Method setDuplicateSuppression(boolean x) {
            this.optional_0_ |= 0x40;
            this.duplicate_suppression_ = x;
            return this;
        }

        public final boolean isFailFast() {
            return this.fail_fast_;
        }

        public final boolean hasFailFast() {
            return (this.optional_0_ & 0x80) != 0;
        }

        public Method clearFailFast() {
            this.optional_0_ &= 0xFFFFFF7F;
            this.fail_fast_ = false;
            return this;
        }

        public Method setFailFast(boolean x) {
            this.optional_0_ |= 0x80;
            this.fail_fast_ = x;
            return this;
        }

        public final int getClientLogging() {
            return this.client_logging_;
        }

        public final boolean hasClientLogging() {
            return (this.optional_0_ & 0x100) != 0;
        }

        public Method clearClientLogging() {
            this.optional_0_ &= 0xFFFFFEFF;
            this.client_logging_ = 0;
            return this;
        }

        public Method setClientLogging(int x) {
            this.optional_0_ |= 0x100;
            this.client_logging_ = x;
            return this;
        }

        public final int getServerLogging() {
            return this.server_logging_;
        }

        public final boolean hasServerLogging() {
            return (this.optional_0_ & 0x200) != 0;
        }

        public Method clearServerLogging() {
            this.optional_0_ &= 0xFFFFFDFF;
            this.server_logging_ = 0;
            return this;
        }

        public Method setServerLogging(int x) {
            this.optional_0_ |= 0x200;
            this.server_logging_ = x;
            return this;
        }

        public final byte[] getSecurityLevelAsBytes() {
            return this.security_level_;
        }

        public final boolean hasSecurityLevel() {
            return (this.optional_0_ & 0x400) != 0;
        }

        public Method clearSecurityLevel() {
            this.optional_0_ &= 0xFFFFFBFF;
            this.security_level_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setSecurityLevelAsBytes(byte[] x) {
            this.optional_0_ |= 0x400;
            this.security_level_ = x;
            return this;
        }

        public final String getSecurityLevel() {
            return ProtocolSupport.toStringUtf8(this.security_level_);
        }

        public Method setSecurityLevel(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x400;
            this.security_level_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getSecurityLevel(Charset cs) {
            return ProtocolSupport.toString(this.security_level_, cs);
        }

        public Method setSecurityLevel(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x400;
            this.security_level_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getResponseFormatAsBytes() {
            return this.response_format_;
        }

        public final boolean hasResponseFormat() {
            return (this.optional_0_ & 0x800) != 0;
        }

        public Method clearResponseFormat() {
            this.optional_0_ &= 0xFFFFF7FF;
            this.response_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setResponseFormatAsBytes(byte[] x) {
            this.optional_0_ |= 0x800;
            this.response_format_ = x;
            return this;
        }

        public final String getResponseFormat() {
            return ProtocolSupport.toStringUtf8(this.response_format_);
        }

        public Method setResponseFormat(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x800;
            this.response_format_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getResponseFormat(Charset cs) {
            return ProtocolSupport.toString(this.response_format_, cs);
        }

        public Method setResponseFormat(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x800;
            this.response_format_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getRequestFormatAsBytes() {
            return this.request_format_;
        }

        public final boolean hasRequestFormat() {
            return (this.optional_0_ & 0x1000) != 0;
        }

        public Method clearRequestFormat() {
            this.optional_0_ &= 0xFFFFEFFF;
            this.request_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Method setRequestFormatAsBytes(byte[] x) {
            this.optional_0_ |= 0x1000;
            this.request_format_ = x;
            return this;
        }

        public final String getRequestFormat() {
            return ProtocolSupport.toStringUtf8(this.request_format_);
        }

        public Method setRequestFormat(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x1000;
            this.request_format_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getRequestFormat(Charset cs) {
            return ProtocolSupport.toString(this.request_format_, cs);
        }

        public Method setRequestFormat(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x1000;
            this.request_format_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public Method mergeFrom(Method that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.name_ = that.name_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.argument_type_ = that.argument_type_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.result_type_ = that.result_type_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.stream_type_ = that.stream_type_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.protocol_ = that.protocol_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                this.deadline_ = that.deadline_;
            }
            if ((that_t0 & 0x40) != 0) {
                this_t0 |= 0x40;
                this.duplicate_suppression_ = that.duplicate_suppression_;
            }
            if ((that_t0 & 0x80) != 0) {
                this_t0 |= 0x80;
                this.fail_fast_ = that.fail_fast_;
            }
            if ((that_t0 & 0x100) != 0) {
                this_t0 |= 0x100;
                this.client_logging_ = that.client_logging_;
            }
            if ((that_t0 & 0x200) != 0) {
                this_t0 |= 0x200;
                this.server_logging_ = that.server_logging_;
            }
            if ((that_t0 & 0x400) != 0) {
                this_t0 |= 0x400;
                this.security_level_ = that.security_level_;
            }
            if ((that_t0 & 0x800) != 0) {
                this_t0 |= 0x800;
                this.response_format_ = that.response_format_;
            }
            if ((that_t0 & 0x1000) != 0) {
                this_t0 |= 0x1000;
                this.request_format_ = that.request_format_;
            }
            if ((that_t0 & 0x2000) != 0) {
                this_t0 |= 0x2000;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Method that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Method that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Method that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFDFFF) != (that_t0 & 0xFFFFDFFF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.name_, that.name_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.argument_type_, that.argument_type_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.result_type_, that.result_type_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && !Arrays.equals(this.stream_type_, that.stream_type_)) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !Arrays.equals(this.protocol_, that.protocol_)) {
                return false;
            }
            if ((this_t0 & 0x20) != 0 && this.deadline_ != that.deadline_) {
                return false;
            }
            if ((this_t0 & 0x40) != 0 && this.duplicate_suppression_ != that.duplicate_suppression_) {
                return false;
            }
            if ((this_t0 & 0x80) != 0 && this.fail_fast_ != that.fail_fast_) {
                return false;
            }
            if ((this_t0 & 0x100) != 0 && this.client_logging_ != that.client_logging_) {
                return false;
            }
            if ((this_t0 & 0x200) != 0 && this.server_logging_ != that.server_logging_) {
                return false;
            }
            if ((this_t0 & 0x400) != 0 && !Arrays.equals(this.security_level_, that.security_level_)) {
                return false;
            }
            if ((this_t0 & 0x800) != 0 && !Arrays.equals(this.response_format_, that.response_format_)) {
                return false;
            }
            if ((this_t0 & 0x1000) != 0 && !Arrays.equals(this.request_format_, that.request_format_)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x2000) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Method && this.equals((Method)that);
        }

        @Override
        public int hashCode() {
            int hash = 209991589;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.name_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.argument_type_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.result_type_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? Arrays.hashCode(this.protocol_) : -113);
            hash = hash * 31 + ((this_t0 & 0x20) != 0 ? ProtocolSupport.hashCode(this.deadline_) : -113);
            hash = hash * 31 + ((this_t0 & 0x40) != 0 ? (this.duplicate_suppression_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 0x80) != 0 ? (this.fail_fast_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 0x100) != 0 ? this.client_logging_ : -113);
            hash = hash * 31 + ((this_t0 & 0x200) != 0 ? this.server_logging_ : -113);
            hash = hash * 31 + ((this_t0 & 0x400) != 0 ? Arrays.hashCode(this.security_level_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.stream_type_) : -113);
            hash = hash * 31 + ((this_t0 & 0x800) != 0 ? Arrays.hashCode(this.response_format_) : -113);
            hash = hash * 31 + ((this_t0 & 0x1000) != 0 ? Arrays.hashCode(this.request_format_) : -113);
            if ((this_t0 & 0x2000) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 7) != 7) {
                if ((this_t0 & 1) == 0) {
                    return false;
                }
                if ((this_t0 & 2) == 0) {
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 4 + Protocol.stringSize(this.name_.length) + Protocol.stringSize(this.argument_type_.length) + Protocol.stringSize(this.result_type_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x7F8) != 0) {
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize(this.stream_type_.length);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.stringSize(this.protocol_.length);
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 9;
                }
                if ((this_t0 & 0x40) != 0) {
                    n += 2;
                }
                if ((this_t0 & 0x80) != 0) {
                    n += 2;
                }
                if ((this_t0 & 0x100) != 0) {
                    n += 1 + Protocol.varLongSize(this.client_logging_);
                }
                if ((this_t0 & 0x200) != 0) {
                    n += 1 + Protocol.varLongSize(this.server_logging_);
                }
                if ((this_t0 & 0x400) != 0) {
                    n += 1 + Protocol.stringSize(this.security_level_.length);
                }
            }
            if ((this_t0 & 0x1800) != 0) {
                if ((this_t0 & 0x800) != 0) {
                    n += 1 + Protocol.stringSize(this.response_format_.length);
                }
                if ((this_t0 & 0x1000) != 0) {
                    n += 2 + Protocol.stringSize(this.request_format_.length);
                }
            }
            return (this_t0 & 0x2000) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 54 + this.name_.length + this.argument_type_.length + this.result_type_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1C18) != 0) {
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.stream_type_.length;
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 6 + this.protocol_.length;
                }
                if ((this_t0 & 0x400) != 0) {
                    n += 6 + this.security_level_.length;
                }
                if ((this_t0 & 0x800) != 0) {
                    n += 6 + this.response_format_.length;
                }
                if ((this_t0 & 0x1000) != 0) {
                    n += 7 + this.request_format_.length;
                }
            }
            return (this_t0 & 0x2000) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x2000;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.argument_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.result_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.stream_type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.protocol_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.deadline_ = 0.0;
            this.duplicate_suppression_ = false;
            this.fail_fast_ = false;
            this.client_logging_ = 0;
            this.server_logging_ = 0;
            this.security_level_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.response_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.request_format_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public Method newInstance() {
            return new Method();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)34);
            sink.putPrefixedData(this.name_);
            sink.putByte((byte)42);
            sink.putPrefixedData(this.argument_type_);
            sink.putByte((byte)50);
            sink.putPrefixedData(this.result_type_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)58);
                sink.putPrefixedData(this.protocol_);
            }
            if ((this_t0 & 0x20) != 0) {
                sink.putByte((byte)65);
                sink.putDouble(this.deadline_);
            }
            if ((this_t0 & 0x40) != 0) {
                sink.putByte((byte)72);
                sink.putBoolean(this.duplicate_suppression_);
            }
            if ((this_t0 & 0x80) != 0) {
                sink.putByte((byte)80);
                sink.putBoolean(this.fail_fast_);
            }
            if ((this_t0 & 0x100) != 0) {
                sink.putByte((byte)88);
                sink.putVarLong(this.client_logging_);
            }
            if ((this_t0 & 0x200) != 0) {
                sink.putByte((byte)96);
                sink.putVarLong(this.server_logging_);
            }
            if ((this_t0 & 0x400) != 0) {
                sink.putByte((byte)106);
                sink.putPrefixedData(this.security_level_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)114);
                sink.putPrefixedData(this.stream_type_);
            }
            if ((this_t0 & 0x800) != 0) {
                sink.putByte((byte)122);
                sink.putPrefixedData(this.response_format_);
            }
            if ((this_t0 & 0x1000) != 0) {
                sink.putByte((byte)-118);
                sink.putByte((byte)1);
                sink.putPrefixedData(this.request_format_);
            }
            if ((this_t0 & 0x2000) != 0) {
                this.uninterpreted.put(sink);
            }
            sink.putByte((byte)28);
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block17: while (true) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 28: {
                        break block17;
                    }
                    case 0: {
                        result = false;
                        break block17;
                    }
                    case 34: {
                        this.name_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block17;
                    }
                    case 42: {
                        this.argument_type_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block17;
                    }
                    case 50: {
                        this.result_type_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block17;
                    }
                    case 58: {
                        this.protocol_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block17;
                    }
                    case 65: {
                        this.deadline_ = source.getDouble();
                        this_t0 |= 0x20;
                        continue block17;
                    }
                    case 72: {
                        this.duplicate_suppression_ = source.getBoolean();
                        this_t0 |= 0x40;
                        continue block17;
                    }
                    case 80: {
                        this.fail_fast_ = source.getBoolean();
                        this_t0 |= 0x80;
                        continue block17;
                    }
                    case 88: {
                        this.client_logging_ = source.getVarInt();
                        this_t0 |= 0x100;
                        continue block17;
                    }
                    case 96: {
                        this.server_logging_ = source.getVarInt();
                        this_t0 |= 0x200;
                        continue block17;
                    }
                    case 106: {
                        this.security_level_ = source.getPrefixedData();
                        this_t0 |= 0x400;
                        continue block17;
                    }
                    case 114: {
                        this.stream_type_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block17;
                    }
                    case 122: {
                        this.response_format_ = source.getPrefixedData();
                        this_t0 |= 0x800;
                        continue block17;
                    }
                    case 138: {
                        this.request_format_ = source.getPrefixedData();
                        this_t0 |= 0x1000;
                        continue block17;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x2000;
                        continue block17;
                    }
                }
                break;
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public Method getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final Method getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public Method freeze() {
            this.name_ = ProtocolSupport.freezeString(this.name_);
            this.argument_type_ = ProtocolSupport.freezeString(this.argument_type_);
            this.result_type_ = ProtocolSupport.freezeString(this.result_type_);
            this.stream_type_ = ProtocolSupport.freezeString(this.stream_type_);
            this.protocol_ = ProtocolSupport.freezeString(this.protocol_);
            this.security_level_ = ProtocolSupport.freezeString(this.security_level_);
            this.response_format_ = ProtocolSupport.freezeString(this.response_format_);
            this.request_format_ = ProtocolSupport.freezeString(this.request_format_);
            return this;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Method.class, null, new ProtocolType.FieldType("name", "name", 4, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("argument_type", "argument_type", 5, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("result_type", "result_type", 6, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("stream_type", "stream_type", 14, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("protocol", "protocol", 7, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("deadline", "deadline", 8, 5, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("duplicate_suppression", "duplicate_suppression", 9, 6, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("fail_fast", "fail_fast", 10, 7, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("client_logging", "client_logging", 11, 8, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("server_logging", "server_logging", 12, 9, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("security_level", "security_level", 13, 10, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("response_format", "response_format", 15, 11, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("request_format", "request_format", 17, 12, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }
}

