/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.jsontoken.JsonWebSignature;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.JsonParser;
import com.google.appengine.repackaged.com.google.api.client.json.JsonToken;
import com.google.appengine.repackaged.com.google.api.client.util.Clock;
import com.google.appengine.repackaged.com.google.api.client.util.StringUtils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoogleIdTokenVerifier {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("\\s*max-age\\s*=\\s*(\\d+)\\s*");
    private final JsonFactory jsonFactory;
    private List<PublicKey> publicKeys;
    private long expirationTimeMilliseconds;
    private Set<String> clientIds;
    private final HttpTransport transport;
    private final Lock lock = new ReentrantLock();
    private final Clock clock;

    public GoogleIdTokenVerifier(HttpTransport transport, JsonFactory jsonFactory) {
        this(null, transport, jsonFactory);
    }

    protected GoogleIdTokenVerifier(Set<String> clientIds, HttpTransport transport, JsonFactory jsonFactory) {
        this(clientIds, transport, jsonFactory, Clock.SYSTEM);
    }

    protected GoogleIdTokenVerifier(Set<String> clientIds, HttpTransport transport, JsonFactory jsonFactory, Clock clock) {
        this.clientIds = clientIds == null ? Collections.emptySet() : Collections.unmodifiableSet(clientIds);
        this.transport = Preconditions.checkNotNull(transport);
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.clock = Preconditions.checkNotNull(clock);
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final Set<String> getClientIds() {
        return this.clientIds;
    }

    public final List<PublicKey> getPublicKeys() {
        return this.publicKeys;
    }

    public final long getExpirationTimeMilliseconds() {
        return this.expirationTimeMilliseconds;
    }

    public boolean verify(GoogleIdToken idToken) throws GeneralSecurityException, IOException {
        return this.verify(this.clientIds, idToken);
    }

    public GoogleIdToken verify(String idTokenString) throws GeneralSecurityException, IOException {
        GoogleIdToken idToken = GoogleIdToken.parse(this.jsonFactory, idTokenString);
        return this.verify(idToken) ? idToken : null;
    }

    public boolean verify(GoogleIdToken idToken, String clientId) throws GeneralSecurityException, IOException {
        return this.verify(clientId == null ? Collections.emptySet() : Collections.singleton(clientId), idToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(Set<String> clientIds, GoogleIdToken idToken) throws GeneralSecurityException, IOException {
        GoogleIdToken.Payload payload = idToken.getPayload();
        if (!(payload.isValidTime(300L) && "accounts.google.com".equals(payload.getIssuer()) && (clientIds.isEmpty() || clientIds.contains(payload.getAudience()) && clientIds.contains(payload.getIssuee())))) {
            return false;
        }
        JsonWebSignature.Header header = idToken.getHeader();
        String algorithm = header.getAlgorithm();
        if (algorithm.equals("RS256")) {
            this.lock.lock();
            try {
                if (this.publicKeys == null || this.clock.currentTimeMillis() + 300000L > this.expirationTimeMilliseconds) {
                    this.loadPublicCerts();
                }
                Signature signer = Signature.getInstance("SHA256withRSA");
                for (PublicKey publicKey : this.publicKeys) {
                    signer.initVerify(publicKey);
                    signer.update(idToken.getSignedContentBytes());
                    if (!signer.verify(idToken.getSignatureBytes())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleIdTokenVerifier loadPublicCerts() throws GeneralSecurityException, IOException {
        this.lock.lock();
        try {
            JsonParser parser;
            JsonToken currentToken;
            this.publicKeys = new ArrayList<PublicKey>();
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            HttpResponse certsResponse = this.transport.createRequestFactory().buildGetRequest(new GenericUrl("https://www.googleapis.com/oauth2/v1/certs")).execute();
            for (String arg : certsResponse.getHeaders().getCacheControl().split(",")) {
                Matcher m = MAX_AGE_PATTERN.matcher(arg);
                if (!m.matches()) continue;
                this.expirationTimeMilliseconds = this.clock.currentTimeMillis() + Long.valueOf(m.group(1)) * 1000L;
                break;
            }
            if ((currentToken = (parser = this.jsonFactory.createJsonParser(certsResponse.getContent())).getCurrentToken()) == null) {
                currentToken = parser.nextToken();
            }
            Preconditions.checkArgument(currentToken == JsonToken.START_OBJECT);
            try {
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    parser.nextToken();
                    String certValue = parser.getText();
                    X509Certificate x509Cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(StringUtils.getBytesUtf8(certValue)));
                    this.publicKeys.add(x509Cert.getPublicKey());
                }
                this.publicKeys = Collections.unmodifiableList(this.publicKeys);
            }
            finally {
                parser.close();
            }
            GoogleIdTokenVerifier googleIdTokenVerifier = this;
            return googleIdTokenVerifier;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class Builder {
        private final HttpTransport transport;
        private final JsonFactory jsonFactory;
        private Set<String> clientIds = new HashSet<String>();

        public Builder(HttpTransport transport, JsonFactory jsonFactory) {
            this.transport = transport;
            this.jsonFactory = jsonFactory;
        }

        public GoogleIdTokenVerifier build() {
            return new GoogleIdTokenVerifier(this.clientIds, this.transport, this.jsonFactory);
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public final Set<String> getClientIds() {
            return this.clientIds;
        }

        public Builder setClientIds(Iterable<String> clientIds) {
            this.clientIds.clear();
            for (String clientId : clientIds) {
                this.clientIds.add(clientId);
            }
            return this;
        }

        public Builder setClientIds(String ... clientIds) {
            this.clientIds.clear();
            Collections.addAll(this.clientIds, clientIds);
            return this;
        }
    }
}

