/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http;

import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpStatusCodes;
import com.google.appengine.repackaged.com.google.api.client.util.StringUtils;
import java.io.IOException;

public class HttpResponseException
extends IOException {
    private static final long serialVersionUID = -1875819453475890043L;
    private final int statusCode;
    private final String statusMessage;
    private final transient HttpHeaders headers;

    public HttpResponseException(HttpResponse response) {
        this(response, HttpResponseException.computeMessageWithContent(response));
    }

    public HttpResponseException(HttpResponse response, String message) {
        super(message);
        this.statusCode = response.getStatusCode();
        this.statusMessage = response.getStatusMessage();
        this.headers = response.getHeaders();
    }

    public final boolean isSuccessStatusCode() {
        return HttpStatusCodes.isSuccess(this.statusCode);
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    private static String computeMessageWithContent(HttpResponse response) {
        StringBuilder builder = HttpResponseException.computeMessageBuffer(response);
        String content = "";
        try {
            content = response.parseAsString();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (content.length() != 0) {
            builder.append(StringUtils.LINE_SEPARATOR).append(content);
        }
        return builder.toString();
    }

    public static StringBuilder computeMessageBuffer(HttpResponse response) {
        String statusMessage;
        StringBuilder builder = new StringBuilder();
        int statusCode = response.getStatusCode();
        if (statusCode != 0) {
            builder.append(statusCode);
        }
        if ((statusMessage = response.getStatusMessage()) != null) {
            if (statusCode != 0) {
                builder.append(' ');
            }
            builder.append(statusMessage);
        }
        return builder;
    }
}

