/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.Renderer;
import com.google.appengine.tools.appstats.StatsProtos;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppstatsServlet
extends HttpServlet {
    private static final String PREFIX = "/apphosting/ext/appstats/static/";
    private static final Map<String, String> CONTENT_TYPES;
    private boolean requireAdminAuthentication = true;
    private final MemcacheWriter memcache;
    private final Renderer renderer;
    Recorder.Clock clock = new Recorder.Clock();

    AppstatsServlet(MemcacheWriter writer, Renderer renderer) {
        this.memcache = writer;
        this.renderer = renderer;
    }

    public AppstatsServlet() {
        this(new MemcacheWriter(new Recorder.Clock(), MemcacheServiceFactory.getMemcacheService((String)"__appstats__")), new Renderer());
    }

    public void init(ServletConfig config) throws ServletException {
        String requireAuthParam = config.getInitParameter("requireAdminAuthentication");
        if (requireAuthParam != null) {
            this.requireAdminAuthentication = "yes".equalsIgnoreCase(requireAuthParam) || "true".equalsIgnoreCase(requireAuthParam);
        }
    }

    private boolean requireAdminAuthentication(UserService userService, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.requireAdminAuthentication) {
            return true;
        }
        if (!userService.isUserLoggedIn()) {
            resp.sendRedirect(userService.createLoginURL(req.getRequestURI()));
            return false;
        }
        if (!userService.isUserAdmin()) {
            resp.sendError(403);
            return false;
        }
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        if (path == null) {
            resp.sendRedirect(req.getServletPath() + "/stats");
        } else if (path.startsWith("/static/")) {
            this.serveStaticContent(req, resp);
        } else if (path.equals("/details")) {
            StatsProtos.RequestStatProto data;
            try {
                long asTimeStamp = Long.parseLong(req.getParameter("time"));
                data = this.memcache.getFull(asTimeStamp);
            }
            catch (NumberFormatException e) {
                data = null;
            }
            if (data == null) {
                resp.sendError(404);
                return;
            }
            this.authenticateAndServeDetails(data, req, resp);
        } else if (path.equals("/stats")) {
            if (!this.requireAdminAuthentication(UserServiceFactory.getUserService(), req, resp)) {
                return;
            }
            this.renderer.renderSummaries(resp.getWriter(), this.memcache.getSummaries());
        } else {
            resp.sendRedirect(req.getServletPath() + "/stats");
        }
    }

    private void authenticateAndServeDetails(StatsProtos.RequestStatProto data, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String type = req.getParameter("type");
        UserService userService = UserServiceFactory.getUserService();
        if (type == null) {
            if (this.requireAdminAuthentication(userService, req, resp)) {
                this.renderer.renderDetails(resp.getWriter(), data);
            }
            return;
        }
        if ("json".equalsIgnoreCase(type)) {
            if (this.requireAdminAuthentication(userService, req, resp)) {
                resp.setContentType("application/json");
                this.renderer.renderDetailsAsJson(resp.getWriter(), data);
            } else {
                resp.sendError(403);
            }
            return;
        }
        resp.sendError(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serveStaticContent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ext;
        String resource = req.getRequestURI();
        resource = PREFIX + resource.substring(resource.lastIndexOf(47) + 1);
        URL byName = AppstatsServlet.class.getResource(resource);
        if (byName == null) {
            resp.sendError(404);
            return;
        }
        if (resource.lastIndexOf(46) < 0) {
            resp.sendError(404);
        }
        if (!CONTENT_TYPES.containsKey(ext = resource.substring(resource.toLowerCase().lastIndexOf(46) + 1))) {
            resp.sendError(404);
        }
        resp.addHeader("Content-type", CONTENT_TYPES.get(ext));
        resp.addHeader("Cache-Control", "public, max-age=expiry");
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        resp.addHeader("Expires", httpDateFormat.format(new Date(this.clock.currentTimeMillis() + 3600000L)));
        ServletOutputStream out = resp.getOutputStream();
        InputStream in = byName.openStream();
        try {
            byte[] b = new byte[256];
            int len = in.read(b);
            while (len > 0) {
                out.write(b, 0, len);
                len = in.read(b);
            }
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    static {
        HashMap<String, String> contentTypes = new HashMap<String, String>();
        contentTypes.put("css", "text/css");
        contentTypes.put("js", "application/javascript");
        contentTypes.put("gif", "image/gif");
        CONTENT_TYPES = Collections.unmodifiableMap(contentTypes);
    }
}

