/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Hashing;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@GwtIncompatible(value="java.util.Arrays#copyOf(Object[], int), java.lang.reflect.Array")
@GoogleInternal
public class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 1.0f;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    private static final long HASH_MASK = -4294967296L;
    private static final int DEFAULT_SIZE = 3;
    private transient int[] table;
    private transient long[] entries;
    transient Object[] elements;
    transient float loadFactor;
    transient int modCount;
    private transient int threshold;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        CompactHashSet<E> set = CompactHashSet.createWithExpectedSize(collection.size());
        set.addAll(collection);
        return set;
    }

    public static <E> CompactHashSet<E> create(E ... elements) {
        CompactHashSet<E> set = CompactHashSet.createWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int expectedSize) {
        return new CompactHashSet<E>(expectedSize);
    }

    CompactHashSet() {
        this.init(3, 1.0f);
    }

    CompactHashSet(int capacity) {
        this.init(capacity, 1.0f);
    }

    void init(int initialCapacity, float loadFactor) {
        Preconditions.checkArgument(initialCapacity >= 0, "Initial capacity must be non-negative");
        Preconditions.checkArgument(loadFactor > 0.0f, "Illegal load factor");
        int buckets = CompactHashSet.tableSizeFor(initialCapacity);
        this.table = CompactHashSet.newTable(buckets);
        this.loadFactor = loadFactor;
        this.elements = new Object[initialCapacity];
        this.entries = CompactHashSet.newEntries(initialCapacity);
        this.threshold = Math.max(1, (int)((float)buckets * loadFactor));
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static int[] newTable(int size) {
        int[] array = new int[size];
        Arrays.fill(array, -1);
        return array;
    }

    private static long[] newEntries(int size) {
        long[] array = new long[size];
        Arrays.fill(array, -1L);
        return array;
    }

    private static int getHash(long entry) {
        return (int)(entry >>> 32);
    }

    private static int getNext(long entry) {
        return (int)entry;
    }

    private static long swapNext(long entry, int newNext) {
        return 0xFFFFFFFF00000000L & entry | 0xFFFFFFFFL & (long)newNext;
    }

    @Override
    public boolean add(@Nullable E object) {
        long[] entries = this.entries;
        Object[] elements = this.elements;
        int hash = Hashing.smear(object == null ? 0 : object.hashCode());
        int tableIndex = hash & this.table.length - 1;
        int newEntryIndex = this.size;
        int next = this.table[tableIndex];
        if (next == -1) {
            this.table[tableIndex] = newEntryIndex;
        } else {
            long entry;
            do {
                Object e;
                int last = next;
                entry = entries[next];
                if (CompactHashSet.getHash(entry) != hash || object != (e = elements[next]) && (object == null || !object.equals(e))) continue;
                return false;
            } while ((next = CompactHashSet.getNext(entry)) != -1);
            entries[last] = CompactHashSet.swapNext(entry, newEntryIndex);
        }
        if (newEntryIndex == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        int newSize = newEntryIndex + 1;
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, object, hash);
        this.size = newSize;
        if (newEntryIndex >= this.threshold) {
            this.resizeTable(2 * this.table.length);
        }
        ++this.modCount;
        return true;
    }

    void insertEntry(int entryIndex, E object, int hash) {
        this.entries[entryIndex] = (long)hash << 32 | 0xFFFFFFFFL;
        this.elements[entryIndex] = object;
    }

    private void resizeMeMaybe(int newSize) {
        int entriesSize = this.entries.length;
        if (newSize > entriesSize) {
            int newCapacity = entriesSize + Math.max(1, entriesSize >>> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            if (newCapacity != entriesSize) {
                this.resizeEntries(newCapacity);
            }
        }
    }

    void resizeEntries(int newCapacity) {
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        long[] entries = this.entries;
        int oldSize = entries.length;
        entries = Arrays.copyOf(entries, newCapacity);
        if (newCapacity > oldSize) {
            Arrays.fill(entries, oldSize, newCapacity, -1L);
        }
        this.entries = entries;
    }

    private void resizeTable(int newCapacity) {
        int[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newThreshold = 1 + (int)((float)newCapacity * this.loadFactor);
        int[] newTable = CompactHashSet.newTable(newCapacity);
        long[] entries = this.entries;
        int mask = newTable.length - 1;
        for (int i = 0; i < this.size; ++i) {
            long oldEntry = entries[i];
            int hash = CompactHashSet.getHash(oldEntry);
            int tableIndex = hash & mask;
            int next = newTable[tableIndex];
            newTable[tableIndex] = i;
            entries[i] = next != -1 ? (long)hash << 32 | 0xFFFFFFFFL & (long)next : (long)hash << 32 | 0xFFFFFFFFL;
        }
        this.threshold = newThreshold;
        this.table = newTable;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        int hash = Hashing.smear(object == null ? 0 : object.hashCode());
        int next = this.table[hash & this.table.length - 1];
        while (next != -1) {
            Object e;
            long entry = this.entries[next];
            if (CompactHashSet.getHash(entry) == hash && (object == (e = this.elements[next]) || object != null && object.equals(e))) {
                return true;
            }
            next = CompactHashSet.getNext(entry);
        }
        return false;
    }

    @Override
    public boolean remove(@Nullable Object object) {
        return this.remove(object, object == null ? 0 : Hashing.smear(object.hashCode()));
    }

    private boolean remove(Object object, int hash) {
        int tableIndex = hash & this.table.length - 1;
        int next = this.table[tableIndex];
        if (next == -1) {
            return false;
        }
        int last = -1;
        do {
            Object e;
            if (CompactHashSet.getHash(this.entries[next]) == hash && (object == (e = this.elements[next]) || object != null && object.equals(e))) {
                if (last == -1) {
                    this.table[tableIndex] = CompactHashSet.getNext(this.entries[next]);
                } else {
                    this.entries[last] = CompactHashSet.swapNext(this.entries[last], CompactHashSet.getNext(this.entries[next]));
                }
                this.moveEntry(next);
                --this.size;
                ++this.modCount;
                return true;
            }
            last = next;
        } while ((next = CompactHashSet.getNext(this.entries[next])) != -1);
        return false;
    }

    void moveEntry(int dstIndex) {
        int srcIndex = this.size() - 1;
        if (dstIndex < srcIndex) {
            long lastEntry;
            this.elements[dstIndex] = this.elements[srcIndex];
            this.elements[srcIndex] = null;
            this.entries[dstIndex] = lastEntry = this.entries[srcIndex];
            this.entries[srcIndex] = -1L;
            int tableIndex = CompactHashSet.getHash(lastEntry) & this.table.length - 1;
            int lastNext = this.table[tableIndex];
            if (lastNext == srcIndex) {
                this.table[tableIndex] = dstIndex;
            } else {
                long entry;
                do {
                    int previous = lastNext;
                } while ((lastNext = CompactHashSet.getNext(entry = this.entries[lastNext])) != srcIndex);
                this.entries[previous] = CompactHashSet.swapNext(entry, dstIndex);
            }
        } else {
            this.elements[dstIndex] = null;
            this.entries[dstIndex] = -1L;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int expectedModCount;
            boolean nextCalled;
            int index;
            {
                this.expectedModCount = CompactHashSet.this.modCount;
                this.nextCalled = false;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < CompactHashSet.this.size;
            }

            @Override
            public E next() {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextCalled = true;
                return CompactHashSet.this.elements[this.index++];
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                if (!this.nextCalled) {
                    throw new IllegalStateException();
                }
                ++this.expectedModCount;
                --this.index;
                CompactHashSet.this.remove(CompactHashSet.this.elements[this.index], CompactHashSet.getHash(CompactHashSet.this.entries[this.index]));
                this.nextCalled = false;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size;
        Object[] elements = this.elements;
        T[] array = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        System.arraycopy(elements, 0, array, 0, size);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    public void trimToSize() {
        double load;
        int minimumTableSize;
        int size = this.size;
        if (size < this.entries.length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = Math.max(1, Integer.highestOneBit((int)((float)size / this.loadFactor)))) < 0x40000000 && (load = (double)size / (double)minimumTableSize) > (double)this.loadFactor) {
            minimumTableSize <<= 1;
        }
        if (minimumTableSize < this.table.length) {
            this.resizeTable(minimumTableSize);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.elements, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, -1L);
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.table.length);
        stream.writeFloat(this.loadFactor);
        stream.writeInt(this.size);
        for (E e : this) {
            stream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int length = stream.readInt();
        float loadFactor = stream.readFloat();
        int elementCount = stream.readInt();
        try {
            this.init(length, loadFactor);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException(e.getMessage());
        }
        int i = elementCount;
        while (--i >= 0) {
            Object element = stream.readObject();
            this.add(element);
        }
    }
}

